/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class IntegrationTest
extends TestCase {
    public void testIntegration() throws CreationException {
        final CountingInterceptor counter = new CountingInterceptor();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class);
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{counter});
            }
        }});
        Foo foo = (Foo)injector.getInstance(Key.get(Foo.class));
        foo.foo();
        IntegrationTest.assertTrue((boolean)foo.invoked);
        IntegrationTest.assertEquals((int)1, (int)counter.count);
        foo = (Foo)injector.getInstance(Foo.class);
        foo.foo();
        IntegrationTest.assertTrue((boolean)foo.invoked);
        IntegrationTest.assertEquals((int)2, (int)counter.count);
    }

    static class CountingInterceptor
    implements MethodInterceptor {
        int count;

        CountingInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            ++this.count;
            return methodInvocation.proceed();
        }
    }

    static class Foo {
        boolean invoked;

        Foo() {
        }

        public void foo() {
            this.invoked = true;
        }
    }
}

