/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.Message;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MethodInterceptionTest
extends TestCase {
    private AtomicInteger count = new AtomicInteger();

    public void testSharedProxyClasses() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{new ReturnNullInterceptor()});
            }
        }});
        Injector childOne = injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Interceptable.class);
            }
        }});
        Interceptable nullFoosOne = (Interceptable)childOne.getInstance(Interceptable.class);
        MethodInterceptionTest.assertNotNull((Object)nullFoosOne.bar());
        MethodInterceptionTest.assertNull((Object)nullFoosOne.foo());
        Injector childTwo = injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Interceptable.class);
            }
        }});
        Interceptable nullFoosTwo = (Interceptable)childTwo.getInstance(Interceptable.class);
        MethodInterceptionTest.assertNull((Object)nullFoosTwo.foo());
        MethodInterceptionTest.assertSame((String)"Child injectors should share proxy classes, otherwise memory leaks!", nullFoosOne.getClass(), nullFoosTwo.getClass());
        Injector injector2 = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{new ReturnNullInterceptor()});
            }
        }});
        Interceptable separateNullFoos = (Interceptable)injector2.getInstance(Interceptable.class);
        MethodInterceptionTest.assertNull((Object)separateNullFoos.foo());
        MethodInterceptionTest.assertSame((String)"different injectors should share proxy classes, otherwise memory leaks!", nullFoosOne.getClass(), separateNullFoos.getClass());
    }

    public void testGetThis() {
        final AtomicReference lastTarget = new AtomicReference();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(){

                    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                        lastTarget.set(methodInvocation.getThis());
                        return methodInvocation.proceed();
                    }
                }});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        interceptable.foo();
        MethodInterceptionTest.assertSame((Object)interceptable, lastTarget.get());
    }

    public void testInterceptingFinalClass() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(){

                    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                        return methodInvocation.proceed();
                    }
                }});
            }
        }});
        try {
            injector.getInstance(NotInterceptable.class);
            MethodInterceptionTest.fail();
        }
        catch (ConfigurationException ce) {
            MethodInterceptionTest.assertEquals((String)("Unable to method intercept: " + NotInterceptable.class.getName()), (String)((Message)Iterables.getOnlyElement((Iterable)ce.getErrorMessages())).getMessage().toString());
            MethodInterceptionTest.assertEquals((String)("Cannot subclass final class " + NotInterceptable.class.getName()), (String)ce.getCause().getMessage());
        }
    }

    public void testSpiAccessToInterceptors() throws NoSuchMethodException {
        final CountingInterceptor countingInterceptor = new CountingInterceptor();
        final ReturnNullInterceptor returnNullInterceptor = new ReturnNullInterceptor();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{countingInterceptor});
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class).or(Matchers.only(Bar.class))), new MethodInterceptor[]{returnNullInterceptor});
            }
        }});
        ConstructorBinding interceptedBinding = (ConstructorBinding)injector.getBinding(Interceptable.class);
        Method barMethod = Interceptable.class.getMethod("bar", new Class[0]);
        Method fooMethod = Interceptable.class.getMethod("foo", new Class[0]);
        MethodInterceptionTest.assertEquals((Object)ImmutableMap.of((Object)fooMethod, (Object)ImmutableList.of((Object)countingInterceptor, (Object)returnNullInterceptor), (Object)barMethod, (Object)ImmutableList.of((Object)returnNullInterceptor)), (Object)interceptedBinding.getMethodInterceptors());
        ConstructorBinding nonInterceptedBinding = (ConstructorBinding)injector.getBinding(Foo.class);
        MethodInterceptionTest.assertEquals((Object)ImmutableMap.of(), (Object)nonInterceptedBinding.getMethodInterceptors());
        ((Interceptable)injector.getInstance(Interceptable.class)).foo();
        MethodInterceptionTest.assertEquals((String)"expected counting interceptor to be invoked first", (int)1, (int)this.count.get());
    }

    public void testInterceptedMethodThrows() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new CountingInterceptor()});
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new CountingInterceptor()});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        try {
            interceptable.explode();
            MethodInterceptionTest.fail();
        }
        catch (Exception e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                StackTraceElement[] stackTraceElement = t.getStackTrace();
                MethodInterceptionTest.assertEquals((String)"explode", (String)stackTraceElement[0].getMethodName());
                MethodInterceptionTest.assertEquals((String)"invoke", (String)stackTraceElement[1].getMethodName());
                MethodInterceptionTest.assertEquals((String)"invoke", (String)stackTraceElement[2].getMethodName());
                MethodInterceptionTest.assertEquals((String)"testInterceptedMethodThrows", (String)stackTraceElement[3].getMethodName());
            }
        }
    }

    public void testNotInterceptedMethodsInInterceptedClassDontAddFrames() {
        int i;
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{new NoOpInterceptor()});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        MethodInterceptionTest.assertNull((Object)interceptable.lastElements);
        interceptable.foo();
        boolean cglibFound = false;
        for (i = 0; i < interceptable.lastElements.length; ++i) {
            if (!interceptable.lastElements[i].toString().contains("cglib")) continue;
            cglibFound = true;
            break;
        }
        MethodInterceptionTest.assertTrue((String)Arrays.toString(interceptable.lastElements), (boolean)cglibFound);
        cglibFound = false;
        interceptable.bar();
        for (i = 0; i < interceptable.lastElements.length; ++i) {
            if (!interceptable.lastElements[i].toString().contains("cglib")) continue;
            cglibFound = true;
            break;
        }
        MethodInterceptionTest.assertFalse((String)Arrays.toString(interceptable.lastElements), (boolean)cglibFound);
    }

    public void testInterceptingNonBridgeWorks() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Interface.class).to(Impl.class);
                this.bindInterceptor(Matchers.any(), (Matcher)new AbstractMatcher<Method>(){

                    public boolean matches(Method t) {
                        return !t.isBridge() && t.getDeclaringClass() != Object.class;
                    }
                }, new MethodInterceptor[]{new CountingInterceptor()});
            }
        }});
        Interface intf = (Interface)injector.getInstance(Interface.class);
        MethodInterceptionTest.assertEquals((int)0, (int)this.count.get());
        intf.aMethod(null);
        MethodInterceptionTest.assertEquals((int)1, (int)this.count.get());
    }

    public void testInterceptionOrder() {
        final ArrayList callList = Lists.newArrayList();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new NamedInterceptor("a", callList), new NamedInterceptor("b", callList), new NamedInterceptor("c", callList)});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        MethodInterceptionTest.assertEquals((int)0, (int)callList.size());
        interceptable.foo();
        MethodInterceptionTest.assertEquals(Arrays.asList("a", "b", "c"), (Object)callList);
    }

    public void testDeDuplicateInterceptors() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                CountingInterceptor interceptor = new CountingInterceptor();
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor});
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        interceptable.foo();
        MethodInterceptionTest.assertEquals((int)1, (int)this.count.get());
    }

    public void testCallLater() {
        final LinkedList queue = Lists.newLinkedList();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new CallLaterInterceptor(queue)});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        interceptable.foo();
        MethodInterceptionTest.assertNull((Object)interceptable.lastElements);
        MethodInterceptionTest.assertEquals((int)1, (int)queue.size());
        ((Runnable)queue.remove()).run();
        MethodInterceptionTest.assertNotNull((Object)interceptable.lastElements);
    }

    private static final class CallLaterInterceptor
    implements MethodInterceptor {
        private final Queue<Runnable> queue;

        public CallLaterInterceptor(Queue<Runnable> queue) {
            this.queue = queue;
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            this.queue.add(() -> {
                try {
                    methodInvocation.proceed();
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            });
            return null;
        }
    }

    private static final class NamedInterceptor
    implements MethodInterceptor {
        private final String name;
        final List<String> called;

        NamedInterceptor(String name, List<String> callList) {
            this.name = name;
            this.called = callList;
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            this.called.add(this.name);
            return methodInvocation.proceed();
        }
    }

    public static class Impl
    extends Superclass<RetType>
    implements Interface {
    }

    public static interface Interface {
        public RetType aMethod(RetType var1);
    }

    static abstract class Superclass<T extends ErasedType> {
        Superclass() {
        }

        public T aMethod(T t) {
            return null;
        }
    }

    static class RetType
    extends ErasedType {
        RetType() {
        }
    }

    static class ErasedType {
        ErasedType() {
        }
    }

    public static final class NotInterceptable {
    }

    public static class Interceptable {
        StackTraceElement[] lastElements;

        public Foo foo() {
            this.lastElements = Thread.currentThread().getStackTrace();
            return new Foo(){};
        }

        public Bar bar() {
            this.lastElements = Thread.currentThread().getStackTrace();
            return new Bar(){};
        }

        public String explode() throws Exception {
            this.lastElements = Thread.currentThread().getStackTrace();
            throw new Exception("kaboom!", new RuntimeException("boom!"));
        }
    }

    static class Bar {
        Bar() {
        }
    }

    static class Foo {
        Foo() {
        }
    }

    private static final class NoOpInterceptor
    implements MethodInterceptor {
        private NoOpInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            return methodInvocation.proceed();
        }
    }

    private static final class ReturnNullInterceptor
    implements MethodInterceptor {
        private ReturnNullInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            return null;
        }
    }

    private final class CountingInterceptor
    implements MethodInterceptor {
        private CountingInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            MethodInterceptionTest.this.count.incrementAndGet();
            return methodInvocation.proceed();
        }
    }
}

