/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.base.Optional;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import junit.framework.TestCase;

public class NullableInjectionPointTest
extends TestCase {
    public void testInjectNullIntoNotNullableConstructor() {
        try {
            this.createInjector().getInstance(FooConstructor.class);
            NullableInjectionPointTest.fail((String)"Injecting null should fail with an error");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "null returned by binding at " + ((Object)((Object)this)).getClass().getName(), "the 1st parameter of " + FooConstructor.class.getName() + ".<init>(", "is not @Nullable");
        }
    }

    public void testInjectNullIntoNotNullableMethod() {
        try {
            this.createInjector().getInstance(FooMethod.class);
            NullableInjectionPointTest.fail((String)"Injecting null should fail with an error");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "null returned by binding at " + ((Object)((Object)this)).getClass().getName(), "the 1st parameter of " + FooMethod.class.getName() + ".setFoo(", "is not @Nullable");
        }
    }

    public void testInjectNullIntoNotNullableField() {
        try {
            this.createInjector().getInstance(FooField.class);
            NullableInjectionPointTest.fail((String)"Injecting null should fail with an error");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "null returned by binding at " + ((Object)((Object)this)).getClass().getName(), " but " + FooField.class.getName() + ".foo", " is not @Nullable");
        }
    }

    public void testGetInstanceOfNull() {
        NullableInjectionPointTest.assertNull((Object)this.createInjector().getInstance(Foo.class));
    }

    public void testInjectNullIntoNullableConstructor() {
        NullableFooConstructor nfc = (NullableFooConstructor)this.createInjector().getInstance(NullableFooConstructor.class);
        NullableInjectionPointTest.assertNull((Object)nfc.foo);
    }

    public void testInjectNullIntoNullableMethod() {
        NullableFooMethod nfm = (NullableFooMethod)this.createInjector().getInstance(NullableFooMethod.class);
        NullableInjectionPointTest.assertNull((Object)nfm.foo);
    }

    public void testInjectNullIntoNullableField() {
        NullableFooField nff = (NullableFooField)this.createInjector().getInstance(NullableFooField.class);
        NullableInjectionPointTest.assertNull((Object)nff.foo);
    }

    public void testInjectNullIntoCustomNullableConstructor() {
        CustomNullableFooConstructor nfc = (CustomNullableFooConstructor)this.createInjector().getInstance(CustomNullableFooConstructor.class);
        NullableInjectionPointTest.assertNull((Object)nfc.foo);
    }

    public void testInjectNullIntoCustomNullableMethod() {
        CustomNullableFooMethod nfm = (CustomNullableFooMethod)this.createInjector().getInstance(CustomNullableFooMethod.class);
        NullableInjectionPointTest.assertNull((Object)nfm.foo);
    }

    public void testInjectNullIntoCustomNullableField() {
        CustomNullableFooField nff = (CustomNullableFooField)this.createInjector().getInstance(CustomNullableFooField.class);
        NullableInjectionPointTest.assertNull((Object)nff.foo);
    }

    private Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toProvider(Providers.of(null));
            }
        }});
    }

    public void testBindNullToInstance() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(Foo.class).toInstance(null);
                }
            }});
            NullableInjectionPointTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Binding to null instances is not allowed.", "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testBindNullToProvider() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toProvider(Providers.of(null));
            }
        }});
        NullableInjectionPointTest.assertNull((Object)((NullableFooField)injector.getInstance(NullableFooField.class)).foo);
        NullableInjectionPointTest.assertNull((Object)((CustomNullableFooField)injector.getInstance(CustomNullableFooField.class)).foo);
        try {
            injector.getInstance(FooField.class);
            NullableInjectionPointTest.fail((String)"Expected ProvisionException");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "null returned by binding at");
        }
    }

    public void testBindScopedNull() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toProvider(Providers.of(null)).in(Scopes.SINGLETON);
            }
        }});
        NullableInjectionPointTest.assertNull((Object)((NullableFooField)injector.getInstance(NullableFooField.class)).foo);
        NullableInjectionPointTest.assertNull((Object)((CustomNullableFooField)injector.getInstance(CustomNullableFooField.class)).foo);
        try {
            injector.getInstance(FooField.class);
            NullableInjectionPointTest.fail((String)"Expected ProvisionException");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "null returned by binding at");
        }
    }

    public void testBindNullAsEagerSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toProvider(Providers.of(null)).asEagerSingleton();
            }
        }});
        NullableInjectionPointTest.assertNull((Object)((NullableFooField)injector.getInstance(NullableFooField.class)).foo);
        NullableInjectionPointTest.assertNull((Object)((CustomNullableFooField)injector.getInstance(CustomNullableFooField.class)).foo);
        try {
            injector.getInstance(FooField.class);
            NullableInjectionPointTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "null returned by binding at com.google.inject.NullableInjectionPointTest");
        }
    }

    public void testBindNullAndLinkFromOptionalBinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toProvider(Providers.of(null));
                OptionalBinder.newOptionalBinder((Binder)this.binder(), Foo.class);
            }

            @Provides
            @Named(value="throughProvidesMethod")
            Foo provideFoo(Optional<Foo> foo) {
                return (Foo)foo.orNull();
            }
        }});
        NullableInjectionPointTest.assertNull((Object)injector.getInstance(Key.get(Foo.class, (Annotation)Names.named((String)"throughProvidesMethod"))));
    }

    static interface Namespace {

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.PARAMETER, ElementType.FIELD})
        public static @interface Nullable {
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.FIELD})
    static @interface Nullable {
    }

    static class CustomNullableFooMethod {
        Foo foo;

        CustomNullableFooMethod() {
        }

        @Inject
        void setFoo(@Namespace.Nullable Foo foo) {
            this.foo = foo;
        }
    }

    static class CustomNullableFooField {
        @Inject
        @Namespace.Nullable
        Foo foo;

        CustomNullableFooField() {
        }
    }

    static class CustomNullableFooConstructor {
        Foo foo;

        @Inject
        CustomNullableFooConstructor(@Namespace.Nullable Foo foo) {
            this.foo = foo;
        }
    }

    static class NullableFooMethod {
        Foo foo;

        NullableFooMethod() {
        }

        @Inject
        void setFoo(@Nullable Foo foo) {
            this.foo = foo;
        }
    }

    static class NullableFooField {
        @Inject
        @Nullable
        Foo foo;

        NullableFooField() {
        }
    }

    static class NullableFooConstructor {
        Foo foo;

        @Inject
        NullableFooConstructor(@Nullable Foo foo) {
            this.foo = foo;
        }
    }

    static class FooMethod {
        FooMethod() {
        }

        @Inject
        void setFoo(Foo foo) {
        }
    }

    static class FooField {
        @Inject
        Foo foo;

        FooField() {
        }
    }

    static class FooConstructor {
        @Inject
        FooConstructor(Foo foo) {
        }
    }

    static class Foo {
        Foo() {
        }
    }
}

