/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.spi.ElementSource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import junit.framework.TestCase;

public class ReflectionTest
extends TestCase {
    public void testNormalBinding() throws CreationException {
        final Foo foo = new Foo();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Foo.class).toInstance((Object)foo);
            }
        }});
        Binding fooBinding = injector.getBinding(Key.get(Foo.class));
        ReflectionTest.assertSame((Object)foo, (Object)fooBinding.getProvider().get());
        ElementSource source = (ElementSource)fooBinding.getSource();
        ReflectionTest.assertNotNull((Object)source.getDeclaringSource());
        ReflectionTest.assertEquals((Object)Key.get(Foo.class), (Object)fooBinding.getKey());
    }

    public void testConstantBinding() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(I.class).to(5);
            }
        }});
        Binding i = injector.getBinding(Key.get(Integer.TYPE, I.class));
        ReflectionTest.assertEquals((Object)5, (Object)i.getProvider().get());
        ElementSource source = (ElementSource)i.getSource();
        ReflectionTest.assertNotNull((Object)source.getDeclaringSource());
        ReflectionTest.assertEquals((Object)Key.get(Integer.TYPE, I.class), (Object)i.getKey());
    }

    public void testLinkedBinding() throws CreationException {
        final Bar bar = new Bar();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Bar.class).toInstance((Object)bar);
                this.bind(Key.get(Foo.class)).to(Key.get(Bar.class));
            }
        }});
        Binding fooBinding = injector.getBinding(Key.get(Foo.class));
        ReflectionTest.assertSame((Object)bar, (Object)fooBinding.getProvider().get());
        ElementSource source = (ElementSource)fooBinding.getSource();
        ReflectionTest.assertNotNull((Object)source.getDeclaringSource());
        ReflectionTest.assertEquals((Object)Key.get(Foo.class), (Object)fooBinding.getKey());
    }

    static class Bar
    extends Foo {
        Bar() {
        }
    }

    static class Foo {
        Foo() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface I {
    }
}

