/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.Message;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class ScopesTest
extends TestCase {
    static final long DEADLOCK_TIMEOUT_SECONDS = 1L;
    private final AbstractModule singletonsModule = new AbstractModule(){

        protected void configure() {
            this.bind(BoundAsSingleton.class).in(Scopes.SINGLETON);
            this.bind(AnnotatedSingleton.class);
            this.bind(EagerSingleton.class).asEagerSingleton();
            this.bind(LinkedSingleton.class).to(RealLinkedSingleton.class);
            this.bind(DependsOnJustInTimeSingleton.class);
            this.bind(NotASingleton.class);
            this.bind(ImplementedBySingleton.class).in(Scopes.SINGLETON);
            this.bind(ProvidedBySingleton.class).in(Scopes.SINGLETON);
        }
    };
    static final Scope CUSTOM_SCOPE = new Scope(){

        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            return Scopes.SINGLETON.scope(key, unscoped);
        }
    };

    protected void setUp() throws Exception {
        AnnotatedSingleton.nextInstanceId = 0;
        BoundAsSingleton.nextInstanceId = 0;
        EagerSingleton.nextInstanceId = 0;
        RealLinkedSingleton.nextInstanceId = 0;
        JustInTimeSingleton.nextInstanceId = 0;
        NotASingleton.nextInstanceId = 0;
        Implementation.nextInstanceId = 0;
        ProvidedBySingleton.nextInstanceId = 0;
        ThrowingSingleton.nextInstanceId = 0;
    }

    public void testSingletons() {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.singletonsModule});
        ScopesTest.assertSame((Object)injector.getInstance(BoundAsSingleton.class), (Object)injector.getInstance(BoundAsSingleton.class));
        ScopesTest.assertSame((Object)injector.getInstance(AnnotatedSingleton.class), (Object)injector.getInstance(AnnotatedSingleton.class));
        ScopesTest.assertSame((Object)injector.getInstance(EagerSingleton.class), (Object)injector.getInstance(EagerSingleton.class));
        ScopesTest.assertSame((Object)injector.getInstance(LinkedSingleton.class), (Object)injector.getInstance(LinkedSingleton.class));
        ScopesTest.assertSame((Object)injector.getInstance(JustInTimeSingleton.class), (Object)injector.getInstance(JustInTimeSingleton.class));
        ScopesTest.assertNotSame((Object)injector.getInstance(NotASingleton.class), (Object)injector.getInstance(NotASingleton.class));
        ScopesTest.assertSame((Object)injector.getInstance(ImplementedBySingleton.class), (Object)injector.getInstance(ImplementedBySingleton.class));
        ScopesTest.assertSame((Object)injector.getInstance(ProvidedBySingleton.class), (Object)injector.getInstance(ProvidedBySingleton.class));
    }

    public void testJustInTimeAnnotatedSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ScopesTest.assertSame((Object)injector.getInstance(AnnotatedSingleton.class), (Object)injector.getInstance(AnnotatedSingleton.class));
    }

    public void testSingletonIsPerInjector() {
        ScopesTest.assertNotSame((Object)Guice.createInjector((Module[])new Module[0]).getInstance(AnnotatedSingleton.class), (Object)Guice.createInjector((Module[])new Module[0]).getInstance(AnnotatedSingleton.class));
    }

    public void testOverriddingAnnotation() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(AnnotatedSingleton.class).in(Scopes.NO_SCOPE);
            }
        }});
        ScopesTest.assertNotSame((Object)injector.getInstance(AnnotatedSingleton.class), (Object)injector.getInstance(AnnotatedSingleton.class));
    }

    public void testScopingAnnotationsOnAbstractTypeViaBind() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(A.class).to(AImpl.class);
                }
            }});
            ScopesTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), A.class.getName() + " is annotated with " + Singleton.class.getName(), "but scope annotations are not supported for abstract types.", "at " + A.class.getName() + ".class(ScopesTest.java:");
        }
    }

    public void testScopingAnnotationsOnAbstractTypeIsValidForComponent() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ComponentAnnotationTest.class).to(ComponentAnnotationTestImpl.class);
            }
        }});
    }

    public void testScopingAnnotationsOnAbstractTypeViaImplementedBy() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(D.class);
            ScopesTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), D.class.getName() + " is annotated with " + Singleton.class.getName(), "but scope annotations are not supported for abstract types.", "at " + D.class.getName() + ".class(ScopesTest.java:");
        }
    }

    public void testScopingAnnotationsOnAbstractTypeViaProvidedBy() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(E.class);
            ScopesTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), E.class.getName() + " is annotated with " + Singleton.class.getName(), "but scope annotations are not supported for abstract types.", "at " + E.class.getName() + ".class(ScopesTest.java:");
        }
    }

    public void testScopeUsedButNotBound() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(B.class).in(CustomScoped.class);
                    this.bind(C.class);
                }
            }});
            ScopesTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No scope is bound to " + CustomScoped.class.getName(), "at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), "2) No scope is bound to " + CustomScoped.class.getName(), "at " + C.class.getName() + ".class");
        }
    }

    public void testSingletonsInProductionStage() {
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.singletonsModule});
        ScopesTest.assertEquals((int)1, (int)AnnotatedSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)1, (int)BoundAsSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)1, (int)EagerSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)1, (int)RealLinkedSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)1, (int)JustInTimeSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)0, (int)NotASingleton.nextInstanceId);
    }

    public void testSingletonsInDevelopmentStage() {
        Guice.createInjector((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{this.singletonsModule});
        ScopesTest.assertEquals((int)0, (int)AnnotatedSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)0, (int)BoundAsSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)1, (int)EagerSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)0, (int)RealLinkedSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)0, (int)JustInTimeSingleton.nextInstanceId);
        ScopesTest.assertEquals((int)0, (int)NotASingleton.nextInstanceId);
    }

    public void testSingletonScopeIsNotSerializable() throws IOException {
        Asserts.assertNotSerializable(Scopes.SINGLETON);
    }

    public void testNoScopeIsNotSerializable() throws IOException {
        Asserts.assertNotSerializable(Scopes.NO_SCOPE);
    }

    public void testUnscopedProviderWorksOutsideOfRequestedScope() {
        final RememberProviderScope scope = new RememberProviderScope();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(CustomScoped.class, scope);
                this.bind(List.class).to(ArrayList.class).in(CustomScoped.class);
            }
        }});
        injector.getInstance(List.class);
        Provider<?> listProvider = scope.providers.get(Key.get(List.class));
        ScopesTest.assertTrue((boolean)(listProvider.get() instanceof ArrayList));
    }

    public void testScopeAnnotationWithoutRuntimeRetention() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterRuntimeModule()});
            ScopesTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Please annotate " + NotRuntimeRetainedScoped.class.getName() + " with @Retention(RUNTIME).", "at " + InnerRuntimeModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterRuntimeModule.class, InnerRuntimeModule.class));
        }
    }

    public void testBindScopeToAnnotationWithoutScopeAnnotation() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterDeprecatedModule()});
            ScopesTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Please annotate " + Deprecated.class.getName() + " with @ScopeAnnotation.", "at " + InnerDeprecatedModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterDeprecatedModule.class, InnerDeprecatedModule.class));
        }
    }

    public void testBindScopeTooManyTimes() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterScopeModule()});
            ScopesTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Scope Scopes.NO_SCOPE is already bound to " + CustomScoped.class.getName() + " at " + CustomNoScopeModule.class.getName() + Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterScopeModule.class, CustomNoScopeModule.class), "Cannot bind Scopes.SINGLETON.", "at " + ScopesTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterScopeModule.class, CustomSingletonModule.class));
        }
    }

    public void testBindDuplicateScope() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(CustomScoped.class, Scopes.SINGLETON);
                this.bindScope(CustomScoped.class, Scopes.SINGLETON);
            }
        }});
        ScopesTest.assertSame((Object)injector.getInstance(AnnotatedCustomScoped.class), (Object)injector.getInstance(AnnotatedCustomScoped.class));
    }

    public void testDuplicateScopeAnnotations() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(CustomScoped.class, Scopes.NO_SCOPE);
            }
        }});
        try {
            injector.getInstance(SingletonAndCustomScoped.class);
            ScopesTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) More than one scope annotation was found: ", "while locating " + SingletonAndCustomScoped.class.getName());
        }
    }

    public void testNullScopedAsASingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){
            final Iterator<String> values = Arrays.asList(null, "A").iterator();

            @Provides
            @Singleton
            String provideString() {
                return this.values.next();
            }
        }});
        ScopesTest.assertNull((Object)injector.getInstance(String.class));
        ScopesTest.assertNull((Object)injector.getInstance(String.class));
        ScopesTest.assertNull((Object)injector.getInstance(String.class));
    }

    public void testSingletonAnnotationOnParameterizedType() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ScopesTest.assertSame((Object)injector.getInstance((Key)new Key<Injected<String>>(){}), (Object)injector.getInstance((Key)new Key<Injected<String>>(){}));
        ScopesTest.assertSame((Object)injector.getInstance((Key)new Key<In<Integer>>(){}), (Object)injector.getInstance((Key)new Key<In<Short>>(){}));
    }

    public void testScopeThatGetsAnUnrelatedObject() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class);
                this.bind(C.class);
                ProviderGetScope providerGetScope = new ProviderGetScope();
                this.requestInjection(providerGetScope);
                this.bindScope(CustomScoped.class, providerGetScope);
            }
        }});
        injector.getInstance(C.class);
    }

    public void testIsSingletonPositive() {
        final Key a = Key.get(String.class, (Annotation)Names.named((String)"A"));
        final Key b = Key.get(String.class, (Annotation)Names.named((String)"B"));
        final Key c = Key.get(String.class, (Annotation)Names.named((String)"C"));
        final Key d = Key.get(String.class, (Annotation)Names.named((String)"D"));
        final Key e = Key.get(String.class, (Annotation)Names.named((String)"E"));
        final Key f = Key.get(String.class, (Annotation)Names.named((String)"F"));
        Key g = Key.get(String.class, (Annotation)Names.named((String)"G"));
        final Key h = Key.get(Object.class, (Annotation)Names.named((String)"H"));
        final Key i = Key.get(String.class, (Annotation)Names.named((String)"I"));
        AbstractModule singletonBindings = new AbstractModule(){

            protected void configure() {
                this.bind(a).to(b);
                this.bind(b).to(c);
                this.bind(c).toProvider(Providers.of((Object)"c")).in(Scopes.SINGLETON);
                this.bind(d).toInstance((Object)"d");
                this.bind(e).toProvider(Providers.of((Object)"e")).asEagerSingleton();
                this.bind(f).toProvider(Providers.of((Object)"f")).in(Singleton.class);
                this.bind(h).to(AnnotatedSingleton.class);
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                        this.bind(i).toProvider(Providers.of((Object)"i")).in(Singleton.class);
                        this.expose(i);
                    }
                });
            }

            @Provides
            @Named(value="G")
            @Singleton
            String provideG() {
                return "g";
            }
        };
        List moduleBindings = Elements.getElements((Module[])new Module[]{singletonBindings});
        ImmutableMap<Key<?>, Binding<?>> map = this.indexBindings(moduleBindings);
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)a))));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)b))));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)c))));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)d))));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)e))));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)f))));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)g))));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)h))));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)i))));
        Injector injector = Guice.createInjector((Module[])new Module[]{singletonBindings});
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(a)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(b)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(c)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(d)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(e)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(f)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(g)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(h)));
        ScopesTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(i)));
    }

    public void testIsSingletonNegative() {
        final Key a = Key.get(String.class, (Annotation)Names.named((String)"A"));
        final Key b = Key.get(String.class, (Annotation)Names.named((String)"B"));
        final Key c = Key.get(String.class, (Annotation)Names.named((String)"C"));
        final Key d = Key.get(String.class, (Annotation)Names.named((String)"D"));
        Key e = Key.get(String.class, (Annotation)Names.named((String)"E"));
        final Key f = Key.get(String.class, (Annotation)Names.named((String)"F"));
        AbstractModule singletonBindings = new AbstractModule(){

            protected void configure() {
                this.bind(a).to(b);
                this.bind(b).to(c);
                this.bind(c).toProvider(Providers.of((Object)"c")).in(Scopes.NO_SCOPE);
                this.bind(d).toProvider(Providers.of((Object)"d")).in(CustomScoped.class);
                this.bindScope(CustomScoped.class, Scopes.NO_SCOPE);
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                        this.bind(f).toProvider(Providers.of((Object)"f")).in(CustomScoped.class);
                        this.expose(f);
                    }
                });
            }

            @Provides
            @Named(value="E")
            @CustomScoped
            String provideE() {
                return "e";
            }
        };
        List moduleBindings = Elements.getElements((Module[])new Module[]{singletonBindings});
        ImmutableMap<Key<?>, Binding<?>> map = this.indexBindings(moduleBindings);
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)a))));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)b))));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)c))));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)d))));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)e))));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)((Binding)map.get((Object)f))));
        Injector injector = Guice.createInjector((Module[])new Module[]{singletonBindings});
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)injector.getBinding(a)));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)injector.getBinding(b)));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)injector.getBinding(c)));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)injector.getBinding(d)));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)injector.getBinding(e)));
        ScopesTest.assertFalse((boolean)Scopes.isSingleton((Binding)injector.getBinding(f)));
    }

    public void testIsScopedPositive() {
        final Key a = Key.get(String.class, (Annotation)Names.named((String)"A"));
        final Key b = Key.get(String.class, (Annotation)Names.named((String)"B"));
        final Key c = Key.get(String.class, (Annotation)Names.named((String)"C"));
        final Key d = Key.get(String.class, (Annotation)Names.named((String)"D"));
        Key e = Key.get(String.class, (Annotation)Names.named((String)"E"));
        final Key f = Key.get(Object.class, (Annotation)Names.named((String)"F"));
        final Key g = Key.get(String.class, (Annotation)Names.named((String)"G"));
        AbstractModule customBindings = new AbstractModule(){

            protected void configure() {
                this.bindScope(CustomScoped.class, CUSTOM_SCOPE);
                this.bind(a).to(b);
                this.bind(b).to(c);
                this.bind(c).toProvider(Providers.of((Object)"c")).in(CUSTOM_SCOPE);
                this.bind(d).toProvider(Providers.of((Object)"d")).in(CustomScoped.class);
                this.bind(f).to(AnnotatedCustomScoped.class);
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                        this.bind(g).toProvider(Providers.of((Object)"g")).in(CustomScoped.class);
                        this.expose(g);
                    }
                });
            }

            @Provides
            @Named(value="E")
            @CustomScoped
            String provideE() {
                return "e";
            }
        };
        List moduleBindings = Elements.getElements((Module[])new Module[]{customBindings});
        ImmutableMap<Key<?>, Binding<?>> map = this.indexBindings(moduleBindings);
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)a)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)b)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped((Binding)map.get((Object)c)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped((Binding)map.get((Object)d)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped((Binding)map.get((Object)e)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)f)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped((Binding)map.get((Object)g)));
        Injector injector = Guice.createInjector((Module[])new Module[]{customBindings});
        ScopesTest.assertTrue((boolean)this.isCustomScoped(injector.getBinding(a)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped(injector.getBinding(b)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped(injector.getBinding(c)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped(injector.getBinding(d)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped(injector.getBinding(e)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped(injector.getBinding(f)));
        ScopesTest.assertTrue((boolean)this.isCustomScoped(injector.getBinding(g)));
    }

    public void testIsScopedNegative() {
        final Key a = Key.get(String.class, (Annotation)Names.named((String)"A"));
        final Key b = Key.get(String.class, (Annotation)Names.named((String)"B"));
        final Key c = Key.get(String.class, (Annotation)Names.named((String)"C"));
        final Key d = Key.get(String.class, (Annotation)Names.named((String)"D"));
        Key e = Key.get(String.class, (Annotation)Names.named((String)"E"));
        final Key f = Key.get(String.class, (Annotation)Names.named((String)"F"));
        final Key g = Key.get(String.class, (Annotation)Names.named((String)"G"));
        final Key h = Key.get(String.class, (Annotation)Names.named((String)"H"));
        AbstractModule customBindings = new AbstractModule(){

            protected void configure() {
                this.bind(a).to(b);
                this.bind(b).to(c);
                this.bind(c).toProvider(Providers.of((Object)"c")).in(Scopes.NO_SCOPE);
                this.bind(d).toProvider(Providers.of((Object)"d")).in(Singleton.class);
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                        this.bind(f).toProvider(Providers.of((Object)"f")).in(Singleton.class);
                        this.expose(f);
                    }
                });
                this.bind(g).toInstance((Object)"g");
                this.bind(h).toProvider(Providers.of((Object)"h")).asEagerSingleton();
            }

            @Provides
            @Named(value="E")
            @Singleton
            String provideE() {
                return "e";
            }
        };
        List moduleBindings = Elements.getElements((Module[])new Module[]{customBindings});
        ImmutableMap<Key<?>, Binding<?>> map = this.indexBindings(moduleBindings);
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)a)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)b)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)c)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)d)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)e)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)f)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)g)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped((Binding)map.get((Object)h)));
        Injector injector = Guice.createInjector((Module[])new Module[]{customBindings});
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(a)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(b)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(c)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(d)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(e)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(f)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(g)));
        ScopesTest.assertFalse((boolean)this.isCustomScoped(injector.getBinding(h)));
    }

    private boolean isCustomScoped(Binding<?> binding) {
        return Scopes.isScoped(binding, (Scope)CUSTOM_SCOPE, CustomScoped.class);
    }

    ImmutableMap<Key<?>, Binding<?>> indexBindings(Iterable<Element> elements) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Element element : elements) {
            if (element instanceof Binding) {
                Binding binding = (Binding)element;
                builder.put((Object)binding.getKey(), (Object)binding);
                continue;
            }
            if (!(element instanceof PrivateElements)) continue;
            PrivateElements privateElements = (PrivateElements)element;
            ImmutableMap<Key<?>, Binding<?>> privateBindings = this.indexBindings(privateElements.getElements());
            for (Key exposed : privateElements.getExposedKeys()) {
                builder.put((Object)exposed, privateBindings.get(exposed));
            }
        }
        return builder.build();
    }

    public void testSingletonConstructorThrows() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            injector.getInstance(ThrowingSingleton.class);
            ScopesTest.fail();
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        injector.getInstance(ThrowingSingleton.class);
        ScopesTest.assertEquals((int)2, (int)ThrowingSingleton.nextInstanceId);
    }

    public void testInjectorsDontDeadlockOnSingletons() throws Exception {
        final SBarrierProvider provider = new SBarrierProvider(2);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Thread.currentThread().setName("S.class[1]");
                this.bind(S.class).toProvider(provider).in(Scopes.SINGLETON);
            }
        }});
        Injector secondInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Thread.currentThread().setName("S.class[2]");
                this.bind(S.class).toProvider(provider).in(Scopes.SINGLETON);
            }
        }});
        Future<S> secondThreadResult = Executors.newSingleThreadExecutor().submit(() -> (S)secondInjector.getInstance(S.class));
        S firstS = (S)injector.getInstance(S.class);
        S secondS = secondThreadResult.get();
        ScopesTest.assertNotSame((Object)firstS, (Object)secondS);
    }

    public void testSiblingInjectorGettingCircularSingletonsOneCircularProxy() throws Exception {
        final SBarrierProvider provider = new SBarrierProvider(2);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(S.class).toProvider(provider);
            }
        }});
        Future<G> firstThreadResult = Executors.newSingleThreadExecutor().submit(() -> {
            Thread.currentThread().setName("G.class");
            return (G)injector.createChildInjector(new Module[0]).getInstance(G.class);
        });
        Future<H> secondThreadResult = Executors.newSingleThreadExecutor().submit(() -> {
            Thread.currentThread().setName("H.class");
            return (H)injector.createChildInjector(new Module[0]).getInstance(H.class);
        });
        GImpl g = (GImpl)firstThreadResult.get(3L, TimeUnit.SECONDS);
        HImpl h = (HImpl)secondThreadResult.get(3L, TimeUnit.SECONDS);
        ScopesTest.assertTrue((!Scopes.isCircularProxy((Object)g) && !Scopes.isCircularProxy((Object)h) ? 1 : 0) != 0);
        ScopesTest.assertFalse((Scopes.isCircularProxy((Object)g.h) && Scopes.isCircularProxy((Object)h.g) ? 1 : 0) != 0);
        ScopesTest.assertTrue((g.h == h || h.g == g ? 1 : 0) != 0);
        ScopesTest.assertEquals((Object)g.h, (Object)h);
        ScopesTest.assertEquals((Object)h.g, (Object)g);
    }

    public void testUnresolvableSingletonCircularDependencyErrorMessage() throws Exception {
        final SBarrierProvider provider = new SBarrierProvider(3);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(S.class).toProvider(provider);
            }
        }});
        FutureTask<I0> firstThreadResult = new FutureTask<I0>(() -> (I0)injector.getInstance(I0.class));
        Thread i0Thread = new Thread(firstThreadResult, "I0.class");
        String i0ThreadString = i0Thread.toString();
        i0Thread.start();
        FutureTask<J0> secondThreadResult = new FutureTask<J0>(() -> (J0)injector.getInstance(J0.class));
        Thread j0Thread = new Thread(secondThreadResult, "J0.class");
        String j0ThreadString = j0Thread.toString();
        j0Thread.start();
        FutureTask<K0> thirdThreadResult = new FutureTask<K0>(() -> (K0)injector.getInstance(K0.class));
        Thread k0Thread = new Thread(thirdThreadResult, "K0.class");
        String k0ThreadString = k0Thread.toString();
        k0Thread.start();
        Throwable firstException = null;
        Throwable secondException = null;
        Throwable thirdException = null;
        try {
            firstThreadResult.get(3L, TimeUnit.SECONDS);
            ScopesTest.fail();
        }
        catch (ExecutionException e) {
            firstException = e.getCause();
        }
        try {
            secondThreadResult.get(3L, TimeUnit.SECONDS);
            ScopesTest.fail();
        }
        catch (ExecutionException e) {
            secondException = e.getCause();
        }
        try {
            thirdThreadResult.get(3L, TimeUnit.SECONDS);
            ScopesTest.fail();
        }
        catch (ExecutionException e) {
            thirdException = e.getCause();
        }
        ArrayList errors = new ArrayList();
        errors.addAll(((ProvisionException)firstException).getErrorMessages());
        errors.addAll(((ProvisionException)secondException).getErrorMessages());
        errors.addAll(((ProvisionException)thirdException).getErrorMessages());
        Message spanningError = null;
        for (Message error : errors) {
            if (!error.getMessage().contains("Encountered circular dependency spanning several threads") || spanningError != null && spanningError.getMessage().length() >= error.getMessage().length()) continue;
            spanningError = error;
        }
        if (spanningError == null) {
            ScopesTest.fail((String)("Couldn't find multi thread circular dependency error: " + Joiner.on((String)"\n\n").join(errors)));
        }
        String errorMessage = spanningError.getMessage();
        Asserts.assertContains(errorMessage, "Encountered circular dependency spanning several threads. Tried proxying " + ((Object)((Object)this)).getClass().getName());
        ScopesTest.assertFalse((String)"Both I0 and J0 can not be a part of a dependency cycle", (errorMessage.contains(I0.class.getName()) && errorMessage.contains(J0.class.getName()) ? 1 : 0) != 0);
        ScopesTest.assertFalse((String)"Both J0 and K0 can not be a part of a dependency cycle", (errorMessage.contains(J0.class.getName()) && errorMessage.contains(K0.class.getName()) ? 1 : 0) != 0);
        ScopesTest.assertFalse((String)"Both K0 and I0 can not be a part of a dependency cycle", (errorMessage.contains(K0.class.getName()) && errorMessage.contains(I0.class.getName()) ? 1 : 0) != 0);
        ArrayListMultimap threadToSingletons = ArrayListMultimap.create();
        boolean inSingletonsList = false;
        String currentThread = null;
        for (String errorLine : errorMessage.split("\\n")) {
            if (errorLine.startsWith("Thread[")) {
                inSingletonsList = true;
                currentThread = errorLine.substring(0, errorLine.indexOf(" is holding locks the following singletons in the cycle:"));
                continue;
            }
            if (!inSingletonsList) continue;
            if (errorLine.startsWith("\tat ")) {
                inSingletonsList = false;
                continue;
            }
            threadToSingletons.put((Object)currentThread, (Object)errorLine);
        }
        ScopesTest.assertEquals((String)"All threads should be in the cycle", (int)3, (int)threadToSingletons.keySet().size());
        ScopesTest.assertEquals((Object)threadToSingletons.get((Object)j0ThreadString), (Object)ImmutableList.of((Object)J1.class.getName(), (Object)J2.class.getName(), (Object)K1.class.getName()));
        ScopesTest.assertEquals((Object)threadToSingletons.get((Object)k0ThreadString), (Object)ImmutableList.of((Object)K1.class.getName(), (Object)K2.class.getName(), (Object)I1.class.getName()));
        ScopesTest.assertEquals((Object)threadToSingletons.get((Object)i0ThreadString), (Object)ImmutableList.of((Object)I1.class.getName(), (Object)I2.class.getName(), (Object)J1.class.getName()));
    }

    public void testScopeAppliedByUserInsteadOfScoping() throws Exception {
        Injector injector = Executors.newSingleThreadExecutor().submit(() -> Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new ScopeMutatingProvisionListener()});
                this.bind(SingletonClass.class);
            }
        }})).get();
        injector.getInstance(SingletonClass.class);
    }

    public void testForInstanceOfNoScopingReturnsUnscoped() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(AImpl.class).in(Scopes.NO_SCOPE);
            }
        }});
        ScopesTest.assertTrue((boolean)((Boolean)injector.getBinding(Key.get(AImpl.class)).acceptScopingVisitor((BindingScopingVisitor)new DefaultBindingScopingVisitor<Boolean>(){

            protected Boolean visitOther() {
                return false;
            }

            public Boolean visitNoScoping() {
                return true;
            }
        })));
    }

    public void testScopedLinkedBindingDoesNotPropagateEagerSingleton() {
        final Key a = Key.get(String.class, (Annotation)Names.named((String)"A"));
        final Key b = Key.get(String.class, (Annotation)Names.named((String)"B"));
        final Scope notInScopeScope = new Scope(){

            public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
                return new Provider<T>(){

                    public T get() {
                        throw new IllegalStateException("Not in scope");
                    }
                };
            }
        };
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind(a).toInstance((Object)"a");
                this.bind(b).to(a).in(CustomScoped.class);
                this.bindScope(CustomScoped.class, notInScopeScope);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Provider bProvider = injector.getProvider(b);
        try {
            bProvider.get();
            ScopesTest.fail((String)"expected failure");
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
    }

    private static final class ScopeMutatingProvisionListener
    implements ProvisionListener {
        private ScopeMutatingProvisionListener() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provisionInvocation) {
            provisionInvocation.provision();
            provisionInvocation.getBinding().acceptScopingVisitor((BindingScopingVisitor)new DefaultBindingScopingVisitor<Void>(){

                public Void visitScope(Scope scope) {
                    scope.scope(Key.get(ScopeMarker.class), ScopeMarker.PROVIDER);
                    return null;
                }
            });
        }

        private static class ScopeMarker {
            static final Provider<ScopeMarker> PROVIDER = new Provider<ScopeMarker>(){

                public ScopeMarker get() {
                    return new ScopeMarker();
                }
            };

            private ScopeMarker() {
            }
        }
    }

    @Singleton
    static class SingletonClass {
        SingletonClass() {
        }
    }

    @Singleton
    static class K2 {
        @Inject
        K2(I1 i) {
        }
    }

    @Singleton
    static class K1 {
        @Inject
        K1(S synchronizationBarrier, K2 k) {
        }
    }

    @Singleton
    static class K0 {
        @Inject
        K0(K1 k) {
        }
    }

    @Singleton
    static class J2 {
        @Inject
        J2(K1 k) {
        }
    }

    @Singleton
    static class J1 {
        @Inject
        J1(S synchronizationBarrier, J2 j) {
        }
    }

    @Singleton
    static class J0 {
        @Inject
        J0(J1 j) {
        }
    }

    @Singleton
    static class I2 {
        @Inject
        I2(J1 j) {
        }
    }

    @Singleton
    static class I1 {
        @Inject
        I1(S synchronizationBarrier, I2 i) {
        }
    }

    @Singleton
    static class I0 {
        @Inject
        I0(I1 i) {
        }
    }

    @Singleton
    static class HImpl
    implements H {
        final G g;

        @Inject
        HImpl(S synchronizationBarrier, G g) throws Exception {
            this.g = g;
        }
    }

    @ImplementedBy(value=HImpl.class)
    static interface H {
    }

    @Singleton
    static class GImpl
    implements G {
        final H h;

        @Inject
        GImpl(S synchronizationBarrier, H h) {
            this.h = h;
        }
    }

    @ImplementedBy(value=GImpl.class)
    static interface G {
    }

    static class SBarrierProvider
    implements Provider<S> {
        final CyclicBarrier barrier;
        volatile boolean barrierPassed = false;

        SBarrierProvider(int nThreads) {
            this.barrier = new CyclicBarrier(nThreads, () -> {
                this.barrierPassed = true;
            });
        }

        public S get() {
            try {
                if (!this.barrierPassed) {
                    this.barrier.await(1L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new S(0);
        }
    }

    static class S {
        private S(int preventInjectionWithoutProvider) {
        }
    }

    @Singleton
    static class ThrowingSingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        ThrowingSingleton() {
            if (this.instanceId == 0) {
                throw new RuntimeException();
            }
        }
    }

    class ProviderGetScope
    implements Scope {
        @Inject
        Provider<B> bProvider;

        ProviderGetScope() {
        }

        public <T> Provider<T> scope(Key<T> key, final Provider<T> unscoped) {
            return new Provider<T>(){

                public T get() {
                    ProviderGetScope.this.bProvider.get();
                    return unscoped.get();
                }
            };
        }
    }

    static class ImplementationProvider
    implements Provider<ProvidedBySingleton> {
        ImplementationProvider() {
        }

        public ProvidedBySingleton get() {
            return new ProvidedBySingleton();
        }
    }

    static class Implementation
    implements ImplementedBySingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        Implementation() {
        }
    }

    @ProvidedBy(value=ImplementationProvider.class)
    static class ProvidedBySingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        ProvidedBySingleton() {
        }
    }

    @ImplementedBy(value=Implementation.class)
    static interface ImplementedBySingleton {
    }

    @Singleton
    @CustomScoped
    static class SingletonAndCustomScoped {
        SingletonAndCustomScoped() {
        }
    }

    static class NotASingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        NotASingleton() {
        }
    }

    @Singleton
    static class JustInTimeSingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        JustInTimeSingleton() {
        }
    }

    static class DependsOnJustInTimeSingleton {
        @Inject
        JustInTimeSingleton justInTimeSingleton;

        DependsOnJustInTimeSingleton() {
        }
    }

    @Singleton
    static class RealLinkedSingleton
    implements LinkedSingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        RealLinkedSingleton() {
        }
    }

    static interface LinkedSingleton {
    }

    static class EagerSingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        EagerSingleton() {
        }
    }

    static class BoundAsSingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        BoundAsSingleton() {
        }
    }

    @Singleton
    static class AnnotatedSingleton {
        static int nextInstanceId;
        final int instanceId = nextInstanceId++;

        AnnotatedSingleton() {
        }
    }

    @CustomScoped
    static class AnnotatedCustomScoped {
        AnnotatedCustomScoped() {
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @ScopeAnnotation
    public static @interface NotRuntimeRetainedScoped {
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ScopeAnnotation
    public static @interface CustomScoped {
    }

    @Singleton
    public static class Injected<T>
    implements In<T> {
    }

    @ImplementedBy(value=Injected.class)
    public static interface In<T> {
    }

    class RememberProviderScope
    implements Scope {
        final Map<Key<?>, Provider<?>> providers = Maps.newHashMap();

        RememberProviderScope() {
        }

        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            this.providers.put(key, unscoped);
            return unscoped;
        }
    }

    static class CustomSingletonModule
    extends AbstractModule {
        CustomSingletonModule() {
        }

        protected void configure() {
            this.bindScope(CustomScoped.class, Scopes.SINGLETON);
        }
    }

    static class CustomNoScopeModule
    extends AbstractModule {
        CustomNoScopeModule() {
        }

        protected void configure() {
            this.bindScope(CustomScoped.class, Scopes.NO_SCOPE);
        }
    }

    static class OuterScopeModule
    extends AbstractModule {
        OuterScopeModule() {
        }

        protected void configure() {
            this.install((Module)new CustomNoScopeModule());
            this.install((Module)new CustomSingletonModule());
        }
    }

    static class InnerDeprecatedModule
    extends AbstractModule {
        InnerDeprecatedModule() {
        }

        protected void configure() {
            this.bindScope(Deprecated.class, Scopes.NO_SCOPE);
        }
    }

    static class OuterDeprecatedModule
    extends AbstractModule {
        OuterDeprecatedModule() {
        }

        protected void configure() {
            this.install((Module)new InnerDeprecatedModule());
        }
    }

    static class InnerRuntimeModule
    extends AbstractModule {
        InnerRuntimeModule() {
        }

        protected void configure() {
            this.bindScope(NotRuntimeRetainedScoped.class, Scopes.NO_SCOPE);
        }
    }

    static class OuterRuntimeModule
    extends AbstractModule {
        OuterRuntimeModule() {
        }

        protected void configure() {
            this.install((Module)new InnerRuntimeModule());
        }
    }

    @CustomScoped
    static class C {
        C() {
        }
    }

    static class B {
        B() {
        }
    }

    static class EProvider
    implements Provider<E> {
        EProvider() {
        }

        public E get() {
            return null;
        }
    }

    @Singleton
    @ProvidedBy(value=EProvider.class)
    static interface E {
    }

    static class DImpl
    implements D {
        DImpl() {
        }
    }

    @Singleton
    @ImplementedBy(value=DImpl.class)
    static interface D {
    }

    static class ComponentAnnotationTestImpl
    implements ComponentAnnotationTest {
        ComponentAnnotationTestImpl() {
        }
    }

    @Component
    @Singleton
    static interface ComponentAnnotationTest {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Component {
    }

    static class AImpl
    implements A {
        AImpl() {
        }
    }

    @Singleton
    static interface A {
    }
}

