/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.Message;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TypeListenerTest
extends TestCase {
    private final Matcher<Object> onlyAbcd = Matchers.only((Object)new TypeLiteral<A>(){}).or(Matchers.only((Object)new TypeLiteral<B>(){})).or(Matchers.only((Object)new TypeLiteral<C>(){})).or(Matchers.only((Object)new TypeLiteral<D>(){}));
    final TypeListener failingTypeListener = new TypeListener(){
        int failures = 0;

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            throw new ClassCastException("whoops, failure #" + ++this.failures);
        }

        public String toString() {
            return "clumsy";
        }
    };
    final InjectionListener<Object> failingInjectionListener = new InjectionListener<Object>(){
        int failures = 0;

        public void afterInjection(Object injectee) {
            throw new ClassCastException("whoops, failure #" + ++this.failures);
        }

        public String toString() {
            return "goofy";
        }
    };
    final MembersInjector<Object> failingMembersInjector = new MembersInjector<Object>(){
        int failures = 0;

        public void injectMembers(Object instance) {
            throw new ClassCastException("whoops, failure #" + ++this.failures);
        }

        public String toString() {
            return "awkward";
        }
    };

    public void testTypeListenersAreFired() {
        final AtomicInteger firedCount = new AtomicInteger();
        final TypeListener typeListener = new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                TestCase.assertEquals((Object)new TypeLiteral<A>(){}, type);
                firedCount.incrementAndGet();
            }
        };
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, typeListener);
                this.bind(A.class);
            }
        }});
        TypeListenerTest.assertEquals((int)1, (int)firedCount.get());
    }

    public void testInstallingInjectionListener() {
        final ArrayList injectees = Lists.newArrayList();
        InjectionListener<Object> injectionListener = new InjectionListener<Object>(){

            public void afterInjection(Object injectee) {
                injectees.add(injectee);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((InjectionListener)injectionListener){
            final /* synthetic */ InjectionListener val$injectionListener;
            {
                this.val$injectionListener = injectionListener;
            }

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(val$injectionListener);
                    }
                });
                this.bind(A.class);
            }
        }});
        TypeListenerTest.assertEquals((Object)ImmutableList.of(), (Object)injectees);
        Object a1 = injector.getInstance(A.class);
        TypeListenerTest.assertEquals((Object)ImmutableList.of((Object)a1), (Object)injectees);
        Object a2 = injector.getInstance(A.class);
        TypeListenerTest.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2), (Object)injectees);
        Object b1 = injector.getInstance(B.class);
        TypeListenerTest.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2, (Object)b1), (Object)injectees);
        Provider aProvider = injector.getProvider(A.class);
        TypeListenerTest.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2, (Object)b1), (Object)injectees);
        A a3 = (A)aProvider.get();
        A a4 = (A)aProvider.get();
        TypeListenerTest.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2, (Object)b1, (Object)a3, (Object)a4), (Object)injectees);
    }

    private static MethodInterceptor prefixInterceptor(final String prefix) {
        return new MethodInterceptor(){

            public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                return prefix + methodInvocation.proceed();
            }
        };
    }

    public void testAddingInterceptors() throws NoSuchMethodException {
        final Matcher buzz = Matchers.only((Object)C.class.getMethod("buzz", new Class[0]));
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), buzz, new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("ka")});
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("fe")});
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.bindInterceptor(Matchers.any(), new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("li")});
                        encounter.bindInterceptor(buzz, new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("no")});
                    }
                });
            }
        }});
        C c = (C)injector.getInstance(C.class);
        TypeListenerTest.assertEquals((String)"kafelinobuzz", (String)c.buzz());
        TypeListenerTest.assertEquals((String)"felibeep", (String)c.beep());
    }

    public void testTypeListenerThrows() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterThrowsModule()});
            TypeListenerTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error notifying TypeListener clumsy (bound at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterThrowsModule.class, InnerThrowsModule.class), "of " + B.class.getName(), "Reason: java.lang.ClassCastException: whoops, failure #1", "2) Error notifying TypeListener clumsy (bound at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), Asserts.asModuleChain(OuterThrowsModule.class, InnerThrowsModule.class), "of " + C.class.getName(), "Reason: java.lang.ClassCastException: whoops, failure #2");
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, TypeListenerTest.this.failingTypeListener);
            }
        }});
        try {
            injector.getProvider(B.class);
            TypeListenerTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error notifying TypeListener clumsy (bound at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), "of " + B.class.getName(), "Reason: java.lang.ClassCastException: whoops, failure #3");
        }
        try {
            injector.getInstance(B.class);
            TypeListenerTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error notifying TypeListener clumsy (bound at " + ((Object)((Object)this)).getClass().getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), "of " + B.class.getName(), "Reason: java.lang.ClassCastException: whoops, failure #3");
        }
        TypeListenerTest.assertSame((Object)Stage.DEVELOPMENT, (Object)injector.getInstance(Stage.class));
    }

    public void testInjectionListenerThrows() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(TypeListenerTest.this.failingInjectionListener);
                    }
                });
                this.bind(B.class);
            }
        }});
        try {
            injector.getInstance(A.class);
            TypeListenerTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) Error notifying InjectionListener goofy of " + A.class.getName(), " Reason: java.lang.ClassCastException: whoops, failure #1");
        }
        try {
            injector.getInstance(A.class);
            TypeListenerTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) Error notifying InjectionListener goofy of " + A.class.getName(), " Reason: java.lang.ClassCastException: whoops, failure #2");
        }
        Provider bProvider = injector.getProvider(B.class);
        try {
            bProvider.get();
            TypeListenerTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) Error notifying InjectionListener goofy of " + B.class.getName(), " Reason: java.lang.ClassCastException: whoops, failure #3");
        }
        TypeListenerTest.assertSame((Object)Stage.DEVELOPMENT, (Object)injector.getInstance(Stage.class));
    }

    public void testInjectMembersTypeListenerFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.getMembersInjector(A.class);
                    this.bindListener(TypeListenerTest.this.onlyAbcd, TypeListenerTest.this.failingTypeListener);
                }
            }});
            TypeListenerTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Error notifying TypeListener clumsy (bound at ", TypeListenerTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()), "of " + A.class.getName(), " Reason: java.lang.ClassCastException: whoops, failure #1");
        }
    }

    public void testConstructedTypeListenerIsTheSameAsMembersInjectorListener() {
        final AtomicInteger typeEncounters = new AtomicInteger();
        final AtomicInteger injections = new AtomicInteger();
        InjectionListener<A> listener = new InjectionListener<A>(){

            public void afterInjection(A injectee) {
                injections.incrementAndGet();
                TestCase.assertNotNull((Object)injectee.injector);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((InjectionListener)listener){
            final /* synthetic */ InjectionListener val$listener;
            {
                this.val$listener = injectionListener;
            }

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        typeEncounters.incrementAndGet();
                        encounter.register(val$listener);
                    }
                });
                this.bind(A.class);
                this.getMembersInjector(A.class);
            }
        }});
        TypeListenerTest.assertEquals((int)0, (int)injections.getAndSet(0));
        injector.getInstance(A.class);
        TypeListenerTest.assertEquals((int)1, (int)injections.getAndSet(0));
        injector.injectMembers((Object)new A());
        TypeListenerTest.assertEquals((int)1, (int)injections.getAndSet(0));
        Provider aProvider = injector.getProvider(A.class);
        MembersInjector aMembersInjector = injector.getMembersInjector(A.class);
        TypeListenerTest.assertEquals((int)0, (int)injections.getAndSet(0));
        aProvider.get();
        aProvider.get();
        TypeListenerTest.assertEquals((int)2, (int)injections.getAndSet(0));
        aMembersInjector.injectMembers((Object)new A());
        aMembersInjector.injectMembers((Object)new A());
        TypeListenerTest.assertEquals((int)2, (int)injections.getAndSet(0));
        TypeListenerTest.assertEquals((int)1, (int)typeEncounters.getAndSet(0));
    }

    public void testLookupsAtInjectorCreateTime() {
        final AtomicReference bProviderReference = new AtomicReference();
        final AtomicReference aMembersInjectorReference = new AtomicReference();
        InjectionListener<Object> lookupsTester = new InjectionListener<Object>(){

            public void afterInjection(Object injectee) {
                TestCase.assertNotNull((Object)((Provider)bProviderReference.get()).get());
                A a = new A();
                ((MembersInjector)aMembersInjectorReference.get()).injectMembers((Object)a);
                TestCase.assertNotNull((Object)a.injector);
            }
        };
        Guice.createInjector((Module[])new Module[]{new AbstractModule((InjectionListener)lookupsTester){
            final /* synthetic */ InjectionListener val$lookupsTester;
            {
                this.val$lookupsTester = injectionListener;
            }

            protected void configure() {
                this.bindListener(Matchers.only((Object)TypeLiteral.get(C.class)), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        Provider bProvider = encounter.getProvider(B.class);
                        try {
                            bProvider.get();
                            TestCase.fail();
                        }
                        catch (IllegalStateException expected) {
                            TestCase.assertEquals((String)"This Provider cannot be used until the Injector has been created.", (String)expected.getMessage());
                        }
                        bProviderReference.set(bProvider);
                        MembersInjector aMembersInjector = encounter.getMembersInjector(A.class);
                        try {
                            aMembersInjector.injectMembers((Object)new A());
                            TestCase.fail();
                        }
                        catch (IllegalStateException expected) {
                            TestCase.assertEquals((String)"This MembersInjector cannot be used until the Injector has been created.", (String)expected.getMessage());
                        }
                        aMembersInjectorReference.set(aMembersInjector);
                        encounter.register(val$lookupsTester);
                    }
                });
                this.bind(C.class).asEagerSingleton();
            }
        }});
        lookupsTester.afterInjection(null);
    }

    public void testLookupsPostCreate() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.only((Object)TypeLiteral.get(C.class)), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        TestCase.assertNotNull((Object)encounter.getProvider(B.class).get());
                        A a = new A();
                        encounter.getMembersInjector(A.class).injectMembers((Object)a);
                        TestCase.assertNotNull((Object)a.injector);
                    }
                });
            }
        }});
        injector.getInstance(C.class);
    }

    public void testMembersInjector() {
        MembersInjector<D> membersInjector = new MembersInjector<D>(){

            public void injectMembers(D instance) {
                ++instance.userInjected;
                TestCase.assertEquals((int)instance.guiceInjected, (int)instance.userInjected);
            }
        };
        InjectionListener<D> injectionListener = new InjectionListener<D>(){

            public void afterInjection(D injectee) {
                TestCase.assertTrue((injectee.userInjected > 0 ? 1 : 0) != 0);
                ++injectee.listenersNotified;
                TestCase.assertEquals((int)injectee.guiceInjected, (int)injectee.listenersNotified);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((MembersInjector)membersInjector, (InjectionListener)injectionListener){
            final /* synthetic */ MembersInjector val$membersInjector;
            final /* synthetic */ InjectionListener val$injectionListener;
            {
                this.val$membersInjector = membersInjector;
                this.val$injectionListener = injectionListener;
            }

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(val$membersInjector);
                        encounter.register(val$injectionListener);
                    }
                });
                D boundThreeTimes = new D();
                this.bind(D.class).annotatedWith((Annotation)Names.named((String)"i")).toInstance((Object)boundThreeTimes);
                this.bind(D.class).annotatedWith((Annotation)Names.named((String)"ii")).toInstance((Object)boundThreeTimes);
                this.bind(D.class).annotatedWith((Annotation)Names.named((String)"iii")).toInstance((Object)boundThreeTimes);
            }
        }});
        D boundThreeTimes = (D)injector.getInstance(Key.get(D.class, (Annotation)Names.named((String)"iii")));
        boundThreeTimes.assertAllCounts(1);
        D getInstance = (D)injector.getInstance(D.class);
        getInstance.assertAllCounts(1);
        D memberInjection = new D();
        injector.injectMembers((Object)memberInjection);
        memberInjection.assertAllCounts(1);
        injector.injectMembers((Object)memberInjection);
        injector.injectMembers((Object)memberInjection);
        memberInjection.assertAllCounts(3);
        injector.getMembersInjector(D.class).injectMembers((Object)memberInjection);
        memberInjection.assertAllCounts(4);
    }

    public void testMembersInjectorThrows() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(TypeListenerTest.this.failingMembersInjector);
                    }
                });
                this.bind(B.class);
            }
        }});
        try {
            injector.getInstance(A.class);
            TypeListenerTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) Error injecting " + A.class.getName() + " using awkward.", "Reason: java.lang.ClassCastException: whoops, failure #1");
        }
        try {
            injector.getInstance(A.class);
            TypeListenerTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) Error injecting " + A.class.getName() + " using awkward.", "Reason: java.lang.ClassCastException: whoops, failure #2");
        }
        Provider bProvider = injector.getProvider(B.class);
        try {
            bProvider.get();
            TypeListenerTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) Error injecting " + B.class.getName() + " using awkward.", "Reason: java.lang.ClassCastException: whoops, failure #3");
        }
        TypeListenerTest.assertSame((Object)Stage.DEVELOPMENT, (Object)injector.getInstance(Stage.class));
    }

    public void testTypesWithNoInjectableMembersAreNotified() {
        final AtomicInteger notificationCount = new AtomicInteger();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        notificationCount.incrementAndGet();
                    }
                });
                this.bind(C.class).toInstance((Object)new C());
            }
        }});
        TypeListenerTest.assertEquals((int)1, (int)notificationCount.get());
    }

    public void testEncounterCannotBeUsedAfterHearReturns() {
        final AtomicReference encounterReference = new AtomicReference();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.any(), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounterReference.set(encounter);
                    }
                });
                this.bind(C.class);
            }
        }});
        TypeEncounter encounter = (TypeEncounter)encounterReference.get();
        try {
            encounter.register((InjectionListener)new InjectionListener<Object>(){

                public void afterInjection(Object injectee) {
                }
            });
            TypeListenerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.bindInterceptor(Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(){

                public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                    return methodInvocation.proceed();
                }
            }});
            TypeListenerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.addError((Throwable)new Exception());
            TypeListenerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.getMembersInjector(A.class);
            TypeListenerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.getProvider(B.class);
            TypeListenerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddErrors() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.requestInjection(new Object());
                    this.bindListener(Matchers.any(), new TypeListener(){

                        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                            encounter.addError("There was an error on %s", new Object[]{type});
                            encounter.addError((Throwable)new IllegalArgumentException("whoops!"));
                            encounter.addError(new Message("And another problem"));
                            encounter.addError((Throwable)new IllegalStateException());
                        }
                    });
                }
            }});
            TypeListenerTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) There was an error on java.lang.Object", "2) An exception was caught and reported. Message: whoops!", "3) And another problem", "4) An exception was caught and reported. Message: null", "4 errors");
        }
    }

    public void testDeDuplicateTypeListeners() {
        final DuplicatingTypeListener typeListener = new DuplicatingTypeListener();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.any(), typeListener);
                this.bindListener(Matchers.only((Object)new TypeLiteral<D>(){}), typeListener);
            }
        }});
        D d = (D)injector.getInstance(D.class);
        d.assertAllCounts(1);
        TypeListenerTest.assertEquals((int)1, (int)typeListener.count);
    }

    static class D {
        int guiceInjected = 0;
        int userInjected = 0;
        int listenersNotified = 0;

        D() {
        }

        @Inject
        void guiceInjected() {
            ++this.guiceInjected;
        }

        void assertAllCounts(int expected) {
            TestCase.assertEquals((int)expected, (int)this.guiceInjected);
            TestCase.assertEquals((int)expected, (int)this.userInjected);
            TestCase.assertEquals((int)expected, (int)this.listenersNotified);
        }
    }

    public static class C {
        public String buzz() {
            return "buzz";
        }

        public String beep() {
            return "beep";
        }
    }

    static class B {
        B() {
        }
    }

    static class A {
        @Inject
        Injector injector;
        @Inject
        Stage stage;

        A() {
        }
    }

    private static class DuplicatingTypeListener
    implements TypeListener {
        int count = 0;

        private DuplicatingTypeListener() {
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            ++this.count;
            CountingMembersInjector membersInjector = new CountingMembersInjector();
            encounter.register((MembersInjector)membersInjector);
            encounter.register((MembersInjector)membersInjector);
            CountingInjectionListener injectionListener = new CountingInjectionListener();
            encounter.register((InjectionListener)injectionListener);
            encounter.register((InjectionListener)injectionListener);
        }
    }

    private static class CountingInjectionListener
    implements InjectionListener<D> {
        private CountingInjectionListener() {
        }

        public void afterInjection(D injectee) {
            ++injectee.listenersNotified;
        }
    }

    private static class CountingMembersInjector
    implements MembersInjector<D> {
        private CountingMembersInjector() {
        }

        public void injectMembers(D instance) {
            ++instance.userInjected;
        }
    }

    class InnerThrowsModule
    extends AbstractModule {
        InnerThrowsModule() {
        }

        protected void configure() {
            this.bindListener(TypeListenerTest.this.onlyAbcd, TypeListenerTest.this.failingTypeListener);
            this.bind(B.class);
            this.bind(C.class);
        }
    }

    class OuterThrowsModule
    extends AbstractModule {
        OuterThrowsModule() {
        }

        protected void configure() {
            this.install((Module)new InnerThrowsModule());
        }
    }
}

