/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.example;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.naming.Context;
import javax.naming.NamingException;

class JndiProvider<T>
implements Provider<T> {
    @Inject
    Context context;
    final String name;
    final Class<T> type;

    JndiProvider(Class<T> type, String name) {
        this.name = name;
        this.type = type;
    }

    public T get() {
        try {
            return this.type.cast(this.context.lookup(this.name));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> Provider<T> fromJndi(Class<T> type, String name) {
        return new JndiProvider<T>(type, name);
    }
}

