/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.internal.ConstructionProxy;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.MethodAspect;
import com.google.inject.internal.ProxyFactory;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionPoint;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ProxyFactoryTest
extends TestCase {
    List<MethodAspect> aspects = Lists.newArrayList();

    public void testSimpleCase() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        InjectionPoint injectionPoint = InjectionPoint.forConstructorOf(Simple.class);
        this.aspects.add(new MethodAspect(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor}));
        ProxyFactory factory = new ProxyFactory(injectionPoint, this.aspects);
        ConstructionProxy constructionProxy = factory.create();
        Simple simple = (Simple)constructionProxy.newInstance(new Object[0]);
        simple.invoke();
        ProxyFactoryTest.assertTrue((boolean)simple.invoked);
        ProxyFactoryTest.assertTrue((boolean)interceptor.invoked);
    }

    public void testInterceptOneMethod() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        this.aspects.add(new MethodAspect(Matchers.only(Bar.class), Matchers.annotatedWith(Intercept.class), new MethodInterceptor[]{interceptor}));
        ConstructionProxy fooFactory = new ProxyFactory(InjectionPoint.forConstructorOf(Foo.class), this.aspects).create();
        ConstructionProxy barFactory = new ProxyFactory(InjectionPoint.forConstructorOf(Bar.class), this.aspects).create();
        Foo foo = (Foo)fooFactory.newInstance(new Object[0]);
        Bar bar = (Bar)barFactory.newInstance(new Object[0]);
        foo.foo();
        ProxyFactoryTest.assertTrue((boolean)foo.fooCalled);
        ProxyFactoryTest.assertFalse((boolean)interceptor.invoked);
        bar.bar();
        ProxyFactoryTest.assertTrue((boolean)bar.barCalled);
        ProxyFactoryTest.assertFalse((boolean)interceptor.invoked);
        bar.intercepted();
        ProxyFactoryTest.assertTrue((boolean)bar.interceptedCalled);
        ProxyFactoryTest.assertTrue((boolean)interceptor.invoked);
    }

    public void testWithConstructorArguments() throws InvocationTargetException, NoSuchMethodException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        this.aspects.add(new MethodAspect(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor}));
        ProxyFactory factory = new ProxyFactory(InjectionPoint.forConstructorOf(A.class), this.aspects);
        ConstructionProxy constructor = factory.create();
        A a = (A)constructor.newInstance(new Object[]{5});
        a.a();
        ProxyFactoryTest.assertEquals((int)5, (int)a.i);
    }

    public void testNotProxied() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        this.aspects.add(new MethodAspect(Matchers.not((Matcher)Matchers.any()), Matchers.not((Matcher)Matchers.any()), new MethodInterceptor[]{interceptor}));
        ProxyFactory factory = new ProxyFactory(InjectionPoint.forConstructorOf(A.class), this.aspects);
        ConstructionProxy constructor = factory.create();
        A a = (A)constructor.newInstance(new Object[]{5});
        ProxyFactoryTest.assertEquals(A.class, a.getClass());
    }

    public void testMultipleInterceptors() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        DoubleInterceptor doubleInterceptor = new DoubleInterceptor();
        CountingInterceptor countingInterceptor = new CountingInterceptor();
        this.aspects.add(new MethodAspect(Matchers.any(), Matchers.any(), new MethodInterceptor[]{doubleInterceptor, countingInterceptor}));
        ProxyFactory factory = new ProxyFactory(InjectionPoint.forConstructorOf(Counter.class), this.aspects);
        ConstructionProxy constructor = factory.create();
        Counter counter = (Counter)constructor.newInstance(new Object[0]);
        counter.inc();
        ProxyFactoryTest.assertEquals((int)2, (int)counter.count);
        ProxyFactoryTest.assertEquals((int)2, (int)countingInterceptor.count);
    }

    static class Counter {
        int count;

        Counter() {
        }

        void inc() {
            ++this.count;
        }
    }

    static class DoubleInterceptor
    implements MethodInterceptor {
        DoubleInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            methodInvocation.proceed();
            return methodInvocation.proceed();
        }
    }

    static class CountingInterceptor
    implements MethodInterceptor {
        int count;

        CountingInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            ++this.count;
            return methodInvocation.proceed();
        }
    }

    static class A {
        final int i;

        @Inject
        public A(int i) {
            this.i = i;
        }

        public void a() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Intercept {
    }

    static class Bar {
        boolean barCalled;
        boolean interceptedCalled;

        Bar() {
        }

        void bar() {
            this.barCalled = true;
        }

        @Intercept
        void intercepted() {
            this.interceptedCalled = true;
        }
    }

    static class Foo {
        boolean fooCalled;

        Foo() {
        }

        @Intercept
        void foo() {
            this.fooCalled = true;
        }
    }

    static class SimpleInterceptor
    implements MethodInterceptor {
        boolean invoked = false;

        SimpleInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            this.invoked = true;
            return methodInvocation.proceed();
        }
    }

    static class Simple {
        boolean invoked = false;

        Simple() {
        }

        public void invoke() {
            this.invoked = true;
        }
    }
}

