/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LineNumbersTest
extends TestCase {
    public void testLineNumbers() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(A.class);
                }
            }});
            LineNumbersTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No implementation for " + B.class.getName() + " was bound.", "for the 1st parameter of " + A.class.getName() + ".<init>(LineNumbersTest.java:", "at " + LineNumbersTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testCanHandleLineNumbersForGuiceGeneratedClasses() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bindInterceptor(Matchers.only(A.class), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(){

                        public Object invoke(MethodInvocation methodInvocation) {
                            return null;
                        }
                    }});
                    this.bind(A.class);
                }
            }});
            LineNumbersTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No implementation for " + B.class.getName() + " was bound.", "for the 1st parameter of " + A.class.getName() + ".<init>(LineNumbersTest.java:", "at " + LineNumbersTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testUnavailableByteCodeShowsUnknownSource() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(new GeneratingClassLoader().generate());
                }
            }});
            LineNumbersTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) No implementation for " + B.class.getName() + " was bound.", "for the 1st parameter of " + GeneratingClassLoader.name + ".<init>(Unknown Source)", "at " + LineNumbersTest.class.getName(), Asserts.getDeclaringSourcePart(((Object)((Object)this)).getClass()));
        }
    }

    public void testGeneratedClassesCanSucceed() {
        final Class<?> generated = new GeneratingClassLoader().generate();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(generated);
                this.bind(B.class).toInstance((Object)new B(){});
            }
        }});
        Object instance = injector.getInstance(generated);
        LineNumbersTest.assertEquals(instance.getClass(), generated);
    }

    static class GeneratingClassLoader
    extends ClassLoader {
        static String name = "__generated";

        GeneratingClassLoader() {
            super(B.class.getClassLoader());
        }

        Class<?> generate() {
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 1, name, null, Type.getInternalName(Object.class), null);
            String sig = "(" + Type.getDescriptor(B.class) + ")V";
            MethodVisitor mv = cw.visitMethod(1, "<init>", sig, null, null);
            mv.visitAnnotation(Type.getDescriptor(Inject.class), true);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V");
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            byte[] buf = cw.toByteArray();
            return this.defineClass(name.replace('/', '.'), buf, 0, buf.length);
        }
    }

    public static interface B {
    }

    static class A {
        @Inject
        A(B b) {
        }
    }
}

