/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.matcher;

import com.google.inject.Asserts;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.AbstractList;
import junit.framework.TestCase;

public class MatcherTest
extends TestCase {
    public void testAny() {
        MatcherTest.assertTrue((boolean)Matchers.any().matches(null));
        MatcherTest.assertEquals((String)"any()", (String)Matchers.any().toString());
        Asserts.assertEqualsBothWays(Matchers.any(), Matchers.any());
        MatcherTest.assertFalse((boolean)Matchers.any().equals(Matchers.not((Matcher)Matchers.any())));
    }

    public void testNot() {
        MatcherTest.assertFalse((boolean)Matchers.not((Matcher)Matchers.any()).matches(null));
        MatcherTest.assertEquals((String)"not(any())", (String)Matchers.not((Matcher)Matchers.any()).toString());
        Asserts.assertEqualsBothWays(Matchers.not((Matcher)Matchers.any()), Matchers.not((Matcher)Matchers.any()));
        MatcherTest.assertFalse((boolean)Matchers.not((Matcher)Matchers.any()).equals(Matchers.any()));
    }

    public void testAnd() {
        MatcherTest.assertTrue((boolean)Matchers.any().and(Matchers.any()).matches(null));
        MatcherTest.assertFalse((boolean)Matchers.any().and(Matchers.not((Matcher)Matchers.any())).matches(null));
        MatcherTest.assertEquals((String)"and(any(), any())", (String)Matchers.any().and(Matchers.any()).toString());
        Asserts.assertEqualsBothWays(Matchers.any().and(Matchers.any()), Matchers.any().and(Matchers.any()));
        MatcherTest.assertFalse((boolean)Matchers.any().and(Matchers.any()).equals(Matchers.not((Matcher)Matchers.any())));
    }

    public void testOr() {
        MatcherTest.assertTrue((boolean)Matchers.any().or(Matchers.not((Matcher)Matchers.any())).matches(null));
        MatcherTest.assertFalse((boolean)Matchers.not((Matcher)Matchers.any()).or(Matchers.not((Matcher)Matchers.any())).matches(null));
        MatcherTest.assertEquals((String)"or(any(), any())", (String)Matchers.any().or(Matchers.any()).toString());
        Asserts.assertEqualsBothWays(Matchers.any().or(Matchers.any()), Matchers.any().or(Matchers.any()));
        MatcherTest.assertFalse((boolean)Matchers.any().or(Matchers.any()).equals(Matchers.not((Matcher)Matchers.any())));
    }

    public void testAnnotatedWith() {
        MatcherTest.assertTrue((boolean)Matchers.annotatedWith(Foo.class).matches(Bar.class));
        MatcherTest.assertFalse((boolean)Matchers.annotatedWith(Foo.class).matches((Object)MatcherTest.class.getMethods()[0]));
        MatcherTest.assertEquals((String)"annotatedWith(Foo.class)", (String)Matchers.annotatedWith(Foo.class).toString());
        Asserts.assertEqualsBothWays(Matchers.annotatedWith(Foo.class), Matchers.annotatedWith(Foo.class));
        MatcherTest.assertFalse((boolean)Matchers.annotatedWith(Foo.class).equals(Matchers.annotatedWith(Named.class)));
        try {
            Matchers.annotatedWith(Baz.class);
            MatcherTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubclassesOf() {
        MatcherTest.assertTrue((boolean)Matchers.subclassesOf(Runnable.class).matches(Runnable.class));
        MatcherTest.assertTrue((boolean)Matchers.subclassesOf(Runnable.class).matches(MyRunnable.class));
        MatcherTest.assertFalse((boolean)Matchers.subclassesOf(Runnable.class).matches(Object.class));
        MatcherTest.assertEquals((String)"subclassesOf(Runnable.class)", (String)Matchers.subclassesOf(Runnable.class).toString());
        Asserts.assertEqualsBothWays(Matchers.subclassesOf(Runnable.class), Matchers.subclassesOf(Runnable.class));
        MatcherTest.assertFalse((boolean)Matchers.subclassesOf(Runnable.class).equals(Matchers.subclassesOf(Object.class)));
    }

    public void testOnly() {
        MatcherTest.assertTrue((boolean)Matchers.only((Object)1000).matches((Object)1000));
        MatcherTest.assertFalse((boolean)Matchers.only((Object)1).matches((Object)1000));
        MatcherTest.assertEquals((String)"only(1)", (String)Matchers.only((Object)1).toString());
        Asserts.assertEqualsBothWays(Matchers.only((Object)1), Matchers.only((Object)1));
        MatcherTest.assertFalse((boolean)Matchers.only((Object)1).equals(Matchers.only((Object)2)));
    }

    public void testIdenticalTo() {
        Object o = new Object();
        MatcherTest.assertEquals((String)"identicalTo(1)", (String)Matchers.identicalTo((Object)1).toString());
        MatcherTest.assertTrue((boolean)Matchers.identicalTo((Object)o).matches(o));
        MatcherTest.assertFalse((boolean)Matchers.identicalTo((Object)o).matches(new Object()));
        Asserts.assertEqualsBothWays(Matchers.identicalTo((Object)o), Matchers.identicalTo((Object)o));
        MatcherTest.assertFalse((boolean)Matchers.identicalTo((Object)1).equals(Matchers.identicalTo((Object)new Integer(1))));
    }

    public void testInPackage() {
        Package matchersPackage = Matchers.class.getPackage();
        MatcherTest.assertEquals((String)"inPackage(com.google.inject.matcher)", (String)Matchers.inPackage((Package)matchersPackage).toString());
        MatcherTest.assertTrue((boolean)Matchers.inPackage((Package)matchersPackage).matches(MatcherTest.class));
        MatcherTest.assertFalse((boolean)Matchers.inPackage((Package)matchersPackage).matches(Object.class));
        Asserts.assertEqualsBothWays(Matchers.inPackage((Package)matchersPackage), Matchers.inPackage((Package)matchersPackage));
        MatcherTest.assertFalse((boolean)Matchers.inPackage((Package)matchersPackage).equals(Matchers.inPackage((Package)Object.class.getPackage())));
    }

    public void testInSubpackage() {
        String stringPackageName = String.class.getPackage().getName();
        MatcherTest.assertEquals((String)"inSubpackage(java.lang)", (String)Matchers.inSubpackage((String)stringPackageName).toString());
        MatcherTest.assertTrue((boolean)Matchers.inSubpackage((String)stringPackageName).matches(Object.class));
        MatcherTest.assertTrue((boolean)Matchers.inSubpackage((String)stringPackageName).matches(Method.class));
        MatcherTest.assertFalse((boolean)Matchers.inSubpackage((String)stringPackageName).matches(Matchers.class));
        MatcherTest.assertFalse((boolean)Matchers.inSubpackage((String)"jav").matches(Object.class));
        Asserts.assertEqualsBothWays(Matchers.inSubpackage((String)stringPackageName), Matchers.inSubpackage((String)stringPackageName));
        MatcherTest.assertFalse((boolean)Matchers.inSubpackage((String)stringPackageName).equals(Matchers.inSubpackage((String)Matchers.class.getPackage().getName())));
    }

    public void testReturns() throws NoSuchMethodException {
        Matcher predicate = Matchers.returns((Matcher)Matchers.only(String.class));
        MatcherTest.assertTrue((boolean)predicate.matches((Object)Object.class.getMethod("toString", new Class[0])));
        MatcherTest.assertFalse((boolean)predicate.matches((Object)Object.class.getMethod("hashCode", new Class[0])));
        MatcherTest.assertEquals((String)"returns(only(class java.lang.String))", (String)Matchers.returns((Matcher)Matchers.only(String.class)).toString());
        Asserts.assertEqualsBothWays(predicate, Matchers.returns((Matcher)Matchers.only(String.class)));
        MatcherTest.assertFalse((boolean)predicate.equals(Matchers.returns((Matcher)Matchers.only(Integer.class))));
    }

    public void testSerialization() throws IOException {
        Asserts.assertEqualWhenReserialized(Matchers.any());
        Asserts.assertEqualWhenReserialized(Matchers.not((Matcher)Matchers.any()));
        Asserts.assertEqualWhenReserialized(Matchers.annotatedWith(Named.class));
        Asserts.assertEqualWhenReserialized(Matchers.annotatedWith((Annotation)Names.named((String)"foo")));
        Asserts.assertEqualWhenReserialized(Matchers.only((Object)"foo"));
        Asserts.assertEqualWhenReserialized(Matchers.identicalTo(Object.class));
        Asserts.assertEqualWhenReserialized(Matchers.inPackage((Package)String.class.getPackage()));
        Asserts.assertEqualWhenReserialized(Matchers.inSubpackage((String)String.class.getPackage().getName()));
        Asserts.assertEqualWhenReserialized(Matchers.returns((Matcher)Matchers.any()));
        Asserts.assertEqualWhenReserialized(Matchers.subclassesOf(AbstractList.class));
        Asserts.assertEqualWhenReserialized(Matchers.only((Object)"a").or(Matchers.only((Object)"b")));
        Asserts.assertEqualWhenReserialized(Matchers.only((Object)"a").and(Matchers.only((Object)"b")));
    }

    @Baz
    static class Car {
        Car() {
        }
    }

    static @interface Baz {
    }

    @Foo
    static class Bar {
        Bar() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Foo {
    }

    static abstract class MyRunnable
    implements Runnable {
        MyRunnable() {
        }
    }
}

