/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithDependencies;
import java.util.Set;
import junit.framework.TestCase;

public class HasDependenciesTest
extends TestCase {
    public void testInstanceWithDependencies() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(A.class).toInstance((Object)new AWithDependencies());
            }
        }});
        InstanceBinding binding = (InstanceBinding)injector.getBinding(A.class);
        HasDependenciesTest.assertEquals((Object)ImmutableSet.of((Object)Dependency.get((Key)Key.get(Integer.class))), (Object)binding.getDependencies());
    }

    public void testInstanceWithoutDependencies() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(A.class).toInstance((Object)new A());
            }
        }});
        InstanceBinding binding = (InstanceBinding)injector.getBinding(A.class);
        Dependency onlyDependency = (Dependency)Iterables.getOnlyElement((Iterable)binding.getDependencies());
        HasDependenciesTest.assertEquals((Object)Key.get(String.class), (Object)onlyDependency.getKey());
    }

    public void testProvider() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(A.class).toProvider((Provider)new ProviderOfA());
            }
        }});
        ProviderInstanceBinding binding = (ProviderInstanceBinding)injector.getBinding(A.class);
        Dependency onlyDependency = (Dependency)Iterables.getOnlyElement((Iterable)binding.getDependencies());
        HasDependenciesTest.assertEquals((Object)Key.get(String.class), (Object)onlyDependency.getKey());
    }

    static class ProviderOfAWithDependencies
    extends ProviderOfA
    implements ProviderWithDependencies<A> {
        ProviderOfAWithDependencies() {
        }

        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of((Object)Dependency.get((Key)Key.get(Integer.class)));
        }
    }

    static class AWithDependencies
    extends A
    implements HasDependencies {
        AWithDependencies() {
        }

        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of((Object)Dependency.get((Key)Key.get(Integer.class)));
        }
    }

    static class ProviderOfA
    implements Provider<A> {
        ProviderOfA() {
        }

        @Inject
        void injectUnusedDependencies(String unused) {
        }

        public A get() {
            throw new UnsupportedOperationException();
        }
    }

    static class A {
        A() {
        }

        @Inject
        void injectUnusedDependencies(String unused) {
        }
    }
}

