/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.ErrorsException;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class InjectionPointTest
extends TestCase {
    @Inject
    @Named(value="a")
    public String foo;

    @Inject
    public void bar(@Named(value="b") String param) {
    }

    public void testFieldInjectionPoint() throws NoSuchFieldException, IOException, ErrorsException {
        TypeLiteral typeLiteral = TypeLiteral.get(((Object)((Object)this)).getClass());
        Field fooField = ((Object)((Object)this)).getClass().getField("foo");
        InjectionPoint injectionPoint = new InjectionPoint(typeLiteral, fooField, false);
        InjectionPointTest.assertSame((Object)fooField, (Object)injectionPoint.getMember());
        InjectionPointTest.assertFalse((boolean)injectionPoint.isOptional());
        InjectionPointTest.assertEquals((String)(((Object)((Object)this)).getClass().getName() + ".foo"), (String)injectionPoint.toString());
        Asserts.assertEqualsBothWays(injectionPoint, new InjectionPoint(typeLiteral, fooField, false));
        Asserts.assertNotSerializable(injectionPoint);
        Dependency dependency = (Dependency)Iterables.getOnlyElement((Iterable)injectionPoint.getDependencies());
        InjectionPointTest.assertEquals((String)("Key[type=java.lang.String, annotation=@com.google.inject.name.Named(value=" + Annotations.memberValueString((String)"a") + ")]@" + ((Object)((Object)this)).getClass().getName() + ".foo"), (String)dependency.toString());
        InjectionPointTest.assertEquals((Object)fooField, (Object)dependency.getInjectionPoint().getMember());
        InjectionPointTest.assertEquals((int)-1, (int)dependency.getParameterIndex());
        InjectionPointTest.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"a")), (Object)dependency.getKey());
        InjectionPointTest.assertFalse((boolean)dependency.isNullable());
        Asserts.assertNotSerializable(dependency);
        Asserts.assertEqualsBothWays(dependency, Iterables.getOnlyElement((Iterable)new InjectionPoint(typeLiteral, fooField, false).getDependencies()));
    }

    public void testMethodInjectionPoint() throws Exception {
        TypeLiteral typeLiteral = TypeLiteral.get(((Object)((Object)this)).getClass());
        Method barMethod = ((Object)((Object)this)).getClass().getMethod("bar", String.class);
        InjectionPoint injectionPoint = new InjectionPoint(typeLiteral, barMethod, false);
        InjectionPointTest.assertSame((Object)barMethod, (Object)injectionPoint.getMember());
        InjectionPointTest.assertFalse((boolean)injectionPoint.isOptional());
        InjectionPointTest.assertEquals((String)(((Object)((Object)this)).getClass().getName() + ".bar()"), (String)injectionPoint.toString());
        Asserts.assertEqualsBothWays(injectionPoint, new InjectionPoint(typeLiteral, barMethod, false));
        Asserts.assertNotSerializable(injectionPoint);
        Dependency dependency = (Dependency)Iterables.getOnlyElement((Iterable)injectionPoint.getDependencies());
        InjectionPointTest.assertEquals((String)("Key[type=java.lang.String, annotation=@com.google.inject.name.Named(value=" + Annotations.memberValueString((String)"b") + ")]@" + ((Object)((Object)this)).getClass().getName() + ".bar()[0]"), (String)dependency.toString());
        InjectionPointTest.assertEquals((Object)barMethod, (Object)dependency.getInjectionPoint().getMember());
        InjectionPointTest.assertEquals((int)0, (int)dependency.getParameterIndex());
        InjectionPointTest.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"b")), (Object)dependency.getKey());
        InjectionPointTest.assertFalse((boolean)dependency.isNullable());
        Asserts.assertNotSerializable(dependency);
        Asserts.assertEqualsBothWays(dependency, Iterables.getOnlyElement((Iterable)new InjectionPoint(typeLiteral, barMethod, false).getDependencies()));
    }

    public void testConstructorInjectionPoint() throws NoSuchMethodException, IOException, ErrorsException {
        TypeLiteral typeLiteral = TypeLiteral.get(Constructable.class);
        Constructor constructor = Constructable.class.getConstructor(String.class);
        InjectionPoint injectionPoint = new InjectionPoint(typeLiteral, constructor);
        InjectionPointTest.assertSame(constructor, (Object)injectionPoint.getMember());
        InjectionPointTest.assertFalse((boolean)injectionPoint.isOptional());
        InjectionPointTest.assertEquals((String)(Constructable.class.getName() + ".<init>()"), (String)injectionPoint.toString());
        Asserts.assertEqualsBothWays(injectionPoint, new InjectionPoint(typeLiteral, constructor));
        Asserts.assertNotSerializable(injectionPoint);
        Dependency dependency = (Dependency)Iterables.getOnlyElement((Iterable)injectionPoint.getDependencies());
        InjectionPointTest.assertEquals((String)("Key[type=java.lang.String, annotation=@com.google.inject.name.Named(value=" + Annotations.memberValueString((String)"c") + ")]@" + Constructable.class.getName() + ".<init>()[0]"), (String)dependency.toString());
        InjectionPointTest.assertEquals(constructor, (Object)dependency.getInjectionPoint().getMember());
        InjectionPointTest.assertEquals((int)0, (int)dependency.getParameterIndex());
        InjectionPointTest.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"c")), (Object)dependency.getKey());
        InjectionPointTest.assertFalse((boolean)dependency.isNullable());
        Asserts.assertNotSerializable(dependency);
        Asserts.assertEqualsBothWays(dependency, Iterables.getOnlyElement((Iterable)new InjectionPoint(typeLiteral, constructor).getDependencies()));
    }

    public void testUnattachedDependency() throws IOException {
        Dependency dependency = Dependency.get((Key)Key.get(String.class, (Annotation)Names.named((String)"d")));
        InjectionPointTest.assertEquals((String)("Key[type=java.lang.String, annotation=@com.google.inject.name.Named(value=" + Annotations.memberValueString((String)"d") + ")]"), (String)dependency.toString());
        InjectionPointTest.assertNull((Object)dependency.getInjectionPoint());
        InjectionPointTest.assertEquals((int)-1, (int)dependency.getParameterIndex());
        InjectionPointTest.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"d")), (Object)dependency.getKey());
        InjectionPointTest.assertTrue((boolean)dependency.isNullable());
        Asserts.assertNotSerializable(dependency);
        Asserts.assertEqualsBothWays(dependency, Dependency.get((Key)Key.get(String.class, (Annotation)Names.named((String)"d"))));
    }

    public void testForConstructor() throws NoSuchMethodException {
        Constructor constructor = HashSet.class.getConstructor(new Class[0]);
        TypeLiteral<HashSet<String>> hashSet = new TypeLiteral<HashSet<String>>(){};
        InjectionPoint injectionPoint = InjectionPoint.forConstructor(constructor, (TypeLiteral)hashSet);
        InjectionPointTest.assertSame(constructor, (Object)injectionPoint.getMember());
        InjectionPointTest.assertEquals((Object)ImmutableList.of(), (Object)injectionPoint.getDependencies());
        InjectionPointTest.assertFalse((boolean)injectionPoint.isOptional());
        try {
            InjectionPoint.forConstructor(constructor, (TypeLiteral)new TypeLiteral<LinkedHashSet<String>>(){});
            InjectionPointTest.fail((String)"Expected ConfigurationException");
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "java.util.LinkedHashSet<java.lang.String>", " does not define java.util.HashSet.<init>()", "  while locating java.util.LinkedHashSet<java.lang.String>");
        }
        try {
            InjectionPoint.forConstructor(constructor, (TypeLiteral)new TypeLiteral<Set<String>>(){});
            InjectionPointTest.fail((String)"Expected ConfigurationException");
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "java.util.Set<java.lang.String>", " does not define java.util.HashSet.<init>()", "  while locating java.util.Set<java.lang.String>");
        }
    }

    public void testForConstructorOf() {
        InjectionPoint injectionPoint = InjectionPoint.forConstructorOf(Constructable.class);
        InjectionPointTest.assertEquals((String)(Constructable.class.getName() + ".<init>()"), (String)injectionPoint.toString());
    }

    public void testAddForInstanceMethodsAndFields() throws Exception {
        Method instanceMethod = HasInjections.class.getMethod("instanceMethod", String.class);
        Field instanceField = HasInjections.class.getField("instanceField");
        Field instanceField2 = HasInjections.class.getField("instanceField2");
        TypeLiteral type = TypeLiteral.get(HasInjections.class);
        Set injectionPoints = InjectionPoint.forInstanceMethodsAndFields(HasInjections.class);
        Truth.assertThat((Iterable)injectionPoints).containsExactly(new Object[]{new InjectionPoint(type, instanceField, false), new InjectionPoint(type, instanceField2, false), new InjectionPoint(type, instanceMethod, false)}).inOrder();
    }

    public void testAddForStaticMethodsAndFields() throws Exception {
        Method staticMethod = HasInjections.class.getMethod("staticMethod", String.class);
        Field staticField = HasInjections.class.getField("staticField");
        Field staticField2 = HasInjections.class.getField("staticField2");
        Set injectionPoints = InjectionPoint.forStaticMethodsAndFields(HasInjections.class);
        TypeLiteral type = TypeLiteral.get(HasInjections.class);
        Truth.assertThat((Iterable)injectionPoints).containsExactly(new Object[]{new InjectionPoint(type, staticField, false), new InjectionPoint(type, staticField2, false), new InjectionPoint(type, staticMethod, false)}).inOrder();
    }

    public void testAddForParameterizedInjections() {
        TypeLiteral<ParameterizedInjections<String>> type = new TypeLiteral<ParameterizedInjections<String>>(){};
        InjectionPoint constructor = InjectionPoint.forConstructorOf((TypeLiteral)type);
        InjectionPointTest.assertEquals((Object)new Key<Map<String, String>>(){}, (Object)((Dependency)Iterables.getOnlyElement((Iterable)constructor.getDependencies())).getKey());
        InjectionPoint field = (InjectionPoint)Iterables.getOnlyElement((Iterable)InjectionPoint.forInstanceMethodsAndFields((TypeLiteral)type));
        InjectionPointTest.assertEquals((Object)new Key<Set<String>>(){}, (Object)((Dependency)Iterables.getOnlyElement((Iterable)field.getDependencies())).getKey());
    }

    public void testSignature() throws Exception {
        InjectionPoint.Signature fooA = new InjectionPoint.Signature(Foo.class.getDeclaredMethod("a", String.class, Integer.TYPE));
        InjectionPoint.Signature fooB = new InjectionPoint.Signature(Foo.class.getDeclaredMethod("b", new Class[0]));
        InjectionPoint.Signature barA = new InjectionPoint.Signature(Bar.class.getDeclaredMethod("a", String.class, Integer.TYPE));
        InjectionPoint.Signature barB = new InjectionPoint.Signature(Bar.class.getDeclaredMethod("b", new Class[0]));
        InjectionPointTest.assertEquals((int)fooA.hashCode(), (int)barA.hashCode());
        InjectionPointTest.assertEquals((int)fooB.hashCode(), (int)barB.hashCode());
        InjectionPointTest.assertEquals((Object)fooA, (Object)barA);
        InjectionPointTest.assertEquals((Object)fooB, (Object)barB);
    }

    public void testOverrideBehavior() {
        Set points = InjectionPoint.forInstanceMethodsAndFields(Super.class);
        InjectionPointTest.assertEquals((String)points.toString(), (int)6, (int)points.size());
        this.assertPoints(points, Super.class, "atInject", "gInject", "privateAtAndPublicG", "privateGAndPublicAt", "atFirstThenG", "gFirstThenAt");
        points = InjectionPoint.forInstanceMethodsAndFields(Sub.class);
        InjectionPointTest.assertEquals((String)points.toString(), (int)7, (int)points.size());
        this.assertPoints(points, Super.class, "privateAtAndPublicG", "privateGAndPublicAt", "gInject");
        this.assertPoints(points, Sub.class, "privateAtAndPublicG", "privateGAndPublicAt", "atFirstThenG", "gFirstThenAt");
        points = InjectionPoint.forInstanceMethodsAndFields(SubSub.class);
        InjectionPointTest.assertEquals((String)points.toString(), (int)6, (int)points.size());
        this.assertPoints(points, Super.class, "privateAtAndPublicG", "privateGAndPublicAt", "gInject");
        this.assertPoints(points, Sub.class, "privateAtAndPublicG", "atFirstThenG", "gFirstThenAt");
    }

    public void testSyntheticBridgeMethodsInSubclasses() {
        Set points = InjectionPoint.forInstanceMethodsAndFields(RestrictedSuper.class);
        this.assertPointDependencies(points, new TypeLiteral<Provider<String>>(){});
        InjectionPointTest.assertEquals((String)points.toString(), (int)2, (int)points.size());
        this.assertPoints(points, RestrictedSuper.class, "jInject", "gInject");
        points = InjectionPoint.forInstanceMethodsAndFields(ExposedSub.class);
        this.assertPointDependencies(points, new TypeLiteral<Provider<String>>(){});
        InjectionPointTest.assertEquals((String)points.toString(), (int)2, (int)points.size());
        this.assertPoints(points, RestrictedSuper.class, "jInject", "gInject");
    }

    private void assertPoints(Iterable<InjectionPoint> points, Class<?> clazz, String ... methodNames) {
        HashSet<String> methods = new HashSet<String>();
        for (InjectionPoint point : points) {
            if (point.getDeclaringType().getRawType() != clazz) continue;
            methods.add(point.getMember().getName());
        }
        InjectionPointTest.assertEquals((String)points.toString(), (Object)ImmutableSet.copyOf((Object[])methodNames), methods);
    }

    private void assertPointDependencies(Iterable<InjectionPoint> points, TypeLiteral<?> ... literals) {
        for (InjectionPoint point : points) {
            InjectionPointTest.assertEquals((int)literals.length, (int)point.getDependencies().size());
            for (Dependency dep : point.getDependencies()) {
                InjectionPointTest.assertEquals(literals[dep.getParameterIndex()], (Object)dep.getKey().getTypeLiteral());
            }
        }
    }

    public static class ExposedSub
    extends RestrictedSuper {
    }

    static class RestrictedSuper {
        RestrictedSuper() {
        }

        @Inject
        public void gInject(Provider<String> p) {
        }

        @javax.inject.Inject
        public void jInject(Provider<String> p) {
        }
    }

    static class SubSub
    extends Sub {
        SubSub() {
        }

        @Override
        public void privateAtAndPublicG() {
        }

        @Override
        public void privateGAndPublicAt() {
        }

        @Override
        public void atFirstThenG() {
        }

        @Override
        public void gFirstThenAt() {
        }
    }

    static class Sub
    extends Super {
        Sub() {
        }

        @Override
        public void atInject() {
        }

        @Override
        public void gInject() {
        }

        @Inject
        public void privateAtAndPublicG() {
        }

        @javax.inject.Inject
        public void privateGAndPublicAt() {
        }

        @Override
        @Inject
        public void atFirstThenG() {
        }

        @Override
        @javax.inject.Inject
        public void gFirstThenAt() {
        }
    }

    static class Super {
        Super() {
        }

        @javax.inject.Inject
        public void atInject() {
        }

        @Inject
        public void gInject() {
        }

        @javax.inject.Inject
        private void privateAtAndPublicG() {
        }

        @Inject
        private void privateGAndPublicAt() {
        }

        @javax.inject.Inject
        public void atFirstThenG() {
        }

        @Inject
        public void gFirstThenAt() {
        }
    }

    static class Bar {
        Bar() {
        }

        public void a(String s, int i) {
        }

        void b() {
        }
    }

    static class Foo {
        Foo() {
        }

        void a(String s, int i) {
        }

        int b() {
            return 0;
        }
    }

    static class ParameterizedInjections<T> {
        @Inject
        Set<T> setOfTees;

        @Inject
        public ParameterizedInjections(Map<T, T> map) {
        }
    }

    static class HasInjections {
        @Inject
        @Named(value="c")
        public static String staticField;
        @Inject
        @Named(value="c")
        public static String staticField2;
        @Inject
        @Named(value="f")
        public String instanceField;
        @Inject
        @Named(value="f")
        public String instanceField2;

        HasInjections() {
        }

        @Inject
        public static void staticMethod(@Named(value="a") String a) {
        }

        @Inject
        public void instanceMethod(@Named(value="d") String d) {
        }
    }

    public static class Constructable {
        @Inject
        public Constructable(@Named(value="c") String param) {
        }
    }
}

