/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class ModuleRewriterTest
extends TestCase {
    public void testRewriteBindings() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"Pizza");
                this.bind(CharSequence.class).toInstance((Object)"Wine");
            }
        };
        List elements = Elements.getElements((Module[])new Module[]{module});
        ArrayList rewritten = Lists.newArrayList();
        for (Element element : elements) {
            if ((element = (Element)element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Element>(){

                public <T> Element visit(Binding<T> binding) {
                    Object target = binding.acceptTargetVisitor(Elements.getInstanceVisitor());
                    if ("Wine".equals(target)) {
                        return null;
                    }
                    return binding;
                }
            })) == null) continue;
            rewritten.add(element);
        }
        Module rewrittenModule = Elements.getModule((Iterable)rewritten);
        Injector injector = Guice.createInjector((Module[])new Module[]{rewrittenModule});
        try {
            injector.getInstance(CharSequence.class);
            ModuleRewriterTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testGetProviderAvailableAtInjectMembersTime() {
        AbstractModule module = new AbstractModule(){

            public void configure() {
                final Provider stringProvider = this.getProvider(String.class);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"2")).toProvider((Provider)new Provider<String>(){
                    private String value;

                    @Inject
                    void initialize() {
                        this.value = (String)stringProvider.get();
                    }

                    public String get() {
                        return this.value;
                    }
                });
                this.bind(String.class).toInstance((Object)"A");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        ModuleRewriterTest.assertEquals((String)"A", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"2")))));
        List elements = Elements.getElements((Module[])new Module[]{module});
        Module replayed = Elements.getModule((Iterable)elements);
        Injector replayedInjector = Guice.createInjector((Module[])new Module[]{replayed});
        ModuleRewriterTest.assertEquals((String)"A", (String)((String)replayedInjector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"2")))));
    }
}

