/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.internal.InternalFlags;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.ProviderMethodsModule;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProvidesMethodBinding;
import com.google.inject.spi.ProvidesMethodTargetVisitor;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class ProviderMethodsTest
extends TestCase
implements Module {
    public void testProviderMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{this});
        Bob bob = (Bob)injector.getInstance(Bob.class);
        ProviderMethodsTest.assertEquals((String)"A Bob", (String)bob.getName());
        Bob clone = (Bob)injector.getInstance(Bob.class);
        ProviderMethodsTest.assertEquals((String)"A Bob", (String)clone.getName());
        ProviderMethodsTest.assertNotSame((Object)bob, (Object)clone);
        ProviderMethodsTest.assertSame((Object)bob.getDaughter(), (Object)clone.getDaughter());
        Key soleBobKey = Key.get(Bob.class, Sole.class);
        ProviderMethodsTest.assertSame((Object)injector.getInstance(soleBobKey), (Object)injector.getInstance(soleBobKey));
    }

    public void configure(Binder binder) {
    }

    @Provides
    Bob provideBob(final Dagny dagny) {
        return new Bob(){

            @Override
            public String getName() {
                return "A Bob";
            }

            @Override
            public Dagny getDaughter() {
                return dagny;
            }
        };
    }

    @Provides
    @Singleton
    @Sole
    Bob provideSoleBob(final Dagny dagny) {
        return new Bob(){

            @Override
            public String getName() {
                return "Only Bob";
            }

            @Override
            public Dagny getDaughter() {
                return dagny;
            }
        };
    }

    @Provides
    @Singleton
    Dagny provideDagny() {
        return new Dagny(){

            @Override
            public int getAge() {
                return 1;
            }
        };
    }

    public void testCircularDependency() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @Provides
            Foo newFoo(final Bar bar) {
                return new Foo(){

                    @Override
                    public Bar getBar() {
                        return bar;
                    }

                    @Override
                    public int getI() {
                        return 5;
                    }
                };
            }

            @Provides
            Bar newBar(final Foo foo) {
                return new Bar(){

                    @Override
                    public Foo getFoo() {
                        return foo;
                    }

                    @Override
                    public int getI() {
                        return 10;
                    }
                };
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        ProviderMethodsTest.assertEquals((int)5, (int)foo.getI());
        ProviderMethodsTest.assertEquals((int)10, (int)foo.getBar().getI());
        ProviderMethodsTest.assertEquals((int)5, (int)foo.getBar().getFoo().getI());
    }

    public void testMultipleBindingAnnotations() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                @Provides
                @Named(value="A")
                @Blue
                public String provideString() {
                    return "a";
                }
            }});
            ProviderMethodsTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "more than one annotation annotated with @BindingAnnotation:", "Named", "Blue", "at " + ((Object)((Object)this)).getClass().getName(), ".provideString(ProviderMethodsTest.java:");
        }
    }

    public void testGenericProviderMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ProvideTs<String>("A", "B"){}, new ProvideTs<Integer>(Integer.valueOf(1), Integer.valueOf(2)){}});
        ProviderMethodsTest.assertEquals((String)"A", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"First")))));
        ProviderMethodsTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Second")))));
        ProviderMethodsTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)injector.getInstance(Key.get((Type)Types.setOf(String.class))));
        ProviderMethodsTest.assertEquals((int)1, (int)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"First")))));
        ProviderMethodsTest.assertEquals((int)2, (int)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"Second")))));
        ProviderMethodsTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2), (Object)injector.getInstance(Key.get((Type)Types.setOf(Integer.class))));
    }

    public void testAutomaticProviderMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){
            private int next = 1;

            @Provides
            @Named(value="count")
            public Integer provideCount() {
                return this.next++;
            }
        }});
        ProviderMethodsTest.assertEquals((int)1, (int)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"count")))));
        ProviderMethodsTest.assertEquals((int)2, (int)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"count")))));
        ProviderMethodsTest.assertEquals((int)3, (int)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"count")))));
    }

    public void testAutomaticProviderMethodsDoNotCauseDoubleBinding() {
        AbstractModule installsSelf = new AbstractModule(){

            protected void configure() {
                this.install((Module)this);
                this.bind(Integer.class).toInstance((Object)5);
            }

            @Provides
            public String provideString(Integer count) {
                return "A" + count;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{installsSelf});
        ProviderMethodsTest.assertEquals((String)"A5", (String)((String)injector.getInstance(String.class)));
    }

    public void testWildcardProviderMethods() {
        ImmutableList strings = ImmutableList.of((Object)"A", (Object)"B", (Object)"C");
        ImmutableList numbers = ImmutableList.of((Object)1, (Object)2, (Object)3);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((List)numbers, (List)strings){
            final /* synthetic */ List val$numbers;
            final /* synthetic */ List val$strings;
            {
                this.val$numbers = list;
                this.val$strings = list2;
            }

            protected void configure() {
                Key listOfSupertypesOfInteger = Key.get((Type)Types.listOf((Type)Types.supertypeOf(Integer.class)));
                this.bind(listOfSupertypesOfInteger).toInstance((Object)this.val$numbers);
            }

            @Provides
            public List<? extends CharSequence> provideCharSequences() {
                return this.val$strings;
            }

            @Provides
            public Class<?> provideType() {
                return Float.class;
            }
        }});
        ProviderMethodsTest.assertSame((Object)strings, ((HasWildcardInjection)injector.getInstance(HasWildcardInjection.class)).charSequences);
        ProviderMethodsTest.assertSame((Object)numbers, ((HasWildcardInjection)injector.getInstance(HasWildcardInjection.class)).numbers);
        ProviderMethodsTest.assertSame(Float.class, ((HasWildcardInjection)injector.getInstance(HasWildcardInjection.class)).type);
    }

    public void testProviderMethodDependenciesAreExposed() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)50);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"units")).to("Kg");
            }

            @Provides
            @Named(value="weight")
            String provideWeight(Integer count, @Named(value="units") String units) {
                return count + units;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        ProviderInstanceBinding binding = (ProviderInstanceBinding)injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"weight")));
        Method method = module.getClass().getDeclaredMethod("provideWeight", Integer.class, String.class);
        InjectionPoint point = new InjectionPoint(TypeLiteral.get(module.getClass()), method, false);
        ProviderMethodsTest.assertEquals((Object)ImmutableSet.of((Object)new Dependency(point, Key.get(Integer.class), false, 0), (Object)new Dependency(point, Key.get(String.class, (Annotation)Names.named((String)"units")), false, 1)), (Object)binding.getDependencies());
    }

    public void testNonModuleProviderMethods() {
        final Object methodsObject = new Object(){

            @Provides
            @Named(value="foo")
            String provideFoo() {
                return "foo-value";
            }
        };
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.install(ProviderMethodsModule.forObject((Object)methodsObject));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key key = Key.get(String.class, (Annotation)Names.named((String)"foo"));
        ProviderMethodsTest.assertEquals((String)"foo-value", (String)((String)injector.getInstance(key)));
        List elements = Elements.getElements((Module[])new Module[]{module});
        ProviderMethodsTest.assertEquals((int)1, (int)elements.size());
        Element element = (Element)elements.get(0);
        ProviderMethodsTest.assertTrue((String)(element + " instanceof ProviderInstanceBinding"), (boolean)(element instanceof ProviderInstanceBinding));
        ProviderInstanceBinding binding = (ProviderInstanceBinding)element;
        javax.inject.Provider provider = binding.getUserSuppliedProvider();
        ProviderMethodsTest.assertTrue((boolean)(provider instanceof ProviderMethod));
        ProviderMethodsTest.assertEquals((Object)methodsObject, (Object)((ProviderMethod)provider).getInstance());
        ProviderMethodsTest.assertSame((Object)provider, (Object)binding.getProviderInstance());
    }

    public void testVoidProviderMethods() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                @Provides
                void provideFoo() {
                }
            }});
            ProviderMethodsTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Provider methods must return a value. Do not return void.", ((Object)((Object)this)).getClass().getName(), ".provideFoo(ProviderMethodsTest.java:");
        }
    }

    public void testInjectsJustOneLogger() {
        AtomicReference<Logger> loggerRef = new AtomicReference<Logger>();
        Injector injector = Guice.createInjector((Module[])new Module[]{new FooModule(loggerRef)});
        ProviderMethodsTest.assertNull((Object)loggerRef.get());
        injector.getInstance(Integer.class);
        Logger lastLogger = loggerRef.getAndSet(null);
        ProviderMethodsTest.assertNotNull((Object)lastLogger);
        injector.getInstance(Integer.class);
        ProviderMethodsTest.assertSame((Object)lastLogger, (Object)loggerRef.get());
        ProviderMethodsTest.assertEquals((String)FooModule.class.getName(), (String)lastLogger.getName());
    }

    public void testSpi() throws Exception {
        AbstractModule m1 = new AbstractModule(){

            @Provides
            @Named(value="foo")
            String provideFoo(Integer dep) {
                return "foo";
            }
        };
        AbstractModule m2 = new AbstractModule(){

            @Provides
            Integer provideInt(@Named(value="foo") String dep) {
                return 42;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{m1, m2});
        Binding stringBinding = injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"foo")));
        ProvidesMethodBinding stringMethod = (ProvidesMethodBinding)stringBinding.acceptTargetVisitor(new BindingCapturer());
        ProviderMethodsTest.assertEquals((Object)m1, (Object)stringMethod.getEnclosingInstance());
        ProviderMethodsTest.assertEquals((Object)m1.getClass().getDeclaredMethod("provideFoo", Integer.class), (Object)stringMethod.getMethod());
        ProviderMethodsTest.assertEquals((Object)((HasDependencies)stringBinding).getDependencies(), (Object)stringMethod.getDependencies());
        ProviderMethodsTest.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"foo")), (Object)stringMethod.getKey());
        Binding intBinding = injector.getBinding(Integer.class);
        ProvidesMethodBinding intMethod = (ProvidesMethodBinding)intBinding.acceptTargetVisitor(new BindingCapturer());
        ProviderMethodsTest.assertEquals((Object)m2, (Object)intMethod.getEnclosingInstance());
        ProviderMethodsTest.assertEquals((Object)m2.getClass().getDeclaredMethod("provideInt", String.class), (Object)intMethod.getMethod());
        ProviderMethodsTest.assertEquals((Object)((HasDependencies)intBinding).getDependencies(), (Object)intMethod.getDependencies());
        ProviderMethodsTest.assertEquals((Object)Key.get(Integer.class), (Object)intMethod.getKey());
    }

    public void testProvidesMethodVisibility() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new VisibilityModule()});
        ProviderMethodsTest.assertEquals((int)42, (int)((Integer)injector.getInstance(Integer.class)));
        ProviderMethodsTest.assertEquals((long)42L, (long)((Long)injector.getInstance(Long.class)));
        ProviderMethodsTest.assertEquals((double)42.0, (double)((Double)injector.getInstance(Double.class)), (double)0.0);
        ProviderMethodsTest.assertEquals((float)42.0f, (float)((Float)injector.getInstance(Float.class)).floatValue(), (float)0.0f);
    }

    public void testProvidesMethodInheritenceHierarchy() {
        try {
            Guice.createInjector((Module[])new Module[]{new Sub1Module(), new Sub2Module()});
            ProviderMethodsTest.fail((String)"Expected injector creation failure");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "A binding to java.lang.Long was already configured", "A binding to java.lang.Integer was already configured");
        }
    }

    public void testProvidesMethodsDefinedInSuperClass() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Sub1Module()});
        ProviderMethodsTest.assertEquals((int)42, (int)((Integer)injector.getInstance(Integer.class)));
        ProviderMethodsTest.assertEquals((long)42L, (long)((Long)injector.getInstance(Long.class)));
        ProviderMethodsTest.assertEquals((double)42.0, (double)((Double)injector.getInstance(Double.class)), (double)0.0);
    }

    public void testShareFastClass() {
        CallerInspecterModule module = new CallerInspecterModule();
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{module});
        ProviderMethodsTest.assertEquals((String)module.fooCallerClass, (String)module.barCallerClass);
        ProviderMethodsTest.assertTrue((boolean)module.fooCallerClass.contains("$$FastClassByGuice$$"));
    }

    public void testShareFastClassWithSuperClass() {
        CallerInspecterSubClassModule module = new CallerInspecterSubClassModule();
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{module});
        ProviderMethodsTest.assertEquals((String)"Expected provider methods in the same class to share fastclass classes", (String)module.fooCallerClass, (String)module.barCallerClass);
        ProviderMethodsTest.assertFalse((String)"Did not expect provider methods in the subclasses to share fastclass classes with their parent classes", (boolean)module.bazCallerClass.equals(module.barCallerClass));
    }

    public void testOverrideProviderMethod_overrideHasProvides() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            @Override
            @Provides
            Number providerMethod() {
                return 2.0;
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".providerMethod()", "overridden by: " + SubClassModule.class.getName() + ".providerMethod()");
        }
    }

    public void testOverrideProviderMethod_overrideHasProvides_withNewAnnotation() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            @Override
            @Provides
            @Named(value="foo")
            Number providerMethod() {
                return 2.0;
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".providerMethod()", "overridden by: " + SubClassModule.class.getName() + ".providerMethod()");
        }
    }

    public void testOverrideProviderMethod_overrideDoesntHaveProvides() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            @Override
            Number providerMethod() {
                return 2.0;
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".providerMethod()", "overridden by: " + SubClassModule.class.getName() + ".providerMethod()");
        }
    }

    public void testOverrideProviderMethod_overrideDoesntHaveProvides_withNewAnnotation() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            @Override
            @Named(value="foo")
            Number providerMethod() {
                return 2.0;
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".providerMethod()", "overridden by: " + SubClassModule.class.getName() + ".providerMethod()");
        }
    }

    public void testOverrideProviderMethod_covariantOverrideDoesntHaveProvides() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            @Override
            Double providerMethod() {
                return 2.0;
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".providerMethod()", "overridden by: " + SubClassModule.class.getName() + ".providerMethod()");
        }
    }

    public void testOverrideProviderMethod_covariantOverrideHasProvides() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            @Override
            @Provides
            Double providerMethod() {
                return 2.0;
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".providerMethod()", "overridden by: " + SubClassModule.class.getName() + ".providerMethod()");
        }
    }

    public void testOverrideProviderMethod_fakeOverridePrivateMethod() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            String privateProviderMethod() {
                return "sub";
            }
        }
        ProviderMethodsTest.assertEquals((String)"hello", (String)((String)Guice.createInjector((Module[])new Module[]{new SubClassModule()}).getInstance(String.class)));
    }

    public void testOverrideProviderMethod_subclassRawTypes_returnType() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            List annotatedGenericProviderMethod() {
                return super.annotatedGenericProviderMethod();
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".annotatedGenericProviderMethod()", "overridden by: " + SubClassModule.class.getName() + ".annotatedGenericProviderMethod()");
        }
    }

    public void testOverrideProviderMethod_subclassRawTypes_parameterType() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            Collection<String> annotatedGenericParameterProviderMethod(List foo) {
                return super.annotatedGenericParameterProviderMethod(foo);
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".annotatedGenericParameterProviderMethod()", "overridden by: " + SubClassModule.class.getName() + ".annotatedGenericParameterProviderMethod()");
        }
    }

    public void testOverrideProviderMethod_superclassRawTypes_returnType() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule() {
            }

            @Override
            List<String> rawProvider(List<String> f) {
                return f;
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + SuperClassModule.class.getName() + ".rawProvider()", "overridden by: " + SubClassModule.class.getName() + ".rawProvider()");
        }
    }

    public void testOverrideProviderMethod_erasureBasedOverrides() {
        class SubClassModule
        extends GenericSuperModule<Integer> {
            SubClassModule() {
            }

            @Override
            String provide(Integer thing) {
                return thing.toString();
            }

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)3);
            }
        }
        try {
            Guice.createInjector((Module[])new Module[]{new SubClassModule()});
            ProviderMethodsTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: " + GenericSuperModule.class.getName() + ".provide()", "overridden by: " + SubClassModule.class.getName() + ".provide()");
        }
    }

    public void testOverrideProviderMethod_increasedVisibility() {
        ProviderMethodsTest.assertEquals((String)"foo", (String)((String)Guice.createInjector((Module[])new Module[]{new ExposedSub()}).getInstance(String.class)));
    }

    public void testIgnoreSyntheticBridgeMethods() {
        Guice.createInjector((Module[])new Module[]{new ModuleImpl()});
    }

    public void testScopedProviderMethodThrowsException() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @Provides
            @Singleton
            int provideInt() {
                throw new RuntimeException("boom");
            }
        }});
        Provider intProvider = injector.getProvider(Integer.class);
        try {
            intProvider.get();
            ProviderMethodsTest.fail();
        }
        catch (ProvisionException pe) {
            Asserts.assertContains(pe.getMessage(), "java.lang.RuntimeException: boom", "provideInt");
        }
    }

    public void testNullability() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider(Providers.of(null));
            }

            @Provides
            Integer fail(String foo) {
                return 1;
            }

            @Provides
            Long succeed(@Nullable String foo) {
                return 2L;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        InjectionPoint fooPoint = InjectionPoint.forMethod((Method)module.getClass().getDeclaredMethod("fail", String.class), (TypeLiteral)TypeLiteral.get(module.getClass()));
        Dependency fooDependency = (Dependency)Iterables.getOnlyElement((Iterable)fooPoint.getDependencies());
        this.runNullableTest(injector, fooDependency, (Module)module);
        injector.getInstance(Long.class);
    }

    public void testModuleBindings() throws Exception {
        AbstractModule module = new AbstractModule(){

            @Provides
            Integer fail() {
                return 1;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        ProviderMethodsTest.assertEquals((int)1, (int)((Integer)injector.getInstance(Integer.class)));
        ProviderInstanceBinding injectorBinding = (ProviderInstanceBinding)injector.getBinding(Integer.class);
        ProviderMethodsTest.assertEquals((Object)1, (Object)injectorBinding.getUserSuppliedProvider().get());
        ProviderInstanceBinding moduleBinding = (ProviderInstanceBinding)Iterables.getOnlyElement((Iterable)Elements.getElements((Module[])new Module[]{module}));
        try {
            moduleBinding.getUserSuppliedProvider().get();
            ProviderMethodsTest.fail();
        }
        catch (IllegalStateException ise) {
            ProviderMethodsTest.assertEquals((String)"This Provider cannot be used until the Injector has been created.", (String)ise.getMessage());
        }
    }

    private void runNullableTest(Injector injector, Dependency<?> dependency, Module module) {
        switch (InternalFlags.getNullableProvidesOption()) {
            case ERROR: {
                this.validateNullableFails(injector, module);
                break;
            }
            case IGNORE: {
                this.validateNullableIgnored(injector);
                break;
            }
            case WARN: {
                this.validateNullableWarns(injector, dependency);
            }
        }
    }

    private void validateNullableFails(Injector injector, Module module) {
        try {
            injector.getInstance(Integer.class);
            ProviderMethodsTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "1) null returned by binding at " + module.getClass().getName() + ".configure(", "but the 1st parameter of " + module.getClass().getName() + ".fail(", "is not @Nullable", "while locating java.lang.String", "for the 1st parameter of " + module.getClass().getName() + ".fail(", "while locating java.lang.Integer");
            ProviderMethodsTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
        }
    }

    private void validateNullableIgnored(Injector injector) {
        injector.getInstance(Integer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateNullableWarns(Injector injector, Dependency<?> dependency) {
        final ArrayList logRecords = Lists.newArrayList();
        Handler fakeHandler = new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                logRecords.add(logRecord);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        Logger.getLogger(Guice.class.getName()).addHandler(fakeHandler);
        try {
            injector.getInstance(Integer.class);
            LogRecord record = (LogRecord)Iterables.getOnlyElement((Iterable)logRecords);
            ProviderMethodsTest.assertEquals((String)"Guice injected null into {0} (a {1}), please mark it @Nullable. Use -Dguice_check_nullable_provides_params=ERROR to turn this into an error.", (String)record.getMessage());
            ProviderMethodsTest.assertEquals((Object)Errors.convert((Object)dependency.getKey()), (Object)record.getParameters()[1]);
        }
        finally {
            Logger.getLogger(Guice.class.getName()).removeHandler(fakeHandler);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Nullable {
    }

    static class ModuleImpl
    extends AbstractModule
    implements ProviderInterface<String> {
        ModuleImpl() {
        }

        @Override
        @Provides
        public String getT() {
            return "string";
        }

        @Provides
        public Object getObject() {
            return new Object();
        }
    }

    static interface ProviderInterface<T> {
        public T getT();
    }

    public static class ExposedSub
    extends RestrictedSuper {
    }

    static class RestrictedSuper
    extends AbstractModule {
        RestrictedSuper() {
        }

        @Provides
        public String provideFoo() {
            return "foo";
        }
    }

    static abstract class GenericSuperModule<T>
    extends AbstractModule {
        GenericSuperModule() {
        }

        @Provides
        String provide(T thing) {
            return thing.toString();
        }
    }

    static class SuperClassModule
    extends AbstractModule {
        SuperClassModule() {
        }

        @Provides
        Number providerMethod() {
            return 1.0;
        }

        @Provides
        @Named(value="rawlist")
        List rawProvider(@Named(value="list") List<String> f) {
            return f;
        }

        @Provides
        @Named(value="unrawlist")
        List<String> rawParameterProvider(@Named(value="rawlist") List f) {
            return f;
        }

        @Provides
        @Named(value="list")
        List<String> annotatedGenericProviderMethod() {
            return new ArrayList<String>();
        }

        @Provides
        @Named(value="collection")
        Collection<String> annotatedGenericParameterProviderMethod(@Named(value="list") List<String> foo) {
            return foo;
        }

        @Provides
        private String privateProviderMethod() {
            return "hello";
        }
    }

    private static class CallerInspecterSubClassModule
    extends CallerInspecterModule {
        String bazCallerClass;

        private CallerInspecterSubClassModule() {
        }

        protected void configure() {
        }

        @Provides
        @Singleton
        Double baz() {
            this.bazCallerClass = new Exception().getStackTrace()[1].getClassName();
            return 42.0;
        }
    }

    private static class CallerInspecterModule
    extends AbstractModule {
        String barCallerClass = "not_set_bar";
        String fooCallerClass = "not_set_foo";

        private CallerInspecterModule() {
        }

        @Provides
        @Singleton
        Integer foo() {
            this.fooCallerClass = new Exception().getStackTrace()[1].getClassName();
            return 42;
        }

        @Provides
        @Singleton
        Long bar() {
            this.barCallerClass = new Exception().getStackTrace()[1].getClassName();
            return 42L;
        }
    }

    private static class Sub2Module
    extends BaseModule {
        private Sub2Module() {
        }

        @Provides
        Float quux() {
            return Float.valueOf(42.0f);
        }
    }

    private static class Sub1Module
    extends BaseModule {
        private Sub1Module() {
        }

        @Provides
        Double baz() {
            return 42.0;
        }
    }

    private static class BaseModule
    extends AbstractModule {
        private BaseModule() {
        }

        @Provides
        Integer foo() {
            return 42;
        }

        @Provides
        Long bar() {
            return 42L;
        }
    }

    private static class VisibilityModule
    extends AbstractModule {
        private VisibilityModule() {
        }

        @Provides
        Integer foo() {
            return 42;
        }

        @Provides
        private Long bar() {
            return 42L;
        }

        @Provides
        protected Double baz() {
            return 42.0;
        }

        @Provides
        public Float quux() {
            return Float.valueOf(42.0f);
        }
    }

    private static class BindingCapturer<T>
    extends DefaultBindingTargetVisitor<T, ProvidesMethodBinding<T>>
    implements ProvidesMethodTargetVisitor<T, ProvidesMethodBinding<T>> {
        private BindingCapturer() {
        }

        public ProvidesMethodBinding<T> visit(ProvidesMethodBinding<? extends T> providesMethodBinding) {
            return providesMethodBinding;
        }

        protected ProvidesMethodBinding<T> visitOther(Binding<? extends T> binding) {
            throw new IllegalStateException("unexpected visit of: " + binding);
        }
    }

    private static class FooModule
    extends AbstractModule {
        private final AtomicReference<Logger> loggerRef;

        public FooModule(AtomicReference<Logger> loggerRef) {
            this.loggerRef = loggerRef;
        }

        @Provides
        Integer foo(Logger logger) {
            this.loggerRef.set(logger);
            return 42;
        }
    }

    static class HasWildcardInjection {
        @Inject
        List<? extends CharSequence> charSequences;
        @Inject
        List<? super Integer> numbers;
        @Inject
        Class<?> type;

        HasWildcardInjection() {
        }
    }

    abstract class ProvideTs<T>
    extends AbstractModule {
        final T first;
        final T second;

        protected ProvideTs(T first, T second) {
            this.first = first;
            this.second = second;
        }

        @Named(value="First")
        @Provides
        T provideFirst() {
            return this.first;
        }

        @Named(value="Second")
        @Provides
        T provideSecond() {
            return this.second;
        }

        @Provides
        Set<T> provideBoth(@Named(value="First") T first, @Named(value="Second") T second) {
            return ImmutableSet.of(first, second);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Blue {
    }

    public static interface Bar {
        public Foo getFoo();

        public int getI();
    }

    public static interface Foo {
        public Bar getBar();

        public int getI();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface Sole {
    }

    static interface Dagny {
        public int getAge();
    }

    static interface Bob {
        public String getName();

        public Dagny getDaughter();
    }
}

