/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import junit.framework.TestCase;

public class Jsr330Test
extends TestCase {
    private final B b = new B();
    private final C c = new C();
    private final D d = new D();
    private final E e = new E();
    public static final Red RED = new Red(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Red.class;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Red;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    };

    protected void setUp() throws Exception {
        J.nextInstanceId = 0;
        K.nextInstanceId = 0;
    }

    public void testInject() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).toInstance((Object)Jsr330Test.this.b);
                this.bind(C.class).toInstance((Object)Jsr330Test.this.c);
                this.bind(D.class).toInstance((Object)Jsr330Test.this.d);
                this.bind(E.class).toInstance((Object)Jsr330Test.this.e);
                this.bind(A.class);
            }
        }});
        A a = (A)injector.getInstance(A.class);
        Jsr330Test.assertSame((Object)this.b, (Object)a.b);
        Jsr330Test.assertSame((Object)this.c, (Object)a.c);
        Jsr330Test.assertSame((Object)this.d, (Object)a.d);
        Jsr330Test.assertSame((Object)this.e, (Object)a.e);
    }

    public void testQualifiedInject() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).annotatedWith((Annotation)Names.named((String)"jodie")).toInstance((Object)Jsr330Test.this.b);
                this.bind(C.class).annotatedWith(Red.class).toInstance((Object)Jsr330Test.this.c);
                this.bind(D.class).annotatedWith((Annotation)RED).toInstance((Object)Jsr330Test.this.d);
                this.bind(E.class).annotatedWith((Annotation)Names.named((String)"jesse")).toInstance((Object)Jsr330Test.this.e);
                this.bind(F.class);
            }
        }});
        F f = (F)injector.getInstance(F.class);
        Jsr330Test.assertSame((Object)this.b, (Object)f.b);
        Jsr330Test.assertSame((Object)this.c, (Object)f.c);
        Jsr330Test.assertSame((Object)this.d, (Object)f.d);
        Jsr330Test.assertSame((Object)this.e, (Object)f.e);
    }

    public void testProviderInject() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).annotatedWith((Annotation)Names.named((String)"jodie")).toInstance((Object)Jsr330Test.this.b);
                this.bind(C.class).toInstance((Object)Jsr330Test.this.c);
                this.bind(D.class).annotatedWith((Annotation)RED).toInstance((Object)Jsr330Test.this.d);
                this.bind(E.class).toInstance((Object)Jsr330Test.this.e);
                this.bind(G.class);
            }
        }});
        G g = (G)injector.getInstance(G.class);
        Jsr330Test.assertSame((Object)this.b, (Object)g.bProvider.get());
        Jsr330Test.assertSame((Object)this.c, (Object)g.cProvider.get());
        Jsr330Test.assertSame((Object)this.d, (Object)g.dProvider.get());
        Jsr330Test.assertSame((Object)this.e, (Object)g.eProvider.get());
    }

    public void testScopeAnnotation() {
        final TestScope scope = new TestScope();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).in((Scope)scope);
                this.bind(C.class).in(TestScoped.class);
                this.bindScope(TestScoped.class, scope);
            }
        }});
        B b = (B)injector.getInstance(B.class);
        Jsr330Test.assertSame((Object)b, (Object)injector.getInstance(B.class));
        Jsr330Test.assertSame((Object)b, (Object)injector.getInstance(B.class));
        C c = (C)injector.getInstance(C.class);
        Jsr330Test.assertSame((Object)c, (Object)injector.getInstance(C.class));
        Jsr330Test.assertSame((Object)c, (Object)injector.getInstance(C.class));
        H h = (H)injector.getInstance(H.class);
        Jsr330Test.assertSame((Object)h, (Object)injector.getInstance(H.class));
        Jsr330Test.assertSame((Object)h, (Object)injector.getInstance(H.class));
        scope.reset();
        Jsr330Test.assertNotSame((Object)b, (Object)injector.getInstance(B.class));
        Jsr330Test.assertNotSame((Object)c, (Object)injector.getInstance(C.class));
        Jsr330Test.assertNotSame((Object)h, (Object)injector.getInstance(H.class));
    }

    public void testSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).in(Singleton.class);
            }
        }});
        B b = (B)injector.getInstance(B.class);
        Jsr330Test.assertSame((Object)b, (Object)injector.getInstance(B.class));
        Jsr330Test.assertSame((Object)b, (Object)injector.getInstance(B.class));
        J j = (J)injector.getInstance(J.class);
        Jsr330Test.assertSame((Object)j, (Object)injector.getInstance(J.class));
        Jsr330Test.assertSame((Object)j, (Object)injector.getInstance(J.class));
    }

    public void testEagerSingleton() {
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(J.class);
                this.bind(K.class).in(Singleton.class);
            }
        }});
        Jsr330Test.assertEquals((int)1, (int)J.nextInstanceId);
        Jsr330Test.assertEquals((int)1, (int)K.nextInstanceId);
    }

    public void testScopesIsSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(J.class);
                this.bind(K.class).in(Singleton.class);
            }
        }});
        Jsr330Test.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(J.class)));
        Jsr330Test.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(K.class)));
    }

    public void testInjectingFinalFieldsIsForbidden() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(L.class);
                }
            }});
            Jsr330Test.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Injected field " + L.class.getName() + ".b cannot be final.");
        }
    }

    public void testInjectingAbstractMethodsIsForbidden() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(M.class);
                }
            }});
            Jsr330Test.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Injected method " + AbstractM.class.getName() + ".setB() cannot be abstract.");
        }
    }

    public void testInjectingMethodsWithTypeParametersIsForbidden() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(N.class);
                }
            }});
            Jsr330Test.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) Injected method " + N.class.getName() + ".setB() cannot declare type parameters of its own.");
        }
    }

    public void testInjectingMethodsWithNonVoidReturnTypes() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(P.class);
            }
        }});
    }

    public void testBindProviderClass() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).toProvider(BProvider.class);
                this.bind(B.class).annotatedWith((Annotation)Names.named((String)"1")).toProvider(BProvider.class);
                this.bind(B.class).annotatedWith((Annotation)Names.named((String)"2")).toProvider(Key.get(BProvider.class));
                this.bind(B.class).annotatedWith((Annotation)Names.named((String)"3")).toProvider(TypeLiteral.get(BProvider.class));
            }
        }});
        injector.getInstance(Key.get(B.class));
        injector.getInstance(Key.get(B.class, (Annotation)Names.named((String)"1")));
        injector.getInstance(Key.get(B.class, (Annotation)Names.named((String)"2")));
        injector.getInstance(Key.get(B.class, (Annotation)Names.named((String)"3")));
    }

    public void testGuicify330Provider() {
        javax.inject.Provider<String> jsr330Provider = new javax.inject.Provider<String>(){

            public String get() {
                return "A";
            }

            public String toString() {
                return "jsr330Provider";
            }
        };
        Provider guicified = Providers.guicify((javax.inject.Provider)jsr330Provider);
        Jsr330Test.assertEquals((String)"guicified(jsr330Provider)", (String)guicified.toString());
        Jsr330Test.assertEquals((String)"A", (String)((String)guicified.get()));
        Jsr330Test.assertSame((Object)guicified, (Object)Providers.guicify((javax.inject.Provider)guicified));
        Jsr330Test.assertFalse((boolean)(guicified instanceof HasDependencies));
    }

    public void testGuicifyWithDependencies() {
        javax.inject.Provider<String> jsr330Provider = new javax.inject.Provider<String>(){
            @Inject
            double d;
            int i;

            @Inject
            void injectMe(int i) {
                this.i = i;
            }

            public String get() {
                return this.d + "-" + this.i;
            }
        };
        final Provider guicified = Providers.guicify((javax.inject.Provider)jsr330Provider);
        Jsr330Test.assertTrue((boolean)(guicified instanceof HasDependencies));
        Set actual = ((HasDependencies)guicified).getDependencies();
        this.validateDependencies(actual, jsr330Provider.getClass());
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider(guicified);
                this.bind(Integer.TYPE).toInstance((Object)1);
                this.bind(Double.TYPE).toInstance((Object)2.0);
            }
        }});
        Binding binding = injector.getBinding(String.class);
        Jsr330Test.assertEquals((String)"2.0-1", (String)((String)binding.getProvider().get()));
        this.validateDependencies(actual, jsr330Provider.getClass());
    }

    private void validateDependencies(Set<Dependency<?>> actual, Class<?> owner) {
        Jsr330Test.assertEquals((String)actual.toString(), (int)2, (int)actual.size());
        Dependency<?> dDep = null;
        Dependency<?> iDep = null;
        for (Dependency<?> dep : actual) {
            if (dep.getKey().equals((Object)Key.get(Double.class))) {
                dDep = dep;
                continue;
            }
            if (!dep.getKey().equals((Object)Key.get(Integer.class))) continue;
            iDep = dep;
        }
        Jsr330Test.assertNotNull(dDep);
        Jsr330Test.assertNotNull(iDep);
        Jsr330Test.assertEquals((Object)TypeLiteral.get(owner), (Object)dDep.getInjectionPoint().getDeclaringType());
        Jsr330Test.assertEquals((String)"d", (String)dDep.getInjectionPoint().getMember().getName());
        Jsr330Test.assertEquals((int)-1, (int)dDep.getParameterIndex());
        Jsr330Test.assertEquals((Object)TypeLiteral.get(owner), (Object)iDep.getInjectionPoint().getDeclaringType());
        Jsr330Test.assertEquals((String)"injectMe", (String)iDep.getInjectionPoint().getMember().getName());
        Jsr330Test.assertEquals((int)0, (int)iDep.getParameterIndex());
    }

    static class BProvider
    implements javax.inject.Provider<B> {
        BProvider() {
        }

        public B get() {
            return new B();
        }
    }

    static class P {
        P() {
        }

        @Inject
        B setB(B b) {
            return b;
        }
    }

    static class N {
        N() {
        }

        @Inject
        <T> void setB(B b) {
        }
    }

    static class M
    extends AbstractM {
        M() {
        }

        @Override
        void setB(B b) {
        }
    }

    static abstract class AbstractM {
        AbstractM() {
        }

        @Inject
        abstract void setB(B var1);
    }

    static class L {
        @Inject
        final B b = null;

        L() {
        }
    }

    static class K {
        static int nextInstanceId = 0;
        int instanceId = nextInstanceId++;

        K() {
        }
    }

    @Singleton
    static class J {
        static int nextInstanceId = 0;
        int instanceId = nextInstanceId++;

        J() {
        }
    }

    @TestScoped
    static class H {
        H() {
        }
    }

    static class TestScope
    implements Scope {
        private int now = 0;

        TestScope() {
        }

        public <T> Provider<T> scope(Key<T> key, final Provider<T> unscoped) {
            return new Provider<T>(){
                private T value;
                private int snapshotTime = -1;

                public T get() {
                    if (this.snapshotTime != now) {
                        this.value = unscoped.get();
                        this.snapshotTime = now;
                    }
                    return this.value;
                }
            };
        }

        public void reset() {
            ++this.now;
        }
    }

    @javax.inject.Scope
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestScoped {
    }

    static class G {
        final javax.inject.Provider<B> bProvider;
        @Inject
        javax.inject.Provider<C> cProvider;
        javax.inject.Provider<D> dProvider;
        javax.inject.Provider<E> eProvider;

        @Inject
        G(@Named(value="jodie") javax.inject.Provider<B> bProvider) {
            this.bProvider = bProvider;
        }

        @Inject
        void injectD(@Red javax.inject.Provider<D> dProvider, javax.inject.Provider<E> eProvider) {
            this.dProvider = dProvider;
            this.eProvider = eProvider;
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Red {
    }

    static class F {
        final B b;
        @Inject
        @Red
        C c;
        D d;
        E e;

        @Inject
        F(@Named(value="jodie") B b) {
            this.b = b;
        }

        @Inject
        void injectD(@Red D d, @Named(value="jesse") E e) {
            this.d = d;
            this.e = e;
        }
    }

    static class E {
        E() {
        }
    }

    static class D {
        D() {
        }
    }

    static class C {
        C() {
        }
    }

    static class B {
        B() {
        }
    }

    static class A {
        final B b;
        @Inject
        C c;
        D d;
        E e;

        @Inject
        A(B b) {
            this.b = b;
        }

        @Inject
        void injectD(D d, E e) {
            this.d = d;
            this.e = e;
        }
    }
}

