/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Predicate;

final class KotlinNullabilitySupport {
    private final Function<Constructor<?>, Predicate<Integer>> constructorParameterNullability;
    private final Function<Method, Predicate<Integer>> methodParameterNullability;

    private KotlinNullabilitySupport(Function<Constructor<?>, Predicate<Integer>> constructorParameterNullability, Function<Method, Predicate<Integer>> methodParameterNullability) {
        this.constructorParameterNullability = constructorParameterNullability;
        this.methodParameterNullability = methodParameterNullability;
    }

    static KotlinNullabilitySupport getInstance() {
        return KotlinNullabilitySupportHolder.INSTANCE;
    }

    Predicate<Integer> getParameterPredicate(Constructor<?> constructor) {
        return this.constructorParameterNullability.apply(constructor);
    }

    Predicate<Integer> getParameterPredicate(Method method) {
        return this.methodParameterNullability.apply(method);
    }

    private static KotlinNullabilitySupport loadKotlinNullabilitySupport() {
        Function kotlinMethodParameterNullabilityFunction;
        Function kotlinConstructorParameterNullabilityFunction;
        try {
            Function localMethodFn;
            Function localConstructorFn;
            Class<?> clazz = Class.forName("com.google.inject.kotlin.KotlinParameterNullabilityFunctions");
            kotlinConstructorParameterNullabilityFunction = localConstructorFn = (Function)KotlinNullabilitySupport.getStaticField(clazz, "KOTLIN_CONSTRUCTOR_PARAMETER_NULLABILITY_FUNCTION");
            kotlinMethodParameterNullabilityFunction = localMethodFn = (Function)KotlinNullabilitySupport.getStaticField(clazz, "KOTLIN_METHOD_PARAMETER_NULLABILITY_FUNCTION");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            kotlinConstructorParameterNullabilityFunction = constructor -> index -> false;
            kotlinMethodParameterNullabilityFunction = method -> index -> false;
        }
        return new KotlinNullabilitySupport(kotlinConstructorParameterNullabilityFunction, kotlinMethodParameterNullabilityFunction);
    }

    private static Object getStaticField(Class<?> clazz, String methodName) throws NoSuchFieldException, IllegalAccessException {
        Field m = clazz.getDeclaredField(methodName);
        m.setAccessible(true);
        return m.get(null);
    }

    static /* synthetic */ KotlinNullabilitySupport access$000() {
        return KotlinNullabilitySupport.loadKotlinNullabilitySupport();
    }

    private static class KotlinNullabilitySupportHolder {
        static final KotlinNullabilitySupport INSTANCE = KotlinNullabilitySupport.access$000();

        private KotlinNullabilitySupportHolder() {
        }
    }
}

