/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class BinderTestSuite
extends TestCase {
    static final AtomicInteger nextId = new AtomicInteger();

    public static Test suite() {
        TestSuite suite = new TestSuite();
        new Builder().name("bind A").module((Module)new AbstractModule(){

            protected void configure() {
                this.bind(A.class);
            }
        }).creationException("No implementation for BinderTestSuite$A was bound.", new Object[0]).addToSuite(suite);
        Scoper[] scoperArray = BinderTestSuite.shortNamed(Names.named((String)"apple"));
        new Builder().name("bind PlainA named apple").module((Module)new AbstractModule(){

            protected void configure() {
                this.bind(PlainA.class).annotatedWith((Annotation)Names.named((String)"apple"));
            }
        }).creationException(new StringBuilder(70 + String.valueOf(scoperArray).length()).append("No implementation for BinderTestSuite$PlainA annotated with ").append((String)scoperArray).append(" was bound").toString(), new Object[0]).addToSuite(suite);
        new Builder().name("bind A to new PlainA(1)").module((Module)new AbstractModule(){

            protected void configure() {
                this.bind(A.class).toInstance((Object)new PlainA(1));
            }
        }).creationTime(CreationTime.NONE).expectedValues(new PlainA[]{new PlainA(1), new PlainA(1), new PlainA(1)}).addToSuite(suite);
        new Builder().name("no binding, AWithProvidedBy").key(Key.get(AWithProvidedBy.class), InjectsAWithProvidedBy.class).addToSuite(suite);
        new Builder().name("no binding, AWithImplementedBy").key(Key.get(AWithImplementedBy.class), InjectsAWithImplementedBy.class).addToSuite(suite);
        new Builder().name("no binding, ScopedA").key(Key.get(ScopedA.class), InjectsScopedA.class).expectedValues(new PlainA[]{new PlainA(201), new PlainA(201), new PlainA(202), new PlainA(202)}).addToSuite(suite);
        scoperArray = BinderTestSuite.shortNamed(Names.named((String)"apple"));
        new Builder().name("no binding, AWithProvidedBy named apple").key(Key.get(AWithProvidedBy.class, (Annotation)Names.named((String)"apple")), InjectsAWithProvidedByNamedApple.class).configurationException(new StringBuilder(79 + String.valueOf(scoperArray).length()).append("No implementation for BinderTestSuite$AWithProvidedBy annotated with ").append((String)scoperArray).append(" was bound").toString(), new Object[0]).addToSuite(suite);
        scoperArray = BinderTestSuite.shortNamed(Names.named((String)"apple"));
        new Builder().name("no binding, AWithImplementedBy named apple").key(Key.get(AWithImplementedBy.class, (Annotation)Names.named((String)"apple")), InjectsAWithImplementedByNamedApple.class).configurationException(new StringBuilder(82 + String.valueOf(scoperArray).length()).append("No implementation for BinderTestSuite$AWithImplementedBy annotated with ").append((String)scoperArray).append(" was bound").toString(), new Object[0]).addToSuite(suite);
        scoperArray = BinderTestSuite.shortNamed(Names.named((String)"apple"));
        new Builder().name("no binding, ScopedA named apple").key(Key.get(ScopedA.class, (Annotation)Names.named((String)"apple")), InjectsScopedANamedApple.class).configurationException(new StringBuilder(71 + String.valueOf(scoperArray).length()).append("No implementation for BinderTestSuite$ScopedA annotated with ").append((String)scoperArray).append(" was bound").toString(), new Object[0]).addToSuite(suite);
        for (final Scoper scoper : Scoper.values()) {
            new Builder().name("bind PlainA").key(Key.get(PlainA.class), InjectsPlainA.class).module((Module)new AbstractModule(){

                protected void configure() {
                    AnnotatedBindingBuilder abb = this.bind(PlainA.class);
                    scoper.configure((ScopedBindingBuilder)abb);
                }
            }).scoper(scoper).addToSuite(suite);
            new Builder().name("bind A to PlainA").module((Module)new AbstractModule(){

                protected void configure() {
                    ScopedBindingBuilder sbb = this.bind(A.class).to(PlainA.class);
                    scoper.configure(sbb);
                }
            }).scoper(scoper).addToSuite(suite);
            new Builder().name("bind A to PlainAProvider.class").module((Module)new AbstractModule(){

                protected void configure() {
                    ScopedBindingBuilder sbb = this.bind(A.class).toProvider(PlainAProvider.class);
                    scoper.configure(sbb);
                }
            }).scoper(scoper).addToSuite(suite);
            new Builder().name("bind A to new PlainAProvider()").module((Module)new AbstractModule(){

                protected void configure() {
                    ScopedBindingBuilder sbb = this.bind(A.class).toProvider((Provider)new PlainAProvider());
                    scoper.configure(sbb);
                }
            }).scoper(scoper).addToSuite(suite);
            new Builder().name("bind AWithProvidedBy").key(Key.get(AWithProvidedBy.class), InjectsAWithProvidedBy.class).module((Module)new AbstractModule(){

                protected void configure() {
                    AnnotatedBindingBuilder sbb = this.bind(AWithProvidedBy.class);
                    scoper.configure((ScopedBindingBuilder)sbb);
                }
            }).scoper(scoper).addToSuite(suite);
            new Builder().name("bind AWithImplementedBy").key(Key.get(AWithImplementedBy.class), InjectsAWithImplementedBy.class).module((Module)new AbstractModule(){

                protected void configure() {
                    AnnotatedBindingBuilder sbb = this.bind(AWithImplementedBy.class);
                    scoper.configure((ScopedBindingBuilder)sbb);
                }
            }).scoper(scoper).addToSuite(suite);
            new Builder().name("bind ScopedA").key(Key.get(ScopedA.class), InjectsScopedA.class).module((Module)new AbstractModule(){

                protected void configure() {
                    AnnotatedBindingBuilder sbb = this.bind(ScopedA.class);
                    scoper.configure((ScopedBindingBuilder)sbb);
                }
            }).expectedValues(new PlainA[]{new PlainA(201), new PlainA(201), new PlainA(202), new PlainA(202)}).scoper(scoper).addToSuite(suite);
            String string = BinderTestSuite.shortNamed(Names.named((String)"apple"));
            new Builder().name("bind AWithProvidedBy named apple").module((Module)new AbstractModule(){

                protected void configure() {
                    scoper.configure((ScopedBindingBuilder)this.bind(AWithProvidedBy.class).annotatedWith((Annotation)Names.named((String)"apple")));
                }
            }).creationException(new StringBuilder(79 + String.valueOf(string).length()).append("No implementation for BinderTestSuite$AWithProvidedBy annotated with ").append(string).append(" was bound").toString(), new Object[0]).scoper(scoper).addToSuite(suite);
            string = BinderTestSuite.shortNamed(Names.named((String)"apple"));
            new Builder().name("bind AWithImplementedBy named apple").module((Module)new AbstractModule(){

                protected void configure() {
                    scoper.configure((ScopedBindingBuilder)this.bind(AWithImplementedBy.class).annotatedWith((Annotation)Names.named((String)"apple")));
                }
            }).creationException(new StringBuilder(82 + String.valueOf(string).length()).append("No implementation for BinderTestSuite$AWithImplementedBy annotated with ").append(string).append(" was bound").toString(), new Object[0]).scoper(scoper).addToSuite(suite);
            string = BinderTestSuite.shortNamed(Names.named((String)"apple"));
            new Builder().name("bind ScopedA named apple").module((Module)new AbstractModule(){

                protected void configure() {
                    scoper.configure((ScopedBindingBuilder)this.bind(ScopedA.class).annotatedWith((Annotation)Names.named((String)"apple")));
                }
            }).creationException(new StringBuilder(71 + String.valueOf(string).length()).append("No implementation for BinderTestSuite$ScopedA annotated with ").append(string).append(" was bound").toString(), new Object[0]).scoper(scoper).addToSuite(suite);
        }
        return suite;
    }

    private static String shortNamed(Named named) {
        return named.toString().replace("com.google.inject.name.", "");
    }

    static class Injectable {
        Object value = new Object();
        Provider<?> provider = Providers.of((Object)new Object());

        Injectable() {
        }
    }

    static class InjectsScopedANamedApple
    extends Injectable {
        InjectsScopedANamedApple() {
        }

        @Inject
        public void inject(@Named(value="apple") ScopedA scopedA, @Named(value="apple") Provider<ScopedA> scopedAProvider) {
            this.value = scopedA;
            this.provider = scopedAProvider;
        }
    }

    static class InjectsScopedA
    extends Injectable {
        InjectsScopedA() {
        }

        @Inject
        public void inject(ScopedA scopedA, Provider<ScopedA> scopedAProvider) {
            this.value = scopedA;
            this.provider = scopedAProvider;
        }
    }

    @TwoAtATimeScoped
    static class ScopedA
    extends PlainA {
        ScopedA() {
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ScopeAnnotation
    public static @interface TwoAtATimeScoped {
    }

    static class TwoAtATimeScope
    implements Scope {
        TwoAtATimeScope() {
        }

        public <T> Provider<T> scope(Key<T> key, final Provider<T> unscoped) {
            return new Provider<T>(this){
                T instance;

                public T get() {
                    if (this.instance == null) {
                        this.instance = unscoped.get();
                        return this.instance;
                    }
                    Object result = this.instance;
                    this.instance = null;
                    return result;
                }
            };
        }
    }

    static class InjectsPlainA
    extends Injectable {
        InjectsPlainA() {
        }

        @Inject
        public void inject(PlainA plainA, Provider<PlainA> plainAProvider) {
            this.value = plainA;
            this.provider = plainAProvider;
        }
    }

    static class PlainAProvider
    implements Provider<A> {
        PlainAProvider() {
        }

        public A get() {
            return new PlainA();
        }
    }

    static class PlainA
    implements A {
        final int value;

        PlainA() {
            this.value = nextId.getAndIncrement();
            if (this.value < 0) {
                int n = this.value;
                throw new RuntimeException(new StringBuilder(26).append("Illegal value: ").append(n).toString());
            }
        }

        PlainA(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj instanceof PlainA && this.value == ((PlainA)obj).value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            int n = this.value;
            return new StringBuilder(18).append("PlainA#").append(n).toString();
        }
    }

    static class InjectsA
    extends Injectable {
        InjectsA() {
        }

        @Inject
        public void inject(A a, Provider<A> aProvider) {
            this.value = a;
            this.provider = aProvider;
        }
    }

    static interface A
    extends AWithProvidedBy,
    AWithImplementedBy {
    }

    static class InjectsAWithImplementedByNamedApple
    extends Injectable {
        InjectsAWithImplementedByNamedApple() {
        }

        @Inject
        public void inject(@Named(value="apple") AWithImplementedBy aWithImplementedBy, @Named(value="apple") Provider<AWithImplementedBy> aWithImplementedByProvider) {
            this.value = aWithImplementedBy;
            this.provider = aWithImplementedByProvider;
        }
    }

    static class InjectsAWithImplementedBy
    extends Injectable {
        InjectsAWithImplementedBy() {
        }

        @Inject
        public void inject(AWithImplementedBy aWithImplementedBy, Provider<AWithImplementedBy> aWithImplementedByProvider) {
            this.value = aWithImplementedBy;
            this.provider = aWithImplementedByProvider;
        }
    }

    @ImplementedBy(value=PlainA.class)
    static interface AWithImplementedBy {
    }

    static class InjectsAWithProvidedByNamedApple
    extends Injectable {
        InjectsAWithProvidedByNamedApple() {
        }

        @Inject
        public void inject(@Named(value="apple") AWithProvidedBy aWithProvidedBy, @Named(value="apple") Provider<AWithProvidedBy> aWithProvidedByProvider) {
            this.value = aWithProvidedBy;
            this.provider = aWithProvidedByProvider;
        }
    }

    static class InjectsAWithProvidedBy
    extends Injectable {
        InjectsAWithProvidedBy() {
        }

        @Inject
        public void inject(AWithProvidedBy aWithProvidedBy, Provider<AWithProvidedBy> aWithProvidedByProvider) {
            this.value = aWithProvidedBy;
            this.provider = aWithProvidedByProvider;
        }
    }

    @ProvidedBy(value=PlainAProvider.class)
    static interface AWithProvidedBy {
    }

    public static class UserExceptionsTest
    extends TestCase {
        final String name;
        final Key<?> key;
        final Class<? extends Injectable> injectsKey;
        final ImmutableList<Module> modules;
        final ImmutableList<Object> expectedValues;
        final CreationTime creationTime;

        public UserExceptionsTest(Builder builder) {
            super("test");
            this.name = builder.name;
            this.key = builder.key;
            this.injectsKey = builder.injectsKey;
            this.modules = ImmutableList.copyOf((Collection)builder.modules);
            this.expectedValues = ImmutableList.copyOf((Collection)builder.expectedValues);
            this.creationTime = builder.creationTime;
        }

        public String getName() {
            String string = String.valueOf(this.name);
            return string.length() != 0 ? "provision errors:".concat(string) : new String("provision errors:");
        }

        Injector newInjector() {
            return Guice.createInjector(this.modules);
        }

        public void test() throws IllegalAccessException, InstantiationException {
            nextId.set(-1);
            try {
                this.newInjector();
                UserExceptionsTest.assertEquals((Object)((Object)CreationTime.LAZY), (Object)((Object)this.creationTime));
            }
            catch (CreationException expected) {
                UserExceptionsTest.assertEquals((Object)((Object)CreationTime.EAGER), (Object)((Object)this.creationTime));
                Asserts.assertContains(expected.getMessage(), "Illegal value: -1");
                return;
            }
            Provider provider = this.newInjector().getProvider(this.key);
            Provider bindingProvider = this.newInjector().getBinding(this.key).getProvider();
            nextId.set(-1);
            try {
                this.newInjector().getInstance(this.key);
                UserExceptionsTest.fail();
            }
            catch (ProvisionException expected) {
                Asserts.assertContains(expected.getMessage(), "Illegal value: -1");
            }
            nextId.set(-1);
            try {
                provider.get();
                UserExceptionsTest.fail();
            }
            catch (ProvisionException expected) {
                Asserts.assertContains(expected.getMessage(), "Illegal value: -1");
            }
            nextId.set(-1);
            try {
                bindingProvider.get();
                UserExceptionsTest.fail();
            }
            catch (ProvisionException expected) {
                Asserts.assertContains(expected.getMessage(), "Illegal value: -1");
            }
            try {
                nextId.set(-1);
                this.newInjector().getInstance(this.injectsKey);
                UserExceptionsTest.fail((String)"Expected ProvisionException");
            }
            catch (ProvisionException expected) {
                Asserts.assertContains(expected.getMessage(), "Illegal value: -1", "for 1st parameter");
            }
            nextId.set(201);
            Injectable injectable = this.injectsKey.newInstance();
            try {
                nextId.set(-1);
                this.newInjector().injectMembers((Object)injectable);
            }
            catch (ProvisionException expected) {
                Asserts.assertContains(expected.getMessage(), "Illegal value: -1", "for 1st parameter");
            }
            nextId.set(201);
            Injectable hasProvider = (Injectable)this.newInjector().getInstance(this.injectsKey);
            hasProvider.provider.get();
            try {
                nextId.set(-1);
                hasProvider.provider.get();
            }
            catch (ProvisionException expected) {
                Asserts.assertContains(expected.getMessage(), "Illegal value: -1");
            }
        }
    }

    public static class ConfigurationExceptionTest
    extends TestCase {
        final String name;
        final Key<?> key;
        final Class<? extends Injectable> injectsKey;
        final ImmutableList<Module> modules;
        final String configurationException;

        public ConfigurationExceptionTest(Builder builder) {
            super("test");
            this.name = builder.name;
            this.key = builder.key;
            this.injectsKey = builder.injectsKey;
            this.modules = ImmutableList.copyOf((Collection)builder.modules);
            this.configurationException = builder.configurationException;
        }

        public String getName() {
            String string = String.valueOf(this.name);
            return string.length() != 0 ? "provision errors:".concat(string) : new String("provision errors:");
        }

        Injector newInjector() {
            return Guice.createInjector(this.modules);
        }

        public void test() throws IllegalAccessException, InstantiationException {
            try {
                this.newInjector().getProvider(this.key);
                ConfigurationExceptionTest.fail();
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.configurationException);
            }
            try {
                this.newInjector().getBinding(this.key).getProvider();
                ConfigurationExceptionTest.fail();
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.configurationException);
            }
            try {
                this.newInjector().getInstance(this.key);
                ConfigurationExceptionTest.fail();
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.configurationException);
            }
            try {
                this.newInjector().getInstance(this.injectsKey);
                ConfigurationExceptionTest.fail();
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.configurationException, String.valueOf(this.injectsKey.getSimpleName()).concat(".inject"), String.valueOf(this.injectsKey.getSimpleName()).concat(".inject"), "1 error");
            }
            try {
                Injectable injectable = this.injectsKey.newInstance();
                this.newInjector().injectMembers((Object)injectable);
                ConfigurationExceptionTest.fail();
            }
            catch (ConfigurationException expected) {
                Asserts.assertContains(expected.getMessage(), this.configurationException, String.valueOf(this.injectsKey.getSimpleName()).concat(".inject"), String.valueOf(this.injectsKey.getSimpleName()).concat(".inject"), "1 error");
            }
        }
    }

    public static class CreationExceptionTest
    extends TestCase {
        final String name;
        final Key<?> key;
        final ImmutableList<Module> modules;
        final String creationException;

        public CreationExceptionTest(Builder builder) {
            super("test");
            this.name = builder.name;
            this.key = builder.key;
            this.modules = ImmutableList.copyOf((Collection)builder.modules);
            this.creationException = builder.creationException;
        }

        public String getName() {
            String string = String.valueOf(this.name);
            return string.length() != 0 ? "creation errors:".concat(string) : new String("creation errors:");
        }

        public void test() {
            try {
                Guice.createInjector(this.modules);
                CreationExceptionTest.fail();
            }
            catch (CreationException expected) {
                Asserts.assertContains(expected.getMessage(), this.creationException);
            }
        }
    }

    public static class SuccessTest
    extends TestCase {
        final String name;
        final Key<?> key;
        final Class<? extends Injectable> injectsKey;
        final ImmutableList<Module> modules;
        final ImmutableList<Object> expectedValues;

        public SuccessTest(Builder builder) {
            super("test");
            this.name = builder.name;
            this.key = builder.key;
            this.injectsKey = builder.injectsKey;
            this.modules = ImmutableList.copyOf((Collection)builder.modules);
            this.expectedValues = ImmutableList.copyOf((Collection)builder.expectedValues);
        }

        public String getName() {
            return this.name;
        }

        Injector newInjector() {
            nextId.set(101);
            return Guice.createInjector(this.modules);
        }

        public void test() throws IllegalAccessException, InstantiationException {
            Injector injector = this.newInjector();
            nextId.set(201);
            for (Object value : this.expectedValues) {
                SuccessTest.assertEquals(value, (Object)injector.getInstance(this.key));
            }
            Provider provider = this.newInjector().getProvider(this.key);
            nextId.set(201);
            for (Object value : this.expectedValues) {
                SuccessTest.assertEquals(value, (Object)provider.get());
            }
            Provider bindingProvider = this.newInjector().getBinding(this.key).getProvider();
            nextId.set(201);
            for (Object value : this.expectedValues) {
                SuccessTest.assertEquals(value, (Object)bindingProvider.get());
            }
            injector = this.newInjector();
            nextId.set(201);
            for (Object value : this.expectedValues) {
                Injectable instance = (Injectable)injector.getInstance(this.injectsKey);
                SuccessTest.assertEquals(value, (Object)instance.value);
            }
            injector = this.newInjector();
            nextId.set(201);
            for (Object value : this.expectedValues) {
                Injectable injectable = this.injectsKey.newInstance();
                injector.injectMembers((Object)injectable);
                SuccessTest.assertEquals(value, (Object)injectable.value);
            }
            Injector injector1 = this.newInjector();
            nextId.set(201);
            Injectable hasProvider = (Injectable)injector1.getInstance(this.injectsKey);
            hasProvider.provider.get();
            nextId.set(201);
            for (Object value : this.expectedValues) {
                SuccessTest.assertEquals(value, (Object)hasProvider.provider.get());
            }
        }
    }

    public static class Builder {
        private String name = "test";
        private Key<?> key = Key.get(A.class);
        private Class<? extends Injectable> injectsKey = InjectsA.class;
        private List<Module> modules = Lists.newArrayList((Object[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindScope(TwoAtATimeScoped.class, new TwoAtATimeScope());
            }
        }});
        private List<Object> expectedValues = Lists.newArrayList((Object[])new Object[]{new PlainA(201), new PlainA(202), new PlainA(203)});
        private CreationTime creationTime = CreationTime.LAZY;
        private String creationException;
        private String configurationException;

        public Builder module(Module module) {
            this.modules.add(module);
            return this;
        }

        public Builder creationTime(CreationTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder key(Key<?> key, Class<? extends Injectable> injectsKey) {
            this.key = key;
            this.injectsKey = injectsKey;
            return this;
        }

        private Builder creationException(String message, Object ... args) {
            this.creationException = String.format(message, args);
            return this;
        }

        private Builder configurationException(String message, Object ... args) {
            this.configurationException = String.format(message, args);
            return this;
        }

        private Builder scoper(Scoper scoper) {
            String string = this.name;
            String string2 = String.valueOf((Object)scoper);
            this.name(new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" in ").append(string2).toString());
            scoper.apply(this);
            return this;
        }

        private <T> Builder expectedValues(T ... values) {
            this.expectedValues.clear();
            Collections.addAll(this.expectedValues, values);
            return this;
        }

        public void addToSuite(TestSuite suite) {
            if (this.creationException != null) {
                suite.addTest((Test)new CreationExceptionTest(this));
            } else if (this.configurationException != null) {
                suite.addTest((Test)new ConfigurationExceptionTest(this));
            } else {
                suite.addTest((Test)new SuccessTest(this));
                if (this.creationTime != CreationTime.NONE) {
                    suite.addTest((Test)new UserExceptionsTest(this));
                }
            }
        }
    }

    static enum CreationTime {
        NONE,
        EAGER,
        LAZY;

    }

    static enum Scoper {
        UNSCOPED{

            @Override
            void configure(ScopedBindingBuilder sbb) {
            }

            @Override
            void apply(Builder builder) {
            }
        }
        ,
        EAGER_SINGLETON{

            @Override
            void configure(ScopedBindingBuilder sbb) {
                sbb.asEagerSingleton();
            }

            @Override
            void apply(Builder builder) {
                builder.expectedValues(new PlainA[]{new PlainA(101), new PlainA(101), new PlainA(101)});
                builder.creationTime(CreationTime.EAGER);
            }
        }
        ,
        SCOPES_SINGLETON{

            @Override
            void configure(ScopedBindingBuilder sbb) {
                sbb.in(Scopes.SINGLETON);
            }

            @Override
            void apply(Builder builder) {
                builder.expectedValues(new PlainA[]{new PlainA(201), new PlainA(201), new PlainA(201)});
            }
        }
        ,
        SINGLETON_DOT_CLASS{

            @Override
            void configure(ScopedBindingBuilder sbb) {
                sbb.in(Singleton.class);
            }

            @Override
            void apply(Builder builder) {
                builder.expectedValues(new PlainA[]{new PlainA(201), new PlainA(201), new PlainA(201)});
            }
        }
        ,
        TWO_AT_A_TIME_SCOPED_DOT_CLASS{

            @Override
            void configure(ScopedBindingBuilder sbb) {
                sbb.in(TwoAtATimeScoped.class);
            }

            @Override
            void apply(Builder builder) {
                builder.expectedValues(new PlainA[]{new PlainA(201), new PlainA(201), new PlainA(202), new PlainA(202)});
            }
        }
        ,
        TWO_AT_A_TIME_SCOPE{

            @Override
            void configure(ScopedBindingBuilder sbb) {
                sbb.in((Scope)new TwoAtATimeScope());
            }

            @Override
            void apply(Builder builder) {
                builder.expectedValues(new PlainA[]{new PlainA(201), new PlainA(201), new PlainA(202), new PlainA(202)});
            }
        };


        abstract void configure(ScopedBindingBuilder var1);

        abstract void apply(Builder var1);
    }
}

