/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.Annotations;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import junit.framework.TestCase;

public class BindingAnnotationTest
extends TestCase {
    public void testAnnotationWithValueMatchesKeyWithTypeOnly() throws CreationException {
        Injector c = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith(Blue.class).to("foo");
                this.bind(BlueFoo.class);
            }
        }});
        BlueFoo foo = (BlueFoo)c.getInstance(BlueFoo.class);
        BindingAnnotationTest.assertEquals((String)"foo", (String)foo.s);
    }

    public void testRequireExactAnnotationsDisablesFallback() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.binder().requireExactBindingAnnotations();
                    this.bindConstant().annotatedWith(Blue.class).to("foo");
                    this.bind(BlueFoo.class);
                }
            }});
            BindingAnnotationTest.fail();
        }
        catch (CreationException expected) {
            String[] stringArray = new String[3];
            stringArray[0] = "No implementation for String annotated with";
            String string = Annotations.memberValueString((String)"value", (Object)5);
            stringArray[1] = new StringBuilder(38 + String.valueOf(string).length()).append("BindingAnnotationTest$Blue(").append(string).append(") was bound").toString();
            stringArray[2] = "at BindingAnnotationTest$2.configure";
            Asserts.assertContains(expected.getMessage(), true, stringArray);
        }
    }

    public void testRequireExactAnnotationsDoesntBreakIfDefaultsExist() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.binder().requireExactBindingAnnotations();
                this.bindConstant().annotatedWith(Red.class).to("foo");
                this.bind(RedFoo.class);
            }
        }}).getInstance(RedFoo.class);
    }

    public void testRequireExactAnnotationsRequireAllOptionals() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.binder().requireExactBindingAnnotations();
                    this.bindConstant().annotatedWith(Color.class).to("foo");
                    this.bind(ColorFoo.class);
                }
            }});
            BindingAnnotationTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), true, "No implementation for String annotated with", "BindingAnnotationTest$Color", "at BindingAnnotationTest$4.configure");
        }
    }

    public void testAnnotationWithValueThatDoesntMatch() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bindConstant().annotatedWith((Annotation)BindingAnnotationTest.this.createBlue(6)).to("six");
                    this.bind(String.class).toInstance((Object)"bar");
                    this.bind(BlueFoo.class);
                }
            }});
            BindingAnnotationTest.fail();
        }
        catch (CreationException expected) {
            String[] stringArray = new String[3];
            stringArray[0] = "No implementation for String annotated with";
            String string = Annotations.memberValueString((String)"value", (Object)5);
            stringArray[1] = new StringBuilder(38 + String.valueOf(string).length()).append("BindingAnnotationTest$Blue(").append(string).append(") was bound").toString();
            stringArray[2] = "at BindingAnnotationTest$5.configure";
            Asserts.assertContains(expected.getMessage(), true, stringArray);
        }
    }

    public Blue createBlue(final int value) {
        return new Blue(this){

            @Override
            public int value() {
                return value;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Blue.class;
            }

            @Override
            public boolean equals(Object o) {
                return o instanceof Blue && ((Blue)o).value() == value;
            }

            @Override
            public int hashCode() {
                return 127 * "value".hashCode() ^ value;
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Color {
        public int r() default 0;

        public int g() default 0;

        public int b();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Red {
        public int r() default 42;

        public int g() default 42;

        public int b() default 42;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Blue {
        public int value();
    }

    static class ColorFoo {
        @Inject
        @Color(b=2)
        String s;

        ColorFoo() {
        }
    }

    static class RedFoo {
        @Inject
        @Red
        String s;

        RedFoo() {
        }
    }

    static class BlueFoo {
        @Inject
        @Blue(value=5)
        String s;

        BlueFoo() {
        }
    }
}

