/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Runnables;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BindingTest {
    private static List<Butter> butters = new ArrayList<Butter>();

    @Test
    public void testExplicitCyclicDependency() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(A.class);
                this.bind(B.class);
            }
        }}).getInstance(A.class);
    }

    @Test
    public void testBindToUnboundLinkedBinding() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(Collection.class).to(List.class);
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "No implementation for List was bound.");
        }
    }

    @Test
    public void testScopeIsAppliedToKeyNotTarget() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Integer.class).toProvider(Counter.class).asEagerSingleton();
                this.bind(Number.class).toProvider(Counter.class).asEagerSingleton();
            }
        }});
        Assert.assertNotSame((Object)injector.getInstance(Integer.class), (Object)injector.getInstance(Number.class));
    }

    @Test
    public void testAnnotatedNoArgConstructor() {
        this.assertBindingSucceeds(PublicNoArgAnnotated.class);
        this.assertBindingSucceeds(ProtectedNoArgAnnotated.class);
        this.assertBindingSucceeds(PackagePrivateNoArgAnnotated.class);
        this.assertBindingSucceeds(PrivateNoArgAnnotated.class);
    }

    @Test
    public void testUnannotatedNoArgConstructor() throws Exception {
        this.assertBindingSucceeds(PublicNoArg.class);
        this.assertBindingSucceeds(ProtectedNoArg.class);
        this.assertBindingSucceeds(PackagePrivateNoArg.class);
        this.assertBindingSucceeds(PrivateNoArgInPrivateClass.class);
        this.assertBindingFails(PrivateNoArg.class);
    }

    private void assertBindingSucceeds(Class<?> clazz) {
        Assert.assertNotNull((Object)Guice.createInjector((Module[])new Module[0]).getInstance(clazz));
    }

    private void assertBindingFails(Class<?> clazz) throws NoSuchMethodException {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(clazz);
            Assert.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "No injectable constructor for type BindingTest$PrivateNoArg", "BindingTest$PrivateNoArg.class(BindingTest.java:");
        }
    }

    @Test
    public void testTooManyConstructors() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(TooManyConstructors.class);
            Assert.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "BindingTest$TooManyConstructors has more than one constructor annotated with @Inject. Injectable classes must have either one (and only one) constructor", "at BindingTest$TooManyConstructors.class(BindingTest.java:");
        }
    }

    @Test
    public void testToConstructorBinding() throws NoSuchMethodException {
        final Constructor constructor = D.class.getConstructor(Stage.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Object.class).toConstructor(constructor);
            }
        }});
        D d = (D)injector.getInstance(Object.class);
        Assert.assertEquals((Object)Stage.DEVELOPMENT, (Object)d.stage);
    }

    @Test
    public void testToConstructorBindingsOnParameterizedTypes() throws NoSuchMethodException {
        Constructor constructor = C.class.getConstructor(Stage.class, Object.class);
        Key<Object> s = new Key<Object>(this, (Annotation)Names.named((String)"s")){};
        Key<Object> i = new Key<Object>(this, (Annotation)Names.named((String)"i")){};
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this, (Key)s, constructor, (Key)i){
            final /* synthetic */ Key val$s;
            final /* synthetic */ Constructor val$constructor;
            final /* synthetic */ Key val$i;
            {
                this.val$s = key;
                this.val$constructor = constructor;
                this.val$i = key2;
            }

            protected void configure() {
                this.bind(this.val$s).toConstructor(this.val$constructor, (TypeLiteral)new TypeLiteral<C<Stage>>(this){});
                this.bind(this.val$i).toConstructor(this.val$constructor, (TypeLiteral)new TypeLiteral<C<Injector>>(this){});
            }
        }});
        C one = (C)injector.getInstance((Key)s);
        Assert.assertEquals((Object)Stage.DEVELOPMENT, (Object)one.stage);
        Assert.assertEquals((Object)Stage.DEVELOPMENT, (Object)one.t);
        Assert.assertEquals((Object)Stage.DEVELOPMENT, one.anotherT);
        C two = (C)injector.getInstance((Key)i);
        Assert.assertEquals((Object)Stage.DEVELOPMENT, (Object)two.stage);
        Assert.assertEquals((Object)injector, (Object)two.t);
        Assert.assertEquals((Object)injector, two.anotherT);
    }

    @Test
    public void testToConstructorBindingsFailsOnRawTypes() throws NoSuchMethodException {
        final Constructor constructor = C.class.getConstructor(Stage.class, Object.class);
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(Object.class).toConstructor(constructor);
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "T cannot be used as a key; It is not fully specified.", "at BindingTest$C.<init>(BindingTest.java:", "T cannot be used as a key; It is not fully specified.", "at BindingTest$C.anotherT(BindingTest.java:");
        }
    }

    @Test
    public void testToConstructorAndMethodInterceptors() throws NoSuchMethodException {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
        final Constructor constructor = D.class.getConstructor(Stage.class);
        final AtomicInteger count = new AtomicInteger();
        final MethodInterceptor countingInterceptor = new MethodInterceptor(this){

            public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                count.incrementAndGet();
                return methodInvocation.proceed();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Object.class).toConstructor(constructor);
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{countingInterceptor});
            }
        }});
        D d = (D)injector.getInstance(Object.class);
        d.hashCode();
        d.hashCode();
        Assert.assertEquals((long)2L, (long)count.get());
    }

    @Test
    public void testInaccessibleConstructor() throws NoSuchMethodException {
        final Constructor constructor = E.class.getDeclaredConstructor(Stage.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(E.class).toConstructor(constructor);
            }
        }});
        E e = (E)injector.getInstance(E.class);
        Assert.assertEquals((Object)Stage.DEVELOPMENT, (Object)e.stage);
    }

    @Test
    public void testToConstructorAndScopes() throws NoSuchMethodException {
        final Constructor constructor = F.class.getConstructor(Stage.class);
        final Key d = Key.get(Object.class, (Annotation)Names.named((String)"D"));
        final Key s = Key.get(Object.class, (Annotation)Names.named((String)"S"));
        final Key n = Key.get(Object.class, (Annotation)Names.named((String)"N"));
        final Key r = Key.get(Object.class, (Annotation)Names.named((String)"R"));
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(d).toConstructor(constructor);
                this.bind(s).toConstructor(constructor).in(Singleton.class);
                this.bind(n).toConstructor(constructor).in(Scopes.NO_SCOPE);
                this.bind(r).to(F.class);
            }
        }});
        this.assertDistinct(injector, 1, d, d, d, d);
        this.assertDistinct(injector, 1, s, s, s, s);
        this.assertDistinct(injector, 4, n, n, n, n);
        this.assertDistinct(injector, 1, r, r, r, r);
        this.assertDistinct(injector, 4, d, d, r, r, s, s, n);
    }

    public void assertDistinct(Injector injector, int expectedCount, Key<?> ... keys) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Key<?> k : keys) {
            builder.add(injector.getInstance(k));
        }
        Assert.assertEquals((long)expectedCount, (long)builder.build().size());
    }

    @Test
    public void testToConstructorSpiData() throws NoSuchMethodException {
        final HashSet heardTypes = Sets.newHashSet();
        final Constructor constructor = D.class.getConstructor(Stage.class);
        final TypeListener listener = new TypeListener(this){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                if (!heardTypes.add(type)) {
                    String string = String.valueOf(type);
                    Assert.fail((String)new StringBuilder(22 + String.valueOf(string).length()).append("Heard ").append(string).append(" multiple times!").toString());
                }
            }
        };
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Object.class).toConstructor(constructor);
                this.bind(D.class).toConstructor(constructor);
                this.bindListener(Matchers.any(), listener);
            }
        }});
        Assert.assertEquals((Object)ImmutableSet.of((Object)TypeLiteral.get(D.class)), (Object)heardTypes);
    }

    @Test
    public void testInterfaceToImplementationConstructor() throws NoSuchMethodException {
        final Constructor constructor = CFoo.class.getDeclaredConstructor(new Class[0]);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(IFoo.class).toConstructor(constructor);
            }
        }});
        injector.getInstance(IFoo.class);
    }

    @Test
    public void testGetAllBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(D.class).toInstance((Object)new D(Stage.PRODUCTION));
                this.bind(Object.class).to(D.class);
                this.getProvider((Key)new Key<C<Stage>>(this){});
            }
        }});
        Map bindings = injector.getAllBindings();
        Assert.assertEquals((Object)ImmutableSet.of((Object)Key.get(Injector.class), (Object)Key.get(Stage.class), (Object)Key.get(D.class), (Object)Key.get(Logger.class), (Object)Key.get(Object.class), (Object)new Key<C<Stage>>(this){}, (Object[])new Key[0]), bindings.keySet());
        injector.getInstance(F.class);
        Map bindings2 = injector.getAllBindings();
        Assert.assertEquals((Object)ImmutableSet.of((Object)Key.get(Injector.class), (Object)Key.get(Stage.class), (Object)Key.get(D.class), (Object)Key.get(Logger.class), (Object)Key.get(Object.class), (Object)new Key<C<Stage>>(this){}, (Object[])new Key[]{Key.get(F.class)}), bindings2.keySet());
        Assert.assertEquals((Object)ImmutableSet.of((Object)Key.get(Injector.class), (Object)Key.get(Stage.class), (Object)Key.get(D.class), (Object)Key.get(Logger.class), (Object)Key.get(Object.class), (Object)new Key<C<Stage>>(this){}, (Object[])new Key[0]), bindings.keySet());
        Assert.assertEquals((Object)injector, (Object)((Binding)bindings.get(Key.get(Injector.class))).getProvider().get());
    }

    @Test
    public void testGetAllServletBindings() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(F.class);
            }
        }});
        injector.getAllBindings();
    }

    @Test
    public void testTurkeyBaconProblemUsingToConstuctor() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            public void configure() {
                this.bind(Bacon.class).to(UncookedBacon.class);
                this.bind(Bacon.class).annotatedWith((Annotation)Names.named((String)"Turkey")).to(TurkeyBacon.class);
                this.bind(Bacon.class).annotatedWith((Annotation)Names.named((String)"Tofu")).to(TofuBacon.class);
                this.bind(Bacon.class).annotatedWith((Annotation)Names.named((String)"Cooked")).toConstructor((Constructor)InjectionPoint.forConstructorOf(Bacon.class).getMember());
            }
        }});
        Bacon bacon = (Bacon)injector.getInstance(Bacon.class);
        Assert.assertEquals((Object)((Object)Food.PORK), (Object)((Object)bacon.getMaterial()));
        Assert.assertFalse((boolean)bacon.isCooked());
        Bacon turkeyBacon = (Bacon)injector.getInstance(Key.get(Bacon.class, (Annotation)Names.named((String)"Turkey")));
        Assert.assertEquals((Object)((Object)Food.TURKEY), (Object)((Object)turkeyBacon.getMaterial()));
        Assert.assertTrue((boolean)turkeyBacon.isCooked());
        Bacon cookedBacon = (Bacon)injector.getInstance(Key.get(Bacon.class, (Annotation)Names.named((String)"Cooked")));
        Assert.assertEquals((Object)((Object)Food.PORK), (Object)((Object)cookedBacon.getMaterial()));
        Assert.assertTrue((boolean)cookedBacon.isCooked());
        try {
            injector.getInstance(Key.get(Bacon.class, (Annotation)Names.named((String)"Turky")));
            Assert.fail();
        }
        catch (ConfigurationException e) {
            String msg = e.getMessage();
            String[] stringArray = new String[6];
            stringArray[0] = "Guice configuration errors:";
            String string = Annotations.memberValueString((String)"value", (Object)"Turky");
            stringArray[1] = new StringBuilder(74 + String.valueOf(string).length()).append("No implementation for BindingTest$Bacon annotated with @Named(").append(string).append(") was bound.").toString();
            stringArray[2] = "Did you mean?";
            string = Annotations.memberValueString((String)"value", (Object)"Turkey");
            stringArray[3] = new StringBuilder(43 + String.valueOf(string).length()).append("* BindingTest$Bacon annotated with @Named(").append(string).append(")").toString();
            string = Annotations.memberValueString((String)"value", (Object)"Tofu");
            stringArray[4] = new StringBuilder(43 + String.valueOf(string).length()).append("* BindingTest$Bacon annotated with @Named(").append(string).append(")").toString();
            stringArray[5] = "1 more binding with other annotations.";
            Asserts.assertContains(msg, stringArray);
        }
    }

    @Test
    public void testMissingAnnotationOneChoice() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            public void configure() {
                this.bind(Bacon.class).annotatedWith((Annotation)Names.named((String)"Turkey")).to(TurkeyBacon.class);
            }
        }});
        try {
            injector.getInstance(Key.get(Bacon.class, (Annotation)Names.named((String)"turkey")));
            Assert.fail();
        }
        catch (ConfigurationException e) {
            String msg = e.getMessage();
            Asserts.assertContains(msg, "Guice configuration errors:");
            String[] stringArray = new String[3];
            String string = Annotations.memberValueString((String)"value", (Object)"turkey");
            stringArray[0] = new StringBuilder(74 + String.valueOf(string).length()).append("No implementation for BindingTest$Bacon annotated with @Named(").append(string).append(") was bound.").toString();
            stringArray[1] = "Did you mean?";
            string = Annotations.memberValueString((String)"value", (Object)"Turkey");
            stringArray[2] = new StringBuilder(43 + String.valueOf(string).length()).append("* BindingTest$Bacon annotated with @Named(").append(string).append(")").toString();
            Asserts.assertContains(msg, stringArray);
        }
    }

    @Test
    public void testMissingAnnotationRelated() {
        try {
            TypeLiteral<List<Butter>> list = new TypeLiteral<List<Butter>>(this){};
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this, (TypeLiteral)list){
                final /* synthetic */ TypeLiteral val$list;
                {
                    this.val$list = typeLiteral;
                }

                public void configure() {
                    this.bind(this.val$list).toInstance((Object)butters);
                    this.bind(Sandwitch.class).to(ButterSandwitch.class);
                }
            }});
            Assert.fail();
        }
        catch (CreationException e) {
            String msg = e.getMessage();
            Asserts.assertContains(msg, "Unable to create injector, see the following errors:", "Did you mean?", "List<BindingTest$Butter> bound at BindingTest$24.configure");
        }
    }

    private static class ButterSandwitch
    implements Sandwitch {
        private ButterSandwitch() {
        }

        @Inject
        ButterSandwitch(@Named(value="unsalted") Butter butter) {
        }
    }

    private static interface Butter {
    }

    private static interface Sandwitch {
    }

    private static class UncookedBacon
    extends Bacon {
        private UncookedBacon() {
        }

        @Override
        public boolean isCooked() {
            return false;
        }
    }

    private static class TofuBacon
    extends Bacon {
        private TofuBacon() {
        }

        @Override
        public Food getMaterial() {
            return Food.TOFU;
        }
    }

    private static class TurkeyBacon
    extends Bacon {
        private TurkeyBacon() {
        }

        @Override
        public Food getMaterial() {
            return Food.TURKEY;
        }
    }

    private static class Bacon {
        private Bacon() {
        }

        public Food getMaterial() {
            return Food.PORK;
        }

        public boolean isCooked() {
            return true;
        }
    }

    static enum Food {
        TURKEY,
        PORK,
        TOFU;

    }

    @Singleton
    public static class F {
        Stage stage;

        @Inject
        public F(Stage stage) {
            this.stage = stage;
        }
    }

    private static class E {
        Stage stage;

        private E(Stage stage) {
            this.stage = stage;
        }
    }

    public static class D {
        Stage stage;

        public D(Stage stage) {
            this.stage = stage;
        }
    }

    public static class C<T> {
        private Stage stage;
        private T t;
        @Inject
        T anotherT;

        public C(Stage stage, T t) {
            this.stage = stage;
            this.t = t;
        }

        @Inject
        C() {
        }
    }

    public static class CFoo
    implements IFoo {
    }

    public static interface IFoo {
    }

    static class TooManyConstructors {
        @Inject
        TooManyConstructors(Injector i) {
        }

        @Inject
        TooManyConstructors() {
        }
    }

    static class PrivateNoArg {
        private PrivateNoArg() {
        }
    }

    private static class PrivateNoArgInPrivateClass {
        PrivateNoArgInPrivateClass() {
        }
    }

    static class PackagePrivateNoArg {
        PackagePrivateNoArg() {
        }
    }

    static class ProtectedNoArg {
        protected ProtectedNoArg() {
        }
    }

    static class PublicNoArg {
    }

    static class PrivateNoArgAnnotated {
        @Inject
        private PrivateNoArgAnnotated() {
        }
    }

    static class PackagePrivateNoArgAnnotated {
        @Inject
        PackagePrivateNoArgAnnotated() {
        }
    }

    static class ProtectedNoArgAnnotated {
        @Inject
        protected ProtectedNoArgAnnotated() {
        }
    }

    static class PublicNoArgAnnotated {
        @Inject
        public PublicNoArgAnnotated() {
        }
    }

    static class Counter
    implements Provider<Integer> {
        static AtomicInteger next = new AtomicInteger(1);

        Counter() {
        }

        public Integer get() {
            return next.getAndIncrement();
        }
    }

    public static class Bar {
    }

    public static class FooProvider
    implements Provider<Foo> {
        public Foo get() {
            throw new UnsupportedOperationException();
        }
    }

    static class Foo {
        Foo() {
        }
    }

    static class MyModule
    extends AbstractModule {
        MyModule() {
        }

        protected void configure() {
            this.bind(Object.class).to(Runnable.class).in(Scopes.SINGLETON);
            this.bind(Runnable.class).toInstance((Object)Runnables.doNothing());
            this.bind(Foo.class).toProvider((Provider)new Provider<Foo>(this){

                public Foo get() {
                    return new Foo();
                }
            }).in(Scopes.SINGLETON);
            this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"provider")).toProvider(FooProvider.class);
            this.bind(Bar.class).in(Scopes.SINGLETON);
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"name")).to("Bob");
        }
    }

    static class Bob {
        Bob() {
        }
    }

    static class B {
        @Inject
        A a;

        B() {
        }
    }

    static class A {
        @Inject
        B b;

        A() {
        }
    }

    static class Dependent {
        @Inject
        A a;

        @Inject
        Dependent(A a, B b) {
        }

        @Inject
        void injectBob(Bob bob) {
        }
    }
}

