/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import junit.framework.TestCase;

public class BoundInstanceInjectionTest
extends TestCase {
    public void testInstancesAreInjected() throws CreationException {
        final O o = new O();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(O.class).toInstance((Object)o);
                this.bind(Integer.TYPE).toInstance((Object)5);
            }
        }});
        BoundInstanceInjectionTest.assertEquals((int)5, (int)o.fromMethod);
    }

    public void testProvidersAreInjected() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(O.class).toProvider((Provider)new Provider<O>(this){
                    @Inject
                    int i;

                    public O get() {
                        O o = new O();
                        o.setInt(this.i);
                        return o;
                    }
                });
                this.bind(Integer.TYPE).toInstance((Object)5);
            }
        }});
        BoundInstanceInjectionTest.assertEquals((int)5, (int)((O)injector.getInstance(O.class)).fromMethod);
    }

    public void testMalformedInstance() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(Object.class).toInstance((Object)new MalformedInjectable());
                }
            }});
            BoundInstanceInjectionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "BoundInstanceInjectionTest$MalformedInjectable.doublyAnnotated() has more than one ", "annotation annotated with @BindingAnnotation: ", "Named and BoundInstanceInjectionTest$Another");
        }
    }

    public void testMalformedProvider() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(String.class).toProvider((Provider)new MalformedProvider());
                }
            }});
            BoundInstanceInjectionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "BoundInstanceInjectionTest$MalformedProvider.doublyAnnotated() has more than one ", "annotation annotated with @BindingAnnotation: ", "Named and BoundInstanceInjectionTest$Another");
        }
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Another {
    }

    static class MalformedProvider
    implements Provider<String> {
        MalformedProvider() {
        }

        @Inject
        void doublyAnnotated(@Named(value="a") @Another String s) {
        }

        public String get() {
            return "a";
        }
    }

    static class MalformedInjectable {
        MalformedInjectable() {
        }

        @Inject
        void doublyAnnotated(@Named(value="a") @Another String unused) {
        }
    }

    static class O {
        int fromMethod;

        O() {
        }

        @Inject
        void setInt(int i) {
            this.fromMethod = i;
        }
    }
}

