/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class CircularDependencyTest
extends TestCase {
    protected void setUp() throws Exception {
        AImpl.nextId = 0;
        BImpl.nextId = 0;
    }

    public void testCircularlyDependentConstructors() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(A.class).to(AImpl.class);
                this.bind(B.class).to(BImpl.class);
            }
        }});
        this.assertCircularDependencies(injector);
    }

    public void testCircularlyDependentConstructorsWithProviderMethods() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            @Provides
            @Singleton
            A a(B b) {
                return new AImpl(b);
            }

            @Provides
            B b(A a) {
                return new BImpl(a);
            }
        }});
        this.assertCircularDependencies(injector);
    }

    public void testCircularlyDependentConstructorsWithProviderInstances() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(A.class).toProvider((Provider)new Provider<A>(this){
                    @Inject
                    Provider<B> bp;

                    public A get() {
                        return new AImpl((B)this.bp.get());
                    }
                }).in(Singleton.class);
                this.bind(B.class).toProvider((Provider)new Provider<B>(this){
                    @Inject
                    Provider<A> ap;

                    public B get() {
                        return new BImpl((A)this.ap.get());
                    }
                });
            }
        }});
        this.assertCircularDependencies(injector);
    }

    public void testCircularlyDependentConstructorsWithProviderKeys() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(A.class).toProvider(AP.class).in(Singleton.class);
                this.bind(B.class).toProvider(BP.class);
            }
        }});
        this.assertCircularDependencies(injector);
    }

    public void testCircularlyDependentConstructorsWithProvidedBy() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        this.assertCircularDependencies(injector);
    }

    private void assertCircularDependencies(Injector injector) {
        A a = (A)injector.getInstance(A.class);
        CircularDependencyTest.assertNotNull((Object)a.getB().getA());
        CircularDependencyTest.assertEquals((int)0, (int)a.id());
        CircularDependencyTest.assertEquals((int)a.id(), (int)a.getB().getA().id());
        CircularDependencyTest.assertEquals((int)0, (int)a.getB().id());
        CircularDependencyTest.assertEquals((int)1, (int)AImpl.nextId);
        CircularDependencyTest.assertEquals((int)1, (int)BImpl.nextId);
        CircularDependencyTest.assertSame((Object)a, (Object)injector.getInstance(A.class));
    }

    public void testUnresolvableCircularDependency() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(C.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Tried proxying CircularDependencyTest$C to support a circular dependency, ", "but it is not an interface.");
        }
    }

    public void testUnresolvableCircularDependenciesWithProviderInstances() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                @Provides
                C c(D d) {
                    return null;
                }

                @Provides
                D d(C c) {
                    return null;
                }
            }}).getInstance(C.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Tried proxying CircularDependencyTest$C to support a circular dependency, ", "but it is not an interface.");
        }
    }

    public void testUnresolvableCircularDependenciesWithProviderKeys() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(C2.class).toProvider(C2P.class);
                    this.bind(D2.class).toProvider(D2P.class);
                }
            }}).getInstance(C2.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Tried proxying CircularDependencyTest$C2 to support a circular dependency, ", "but it is not an interface.");
        }
    }

    public void testUnresolvableCircularDependenciesWithProvidedBy() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(C2.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Tried proxying CircularDependencyTest$C2 to support a circular dependency, ", "but it is not an interface.");
        }
    }

    public void testDisabledCircularDependency() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.binder().disableCircularProxies();
                }
            }}).getInstance(C.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Found a circular dependency involving CircularDependencyTest$C, and circular dependencies are disabled.");
        }
    }

    public void testDisabledCircularDependenciesWithProviderInstances() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.binder().disableCircularProxies();
                }

                @Provides
                C c(D d) {
                    return null;
                }

                @Provides
                D d(C c) {
                    return null;
                }
            }}).getInstance(C.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Found a circular dependency involving CircularDependencyTest$C, and circular dependencies are disabled.");
        }
    }

    public void testDisabledCircularDependenciesWithProviderKeys() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.binder().disableCircularProxies();
                    this.bind(C2.class).toProvider(C2P.class);
                    this.bind(D2.class).toProvider(D2P.class);
                }
            }}).getInstance(C2.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Found a circular dependency involving CircularDependencyTest$C2, and circular dependencies are disabled.");
        }
    }

    public void testDisabledCircularDependenciesWithProvidedBy() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.binder().disableCircularProxies();
                }
            }}).getInstance(C2.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Found a circular dependency involving CircularDependencyTest$C2, and circular dependencies are disabled.");
        }
    }

    public void testCircularlyDependentMultipleWays() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.binder.bind(A.class).to(E.class);
                this.binder.bind(B.class).to(E.class);
            }
        }});
        injector.getInstance(A.class);
    }

    public void testDisablingCircularDependencies() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.binder().disableCircularProxies();
                this.binder.bind(A.class).to(E.class);
                this.binder.bind(B.class).to(E.class);
            }
        }});
        try {
            injector.getInstance(A.class);
            CircularDependencyTest.fail((String)"expected exception");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Found a circular dependency involving CircularDependencyTest$A, and circular dependencies are disabled.");
        }
    }

    public void testCircularDependencyProxyDelegateNeverInitialized() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(F.class).to(RealF.class);
                this.bind(G.class).to(RealG.class);
            }
        }});
        F f = (F)injector.getInstance(F.class);
        CircularDependencyTest.assertEquals((String)"F", (String)f.g().f().toString());
        CircularDependencyTest.assertEquals((String)"G", (String)f.g().f().g().toString());
    }

    public void testCircularDependenciesDetectedEarlyWhenDependenciesHaveDifferentTypes() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Number.class).to(Integer.class);
            }

            @Provides
            @Singleton
            Integer provideInteger(List<Object> list) {
                return 2;
            }

            @Provides
            List<Object> provideList(Integer integer) {
                return new ArrayList<Object>();
            }
        }});
        try {
            injector.getInstance(Number.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Tried proxying Integer to support a circular dependency, ", "but it is not an interface.");
        }
    }

    public void testPrivateModulesDontTriggerCircularErrorsInProviders() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.install((Module)new PrivateModule(this){

                    protected void configure() {
                        this.bind(Foo.class);
                        this.expose(Foo.class);
                    }

                    @Provides
                    String provideString(Bar bar) {
                        String string = String.valueOf(bar.string);
                        return new String(string.length() != 0 ? "private 1, ".concat(string) : new String("private 1, "));
                    }
                });
                this.install((Module)new PrivateModule(this){

                    protected void configure() {
                        this.bind(Bar.class);
                        this.expose(Bar.class);
                    }

                    @Provides
                    String provideString() {
                        return new String("private 2");
                    }
                });
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        CircularDependencyTest.assertEquals((String)"private 1, private 2", (String)foo.string);
    }

    public void testCustomScopeCircularProxies() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindScope(SimpleSingleton.class, new BasicSingleton());
                this.bind(H.class).to(HImpl.class);
                this.bind(I.class).to(IImpl.class);
                this.bind(J.class).to(JImpl.class);
            }
        }});
        try {
            injector.getInstance(IImpl.class);
            CircularDependencyTest.fail();
        }
        catch (ProvisionException pe) {
            Asserts.assertContains(pe.getMessage(), "Tried proxying CircularDependencyTest$IImpl to support a circular dependency, but it is not an interface.", "1 error");
        }
    }

    public void testDisabledNonConstructorCircularDependencies() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.binder().disableCircularProxies();
            }
        }});
        try {
            injector.getInstance(K.class);
            CircularDependencyTest.fail((String)"expected exception");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Found a circular dependency involving CircularDependencyTest$K, and circular dependencies are disabled.");
        }
        try {
            injector.getInstance(L.class);
            CircularDependencyTest.fail((String)"expected exception");
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Found a circular dependency involving CircularDependencyTest$L, and circular dependencies are disabled.");
        }
    }

    static class L {
        L() {
        }

        @Inject
        void inject(K k) {
        }
    }

    static class K {
        @Inject
        L l;

        K() {
        }
    }

    public static class BasicSingleton
    implements Scope {
        private static Map<Key<?>, Object> cache = Maps.newHashMap();

        public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
            return new Provider<T>(this){

                public T get() {
                    if (!cache.containsKey(key)) {
                        Object t = unscoped.get();
                        if (Scopes.isCircularProxy((Object)t)) {
                            return t;
                        }
                        cache.put(key, t);
                    }
                    return cache.get(key);
                }
            };
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ScopeAnnotation
    public static @interface SimpleSingleton {
    }

    @SimpleSingleton
    static class JImpl
    implements J {
        @Inject
        JImpl(IImpl i) {
        }
    }

    @SimpleSingleton
    static class IImpl
    implements I {
        @Inject
        IImpl(HImpl i, J j) {
        }
    }

    @SimpleSingleton
    static class HImpl
    implements H {
        @Inject
        HImpl(I i) {
        }
    }

    static interface J {
    }

    static interface I {
    }

    static interface H {
    }

    static class Bar {
        @Inject
        String string;

        Bar() {
        }
    }

    static class Foo {
        @Inject
        String string;

        Foo() {
        }
    }

    @Singleton
    public static class RealG
    implements G {
        private final F f;

        @Inject
        RealG(F f) {
            this.f = f;
        }

        @Override
        public F f() {
            return this.f;
        }

        public String toString() {
            return "G";
        }
    }

    public static interface G {
        public F f();
    }

    @Singleton
    public static class RealF
    implements F {
        private final G g;

        @Inject
        RealF(G g) {
            this.g = g;
        }

        @Override
        public G g() {
            return this.g;
        }

        public String toString() {
            return "F";
        }
    }

    public static interface F {
        public G g();
    }

    @Singleton
    static class E
    implements A,
    B {
        @Inject
        public E(A a, B b) {
        }

        @Override
        public B getB() {
            return this;
        }

        @Override
        public A getA() {
            return this;
        }

        @Override
        public int id() {
            return 0;
        }
    }

    @ProvidedBy(value=D2P.class)
    static class D2 {
        @Inject
        D2(C2 c) {
        }
    }

    @ProvidedBy(value=C2P.class)
    static class C2 {
        @Inject
        C2(D2 d) {
        }
    }

    static class D2P
    implements Provider<D2> {
        @Inject
        Provider<C2> cp;

        D2P() {
        }

        public D2 get() {
            this.cp.get();
            return null;
        }
    }

    static class C2P
    implements Provider<C2> {
        @Inject
        Provider<D2> dp;

        C2P() {
        }

        public C2 get() {
            this.dp.get();
            return null;
        }
    }

    static class D {
        @Inject
        D(C c) {
        }
    }

    static class C {
        @Inject
        C(D d) {
        }
    }

    static class BP
    implements Provider<B> {
        Provider<A> ap;

        @Inject
        BP(Provider<A> ap) {
            this.ap = ap;
        }

        public B get() {
            return new BImpl((A)this.ap.get());
        }
    }

    static class BImpl
    implements B {
        static int nextId;
        int id = nextId++;
        final A a;

        @Inject
        public BImpl(A a) {
            this.a = a;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public A getA() {
            return this.a;
        }
    }

    @ProvidedBy(value=BP.class)
    public static interface B {
        public A getA();

        public int id();
    }

    @Singleton
    static class AutoAP
    implements Provider<A> {
        @Inject
        Provider<B> bp;
        A a;

        AutoAP() {
        }

        public A get() {
            if (this.a == null) {
                this.a = new AImpl((B)this.bp.get());
            }
            return this.a;
        }
    }

    static class AP
    implements Provider<A> {
        @Inject
        Provider<B> bp;

        AP() {
        }

        public A get() {
            return new AImpl((B)this.bp.get());
        }
    }

    @Singleton
    static class AImpl
    implements A {
        static int nextId;
        int id = nextId++;
        final B b;

        @Inject
        public AImpl(B b) {
            this.b = b;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public B getB() {
            return this.b;
        }
    }

    @ProvidedBy(value=AutoAP.class)
    public static interface A {
        public B getB();

        public int id();
    }
}

