/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;

public class EagerSingletonTest
extends TestCase {
    public void setUp() {
        A.instanceCount = 0;
        B.instanceCount = 0;
        C.instanceCount = 0;
    }

    public void testJustInTimeEagerSingletons() {
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.getProvider(A.class);
                this.requestInjection(new Object(this){

                    @Inject
                    void inject(Injector injector) {
                        injector.getInstance(C.class);
                    }
                });
            }
        }});
        EagerSingletonTest.assertEquals((int)1, (int)A.instanceCount);
        EagerSingletonTest.assertEquals((String)"Singletons discovered when creating singletons should not be built eagerly", (int)0, (int)B.instanceCount);
        EagerSingletonTest.assertEquals((int)1, (int)C.instanceCount);
    }

    public void testJustInTimeSingletonsAreNotEager() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[0]);
        injector.getProvider(B.class);
        EagerSingletonTest.assertEquals((int)0, (int)B.instanceCount);
    }

    public void testChildEagerSingletons() {
        Injector parent = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[0]);
        parent.createChildInjector(new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(D.class).to(C.class);
            }
        }});
        EagerSingletonTest.assertEquals((int)1, (int)C.instanceCount);
    }

    public void testJustInTimeEagerSingletons_multipleThreads() throws Exception {
        final ArrayList jitBindings = new ArrayList();
        for (int i = 0; i < 1000; ++i) {
            jitBindings.add(EagerSingletonTest.copyClass(B.class));
        }
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.getProvider(A.class);
                this.requestInjection(new Object(){

                    @Inject
                    void inject(final Injector injector) throws Exception {
                        final CountDownLatch latch = new CountDownLatch(1);
                        new Thread(){

                            @Override
                            public void run() {
                                latch.countDown();
                                for (Class jitBinding : jitBindings) {
                                    injector.getProvider(jitBinding);
                                }
                            }
                        }.start();
                        latch.await();
                    }
                });
            }
        }});
        EagerSingletonTest.assertEquals((int)1, (int)A.instanceCount);
        int prev = -1;
        int index = 0;
        for (Class clazz : jitBindings) {
            int instanceCount = (Integer)clazz.getDeclaredField("instanceCount").get(null);
            if (instanceCount != 0 && instanceCount != 1) {
                EagerSingletonTest.fail((String)new StringBuilder(63).append("Should only have created zero or one instances, got ").append(instanceCount).toString());
            }
            if (prev == -1) {
                prev = instanceCount;
            } else if (prev != instanceCount) {
                if (prev != 1 && instanceCount != 0) {
                    int n = index;
                    EagerSingletonTest.fail((String)new StringBuilder(71).append("initialized later JIT bindings before earlier ones at index ").append(n).toString());
                }
                prev = instanceCount;
            }
            ++index;
        }
    }

    private static Class<?> copyClass(final Class<?> cls) {
        try {
            return new URLClassLoader(Asserts.getClassPathUrls(), EagerSingletonTest.class.getClassLoader()){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    if (name.equals(cls.getName())) {
                        Class<?> c = this.findLoadedClass(name);
                        if (c == null) {
                            return super.findClass(name);
                        }
                        return c;
                    }
                    return super.loadClass(name);
                }
            }.loadClass(cls.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
    }

    private static interface D {
    }

    @Singleton
    static class C
    implements D {
        static int instanceCount = 0;
        int instanceId = instanceCount++;

        C() {
        }
    }

    @Singleton
    public static class B {
        public static int instanceCount = 0;
        int instanceId = instanceCount++;
    }

    @Singleton
    static class A {
        static int instanceCount = 0;
        int instanceId = instanceCount++;

        @Inject
        A(Injector injector) {
            injector.getProvider(B.class);
        }
    }
}

