/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class LoggerInjectionTest
extends TestCase {
    @Inject
    Logger logger;

    public void testLoggerWithMember() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        injector.injectMembers((Object)this);
        LoggerInjectionTest.assertEquals((String)"com.google.inject.LoggerInjectionTest", (String)this.logger.getName());
    }

    public void testLoggerInConstructor() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        Foo foo = (Foo)injector.getInstance(Foo.class);
        LoggerInjectionTest.assertEquals((String)"com.google.inject.LoggerInjectionTest$Foo", (String)foo.logger.getName());
    }

    public void testLoggerWithoutMember() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        LoggerInjectionTest.assertNull((Object)((Logger)injector.getInstance(Logger.class)).getName());
        LoggerInjectionTest.assertNull((Object)((Logger)injector.getProvider(Logger.class).get()).getName());
        LoggerInjectionTest.assertNull((Object)((Logger)injector.getBinding(Logger.class).getProvider().get()).getName());
        LoggerInjectionTest.assertEquals((String)"Provider<Logger>", (String)injector.getProvider(Logger.class).toString());
    }

    public void testCanBindAnnotatedLogger() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)"anonymous")).toInstance((Object)Logger.getAnonymousLogger());
            }
        }});
        LoggerInjectionTest.assertNull((Object)((Logger)injector.getInstance(Key.get(Logger.class, (Annotation)Names.named((String)"anonymous")))).getName());
    }

    public void testCannotBindLogger() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(Logger.class).toInstance((Object)Logger.getAnonymousLogger());
                }
            }});
            LoggerInjectionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Logger was bound multiple times.");
        }
    }

    private static class Foo {
        Logger logger;

        @Inject
        Foo(Logger logger) {
            this.logger = logger;
        }
    }
}

