/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.Message;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MethodInterceptionTest {
    private AtomicInteger count = new AtomicInteger();

    @Before
    public void checkBytecodeGenIsEnabled() {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
    }

    @Test
    public void testSharedProxyClasses() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{new ReturnNullInterceptor()});
            }
        }});
        Injector childOne = injector.createChildInjector(new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Interceptable.class);
            }
        }});
        Interceptable nullFoosOne = (Interceptable)childOne.getInstance(Interceptable.class);
        Assert.assertNotNull((Object)nullFoosOne.bar());
        Assert.assertNull((Object)nullFoosOne.foo());
        Injector childTwo = injector.createChildInjector(new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Interceptable.class);
            }
        }});
        Interceptable nullFoosTwo = (Interceptable)childTwo.getInstance(Interceptable.class);
        Assert.assertNull((Object)nullFoosTwo.foo());
        Assert.assertSame((String)"Child injectors should share proxy classes, otherwise memory leaks!", nullFoosOne.getClass(), nullFoosTwo.getClass());
        Injector injector2 = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{new ReturnNullInterceptor()});
            }
        }});
        Interceptable separateNullFoos = (Interceptable)injector2.getInstance(Interceptable.class);
        Assert.assertNull((Object)separateNullFoos.foo());
        Assert.assertSame((String)"different injectors should share proxy classes, otherwise memory leaks!", nullFoosOne.getClass(), separateNullFoos.getClass());
    }

    @Test
    public void testGetThis() {
        final AtomicReference lastTarget = new AtomicReference();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(){

                    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                        lastTarget.set(methodInvocation.getThis());
                        return methodInvocation.proceed();
                    }
                }});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        interceptable.foo();
        Assert.assertSame((Object)interceptable, lastTarget.get());
    }

    @Test
    public void testInterceptingFinalClass() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(this){

                    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                        return methodInvocation.proceed();
                    }
                }});
            }
        }});
        try {
            injector.getInstance(NotInterceptable.class);
            Assert.fail();
        }
        catch (ConfigurationException ce) {
            String string = String.valueOf(NotInterceptable.class.getName());
            Assert.assertEquals((Object)(string.length() != 0 ? "Unable to method intercept: ".concat(string) : new String("Unable to method intercept: ")), (Object)((Message)Iterables.getOnlyElement((Iterable)ce.getErrorMessages())).getMessage().toString());
            String string2 = String.valueOf(NotInterceptable.class.getName());
            Assert.assertEquals((Object)(string2.length() != 0 ? "Cannot subclass final class ".concat(string2) : new String("Cannot subclass final class ")), (Object)ce.getCause().getMessage());
        }
    }

    @Test
    public void testSpiAccessToInterceptors() throws NoSuchMethodException {
        final CountingInterceptor countingInterceptor = new CountingInterceptor();
        final ReturnNullInterceptor returnNullInterceptor = new ReturnNullInterceptor();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{countingInterceptor});
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class).or(Matchers.only(Bar.class))), new MethodInterceptor[]{returnNullInterceptor});
            }
        }});
        ConstructorBinding interceptedBinding = (ConstructorBinding)injector.getBinding(Interceptable.class);
        Method barMethod = Interceptable.class.getMethod("bar", new Class[0]);
        Method fooMethod = Interceptable.class.getMethod("foo", new Class[0]);
        Assert.assertEquals((Object)ImmutableMap.of((Object)fooMethod, (Object)ImmutableList.of((Object)countingInterceptor, (Object)returnNullInterceptor), (Object)barMethod, (Object)ImmutableList.of((Object)returnNullInterceptor)), (Object)interceptedBinding.getMethodInterceptors());
        ConstructorBinding nonInterceptedBinding = (ConstructorBinding)injector.getBinding(Foo.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)nonInterceptedBinding.getMethodInterceptors());
        ((Interceptable)injector.getInstance(Interceptable.class)).foo();
        Assert.assertEquals((String)"expected counting interceptor to be invoked first", (long)1L, (long)this.count.get());
    }

    @Test
    public void testInterceptedMethodThrows() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new CountingInterceptor()});
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new CountingInterceptor()});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        try {
            interceptable.explode();
            Assert.fail();
        }
        catch (Exception e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                StackTraceElement[] stackTraceElement = t.getStackTrace();
                Assert.assertEquals((Object)"explode", (Object)stackTraceElement[0].getMethodName());
                Assert.assertEquals((Object)"invoke", (Object)stackTraceElement[1].getMethodName());
                Assert.assertEquals((Object)"invoke", (Object)stackTraceElement[2].getMethodName());
                Assert.assertEquals((Object)"testInterceptedMethodThrows", (Object)stackTraceElement[3].getMethodName());
            }
        }
    }

    @Test
    public void testNotInterceptedMethodsInInterceptedClassDontAddFrames() {
        int i;
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.only(Foo.class)), new MethodInterceptor[]{new NoOpInterceptor()});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        Assert.assertNull((Object)interceptable.lastElements);
        interceptable.foo();
        boolean proxyFrameFound = false;
        for (i = 0; i < interceptable.lastElements.length; ++i) {
            if (!interceptable.lastElements[i].toString().contains("$EnhancerByGuice$")) continue;
            proxyFrameFound = true;
            break;
        }
        Assert.assertTrue((String)Arrays.toString(interceptable.lastElements), (boolean)proxyFrameFound);
        proxyFrameFound = false;
        interceptable.bar();
        for (i = 0; i < interceptable.lastElements.length; ++i) {
            if (!interceptable.lastElements[i].toString().contains("$EnhancerByGuice$")) continue;
            proxyFrameFound = true;
            break;
        }
        Assert.assertFalse((String)Arrays.toString(interceptable.lastElements), (boolean)proxyFrameFound);
    }

    @Test
    public void testInterceptingNonBridgeWorks() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Interface.class).to(Impl.class);
                this.bindInterceptor(Matchers.any(), (Matcher)new AbstractMatcher<Method>(this){

                    public boolean matches(Method t) {
                        return !t.isBridge() && t.getDeclaringClass() != Object.class;
                    }
                }, new MethodInterceptor[]{new CountingInterceptor()});
            }
        }});
        Interface intf = (Interface)injector.getInstance(Interface.class);
        Assert.assertEquals((long)0L, (long)this.count.get());
        intf.aMethod(null);
        Assert.assertEquals((long)1L, (long)this.count.get());
    }

    @Test
    public void testInterceptionOrder() {
        final ArrayList callList = Lists.newArrayList();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new NamedInterceptor("a", callList), new NamedInterceptor("b", callList), new NamedInterceptor("c", callList)});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        Assert.assertEquals((long)0L, (long)callList.size());
        interceptable.foo();
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)callList);
    }

    @Test
    public void testDeDuplicateInterceptors() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                CountingInterceptor interceptor = new CountingInterceptor();
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor});
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        interceptable.foo();
        Assert.assertEquals((long)1L, (long)this.count.get());
    }

    @Test
    public void testCallLater() {
        final LinkedList queue = Lists.newLinkedList();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new CallLaterInterceptor(queue)});
            }
        }});
        Interceptable interceptable = (Interceptable)injector.getInstance(Interceptable.class);
        interceptable.foo();
        Assert.assertNull((Object)interceptable.lastElements);
        Assert.assertEquals((long)1L, (long)queue.size());
        ((Runnable)queue.remove()).run();
        Assert.assertNotNull((Object)interceptable.lastElements);
    }

    @Test
    public void testDefaultMethodInterception() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Grounded.class), new MethodInterceptor[]{new CountingInterceptor()});
            }
        }});
        Assert.assertEquals((long)0L, (long)this.count.get());
        Assert.assertEquals((Object)"I am a horse.", (Object)((Unicorn)injector.getInstance(Unicorn.class)).identifyMyself());
        Assert.assertEquals((long)1L, (long)this.count.get());
        this.count.set(0);
        Assert.assertEquals((long)0L, (long)this.count.get());
        Assert.assertEquals((Object)"I am a flying horse.", (Object)((Pegasus)injector.getInstance(Pegasus.class)).identifyMyself());
        Assert.assertEquals((long)0L, (long)this.count.get());
    }

    @Test
    public void testSetterInterception() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"text")).to("Hello, world");
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Inject.class), new MethodInterceptor[]{mi -> {
                    String string = String.valueOf(mi.getArguments()[0]);
                    mi.getArguments()[0] = new StringBuilder(4 + String.valueOf(string).length()).append(">>").append(string).append("<<").toString();
                    return mi.proceed();
                }});
            }
        }});
        Setter setter = (Setter)injector.getInstance(Setter.class);
        Assert.assertEquals((Object)">>Hello, world<<", (Object)setter.text);
    }

    public static class Setter
    extends BaseSetter {
    }

    static class BaseSetter {
        String text;

        BaseSetter() {
        }

        @Inject
        protected void setText(@Named(value="text") String text) {
            this.text = text;
        }
    }

    public static class Pegasus
    extends HorseImpl
    implements MythicalAnimal,
    FlyingHorse {
    }

    public static class Unicorn
    extends HorseImpl
    implements MythicalAnimal {
    }

    static class HorseImpl
    implements Horse {
        HorseImpl() {
        }
    }

    static interface FlyingHorse
    extends Horse,
    MythicalAnimal {
        @Override
        default public String identifyMyself() {
            return "I am a flying horse.";
        }
    }

    static interface MythicalAnimal
    extends Animal {
    }

    static interface Horse
    extends Animal {
        @Override
        @Grounded
        default public String identifyMyself() {
            return "I am a horse.";
        }
    }

    static interface Animal {
        default public String identifyMyself() {
            return "I am an animal.";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Grounded {
    }

    private static final class CallLaterInterceptor
    implements MethodInterceptor {
        private final Queue<Runnable> queue;

        public CallLaterInterceptor(Queue<Runnable> queue) {
            this.queue = queue;
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            this.queue.add(() -> {
                try {
                    methodInvocation.proceed();
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            });
            return null;
        }
    }

    private static final class NamedInterceptor
    implements MethodInterceptor {
        private final String name;
        final List<String> called;

        NamedInterceptor(String name, List<String> callList) {
            this.name = name;
            this.called = callList;
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            this.called.add(this.name);
            return methodInvocation.proceed();
        }
    }

    public static class Impl
    extends Superclass<RetType>
    implements Interface {
    }

    public static interface Interface {
        public RetType aMethod(RetType var1);
    }

    static abstract class Superclass<T extends ErasedType> {
        Superclass() {
        }

        public T aMethod(T t) {
            return null;
        }
    }

    static class RetType
    extends ErasedType {
        RetType() {
        }
    }

    static class ErasedType {
        ErasedType() {
        }
    }

    public static final class NotInterceptable {
    }

    public static class Interceptable {
        StackTraceElement[] lastElements;

        public Foo foo() {
            this.lastElements = Thread.currentThread().getStackTrace();
            return new Foo(this){};
        }

        public Bar bar() {
            this.lastElements = Thread.currentThread().getStackTrace();
            return new Bar(this){};
        }

        public String explode() throws Exception {
            this.lastElements = Thread.currentThread().getStackTrace();
            throw new Exception("kaboom!", new RuntimeException("boom!"));
        }
    }

    static class Bar {
        Bar() {
        }
    }

    public static class Foo {
    }

    private static final class NoOpInterceptor
    implements MethodInterceptor {
        private NoOpInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            return methodInvocation.proceed();
        }
    }

    private static final class ReturnNullInterceptor
    implements MethodInterceptor {
        private ReturnNullInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            return null;
        }
    }

    private final class CountingInterceptor
    implements MethodInterceptor {
        private CountingInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            MethodInterceptionTest.this.count.incrementAndGet();
            return methodInvocation.proceed();
        }
    }
}

