/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.DecimalFormat;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class PerformanceComparison {
    static final Callable<Foo> springFactory = new Callable<Foo>(){
        final DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        {
            RootBeanDefinition tee = new RootBeanDefinition(TeeImpl.class, true);
            tee.setLazyInit(true);
            ConstructorArgumentValues teeValues = new ConstructorArgumentValues();
            teeValues.addGenericArgumentValue((Object)"test");
            tee.setConstructorArgumentValues(teeValues);
            RootBeanDefinition bar = new RootBeanDefinition(BarImpl.class, false);
            ConstructorArgumentValues barValues = new ConstructorArgumentValues();
            barValues.addGenericArgumentValue((Object)new RuntimeBeanReference("tee"));
            barValues.addGenericArgumentValue((Object)5);
            bar.setConstructorArgumentValues(barValues);
            RootBeanDefinition foo = new RootBeanDefinition(Foo.class, false);
            MutablePropertyValues fooValues = new MutablePropertyValues();
            fooValues.addPropertyValue("i", (Object)5);
            fooValues.addPropertyValue("bar", (Object)new RuntimeBeanReference("bar"));
            fooValues.addPropertyValue("copy", (Object)new RuntimeBeanReference("bar"));
            fooValues.addPropertyValue("s", (Object)"test");
            foo.setPropertyValues(fooValues);
            this.beanFactory.registerBeanDefinition("foo", (BeanDefinition)foo);
            this.beanFactory.registerBeanDefinition("bar", (BeanDefinition)bar);
            this.beanFactory.registerBeanDefinition("tee", (BeanDefinition)tee);
        }

        @Override
        public Foo call() throws Exception {
            return (Foo)this.beanFactory.getBean("foo");
        }
    };
    static final Callable<Foo> juiceFactory = new Callable<Foo>(){
        final Provider<Foo> fooProvider;
        {
            Injector injector;
            try {
                injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                    protected void configure() {
                        this.bind(Tee.class).to(TeeImpl.class);
                        this.bind(Bar.class).to(BarImpl.class);
                        this.bind(Foo.class);
                        this.bindConstant().annotatedWith(I.class).to(5);
                        this.bindConstant().annotatedWith(S.class).to("test");
                    }
                }});
            }
            catch (CreationException e) {
                throw new RuntimeException(e);
            }
            this.fooProvider = injector.getProvider(Foo.class);
        }

        @Override
        public Foo call() throws Exception {
            return (Foo)this.fooProvider.get();
        }
    };
    static final Callable<Foo> byHandFactory = new Callable<Foo>(){
        final Tee tee = new TeeImpl("test");

        @Override
        public Foo call() throws Exception {
            Foo foo = new Foo();
            foo.setI(5);
            foo.setS("test");
            BarImpl bar = new BarImpl(this.tee, 5);
            BarImpl copy = new BarImpl(this.tee, 5);
            foo.setBar(bar);
            foo.setCopy(copy);
            return foo;
        }
    };
    static final DecimalFormat format = new DecimalFormat();

    public static void main(String[] args) throws Exception {
        int i2;
        PerformanceComparison.validate(springFactory);
        PerformanceComparison.validate(juiceFactory);
        PerformanceComparison.validate(byHandFactory);
        for (i2 = 0; i2 < 10; ++i2) {
            PerformanceComparison.iterate(springFactory, "Spring:  ");
            PerformanceComparison.iterate(juiceFactory, "Guice:   ");
            PerformanceComparison.iterate(byHandFactory, "By Hand: ");
            System.err.println();
        }
        System.err.println("Concurrent:");
        for (i2 = 0; i2 < 10; ++i2) {
            PerformanceComparison.concurrentlyIterate(springFactory, "Spring:  ");
            PerformanceComparison.concurrentlyIterate(juiceFactory, "Guice:   ");
            PerformanceComparison.concurrentlyIterate(byHandFactory, "By Hand: ");
            System.err.println();
        }
    }

    static void validate(Callable<Foo> t) throws Exception {
        Foo foo = t.call();
        Assert.assertEquals((int)5, (int)foo.i);
        Assert.assertEquals((String)"test", (String)foo.s);
        Assert.assertSame((Object)foo.bar.getTee(), (Object)foo.copy.getTee());
        Assert.assertEquals((int)5, (int)foo.bar.getI());
        Assert.assertEquals((String)"test", (String)foo.bar.getTee().getS());
    }

    static void iterate(Callable<Foo> callable, String label) {
        int count = 100000;
        long time = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            try {
                callable.call();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        time = System.currentTimeMillis() - time;
        String string = format.format((long)(count * 1000) / time);
        System.err.println(new StringBuilder(12 + String.valueOf(label).length() + String.valueOf(string).length()).append(label).append(string).append(" creations/s").toString());
    }

    static void concurrentlyIterate(final Callable<Foo> callable, String label) {
        int i;
        int threadCount = 10;
        int count = 10000;
        Thread[] threads = new Thread[threadCount];
        for (int i2 = 0; i2 < threadCount; ++i2) {
            threads[i2] = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 10000; ++i) {
                        try {
                            PerformanceComparison.validate(callable);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            };
        }
        long time = System.currentTimeMillis();
        for (i = 0; i < threadCount; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        time = System.currentTimeMillis() - time;
        String string = format.format(10000000L / time);
        System.err.println(new StringBuilder(12 + String.valueOf(label).length() + String.valueOf(string).length()).append(label).append(string).append(" creations/s").toString());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface S {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface I {
    }

    @Singleton
    public static class TeeImpl
    implements Tee {
        final String s;

        @Inject
        public TeeImpl(@S String s) {
            this.s = s;
        }

        @Override
        public String getS() {
            return this.s;
        }
    }

    static interface Tee {
        public String getS();
    }

    public static class BarImpl
    implements Bar {
        final int i;
        final Tee tee;

        @Inject
        public BarImpl(Tee tee, @I int i) {
            this.tee = tee;
            this.i = i;
        }

        @Override
        public Tee getTee() {
            return this.tee;
        }

        @Override
        public int getI() {
            return this.i;
        }
    }

    static interface Bar {
        public Tee getTee();

        public int getI();
    }

    public static class Foo {
        Bar bar;
        Bar copy;
        String s;
        int i;

        @Inject
        public void setI(@I int i) {
            this.i = i;
        }

        @Inject
        public void setBar(Bar bar) {
            this.bar = bar;
        }

        @Inject
        public void setCopy(Bar copy) {
            this.copy = copy;
        }

        @Inject
        public void setS(@S String s) {
            this.s = s;
        }
    }
}

