/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import junit.framework.TestCase;

public class ProvisionExceptionTest
extends TestCase {
    public void testExceptionsCollapsed() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(A.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException e) {
            ProvisionExceptionTest.assertTrue((boolean)(e.getCause() instanceof UnsupportedOperationException));
            Asserts.assertContains(e.getMessage(), "UnsupportedOperationException", "at ProvisionExceptionTest$C.setD", "for 1st parameter d", "at ProvisionExceptionTest$B.c", "for field c", "at ProvisionExceptionTest$A.<init>", "for 1st parameter b");
        }
    }

    public void testExceptionsCollapsedWithScopes() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(B.class).in(Scopes.SINGLETON);
                }
            }}).getInstance(A.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException e) {
            ProvisionExceptionTest.assertTrue((boolean)(e.getCause() instanceof UnsupportedOperationException));
            ProvisionExceptionTest.assertFalse((boolean)e.getMessage().contains("custom provider"));
            Asserts.assertContains(e.getMessage(), "UnsupportedOperationException", "at ProvisionExceptionTest$C.setD", "for 1st parameter d", "at ProvisionExceptionTest$B.c", "for field c", "at ProvisionExceptionTest$A.<init>", "for 1st parameter b");
        }
    }

    public void testMethodInjectionExceptions() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(E.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException e) {
            ProvisionExceptionTest.assertTrue((boolean)(e.getCause() instanceof UnsupportedOperationException));
            Asserts.assertContains(e.getMessage(), "[Guice/ErrorInjectingMethod]: UnsupportedOperationException", "at ProvisionExceptionTest$E.setObject");
        }
    }

    public void testBindToProviderInstanceExceptions() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(D.class).toProvider((Provider)new DProvider());
                }
            }}).getInstance(D.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException e) {
            ProvisionExceptionTest.assertTrue((boolean)(e.getCause() instanceof UnsupportedOperationException));
            Asserts.assertContains(e.getMessage(), "1) [Guice/ErrorInCustomProvider]: UnsupportedOperationException", "at ProvisionExceptionTest$2.configure");
        }
    }

    public void testProvisionExceptionsAreWrappedForBindToType() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(F.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) User Exception", "at ProvisionExceptionTest$F.<init>");
        }
    }

    public void testProvisionExceptionsAreWrappedForBindToProviderType() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(F.class).toProvider(FProvider.class);
                }
            }}).getInstance(F.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) User Exception", "while locating ProvisionExceptionTest$FProvider", "while locating ProvisionExceptionTest$F");
        }
    }

    public void testProvisionExceptionsAreWrappedForBindToProviderInstance() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(F.class).toProvider((Provider)new FProvider());
                }
            }}).getInstance(F.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "1) User Exception", "at ProvisionExceptionTest$4.configure");
        }
    }

    public void testProvisionExceptionIsSerializable() throws IOException {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(A.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException expected) {
            ProvisionException reserialized = Asserts.reserialize(expected);
            Asserts.assertContains(reserialized.getMessage(), "1) [Guice/ErrorInjectingConstructor]: UnsupportedOperationException", "at ProvisionExceptionTest$RealD.<init>()", "at Key[type=ProvisionExceptionTest$RealD, annotation=[none]]", "@ProvisionExceptionTest$C.setD()[0]", "at Key[type=ProvisionExceptionTest$C, annotation=[none]]", "@ProvisionExceptionTest$B.c", "at Key[type=ProvisionExceptionTest$B, annotation=[none]]", "@ProvisionExceptionTest$A.<init>()[0]", "at Key[type=ProvisionExceptionTest$A, annotation=[none]]");
        }
    }

    public void testMultipleCauses() {
        try {
            Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new AbstractModule(this){

                @Provides
                @Singleton
                String injectFirst() {
                    throw new IllegalArgumentException(new UnsupportedOperationException("Unsupported"));
                }

                @Provides
                @Singleton
                Object injectSecond() {
                    throw new NullPointerException("can't inject second either");
                }
            }});
            ProvisionExceptionTest.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "IllegalArgumentException", "Caused by: IllegalArgumentException: UnsupportedOperationException", "Caused by: UnsupportedOperationException: Unsupported", "NullPointerException: can't inject second either", "Caused by: NullPointerException: can't inject second either", "2 errors");
        }
    }

    public void testInjectInnerClass() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            injector.getInstance(InnerClass.class);
            ProvisionExceptionTest.fail();
        }
        catch (Exception expected) {
            Asserts.assertContains(expected.getMessage(), "Injecting into inner classes is not supported.", "while locating ProvisionExceptionTest$InnerClass");
        }
    }

    public void testInjectLocalClass() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            class LocalClass {
                LocalClass(ProvisionExceptionTest this$0) {
                }
            }
            injector.getInstance(LocalClass.class);
            ProvisionExceptionTest.fail();
        }
        catch (Exception expected) {
            Asserts.assertContains(expected.getMessage(), "Injecting into inner classes is not supported.", "while locating ProvisionExceptionTest$1LocalClass");
        }
    }

    public void testBindingAnnotationsOnMethodsAndConstructors() {
        try {
            Injector injector = Guice.createInjector((Module[])new Module[0]);
            injector.getInstance(MethodWithBindingAnnotation.class);
            ProvisionExceptionTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "ProvisionExceptionTest$MethodWithBindingAnnotation.injectMe() is annotated with @ProvisionExceptionTest$Green(), but binding annotations should be applied to its parameters instead.", "while locating ProvisionExceptionTest$MethodWithBindingAnnotation");
        }
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(ConstructorWithBindingAnnotation.class);
            ProvisionExceptionTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "ProvisionExceptionTest$ConstructorWithBindingAnnotation.<init>() is annotated with @ProvisionExceptionTest$Green(), but binding annotations should be applied to its parameters instead.", "at ProvisionExceptionTest$ConstructorWithBindingAnnotation.class", "while locating ProvisionExceptionTest$ConstructorWithBindingAnnotation");
        }
    }

    public void testBindingAnnotationWarningForScala() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).annotatedWith(Green.class).toInstance((Object)"lime!");
            }
        }});
        injector.getInstance(LikeScala.class);
    }

    public void testLinkedBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(D.class).to(RealD.class);
            }
        }});
        try {
            injector.getInstance(D.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "at ProvisionExceptionTest$RealD.<init>", "while locating ProvisionExceptionTest$RealD", "while locating ProvisionExceptionTest$D");
        }
    }

    public void testProviderKeyBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(D.class).toProvider(DProvider.class);
            }
        }});
        try {
            injector.getInstance(D.class);
            ProvisionExceptionTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "while locating ProvisionExceptionTest$DProvider", "while locating ProvisionExceptionTest$D");
        }
    }

    public void testDuplicateCausesCollapsed() {
        final RuntimeException sharedException = new RuntimeException("fail");
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.addError(sharedException);
                    this.addError(sharedException);
                }
            }});
            ProvisionExceptionTest.fail();
        }
        catch (CreationException ce) {
            ProvisionExceptionTest.assertEquals((Object)sharedException, (Object)ce.getCause());
            ProvisionExceptionTest.assertEquals((int)2, (int)ce.getErrorMessages().size());
            for (Message message : ce.getErrorMessages()) {
                ProvisionExceptionTest.assertEquals((Object)sharedException, (Object)message.getCause());
            }
        }
    }

    public void testMultipleDuplicates() {
        final RuntimeException exception1 = new RuntimeException("fail");
        final RuntimeException exception2 = new RuntimeException("abort");
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.addError(exception1);
                    this.addError(exception1);
                    this.addError(exception2);
                    this.addError(exception2);
                }
            }});
            ProvisionExceptionTest.fail();
        }
        catch (CreationException ce) {
            ProvisionExceptionTest.assertNull((Object)ce.getCause());
            ProvisionExceptionTest.assertEquals((int)4, (int)ce.getErrorMessages().size());
            String e1 = Throwables.getStackTraceAsString((Throwable)exception1);
            String e2 = Throwables.getStackTraceAsString((Throwable)exception2);
            Asserts.assertContains(ce.getMessage(), "\n1) ", "Caused by: RuntimeException: fail", "\n2) ", "(same stack trace as error #1)", "\n3) ", "Caused by: RuntimeException: abort", "\n4) ", "(same stack trace as error #3)");
        }
    }

    static class FProvider
    implements Provider<F> {
        FProvider() {
        }

        public F get() {
            return new F();
        }
    }

    static class F {
        @Inject
        public F() {
            throw new ProvisionException("User Exception", (Throwable)new RuntimeException());
        }
    }

    static class DProvider
    implements Provider<D> {
        DProvider() {
        }

        public D get() {
            throw new UnsupportedOperationException();
        }
    }

    static class RealD
    implements D {
        @Inject
        RealD() {
            throw new UnsupportedOperationException();
        }
    }

    static interface D {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.CONSTRUCTOR, ElementType.METHOD})
    @BindingAnnotation
    static @interface Green {
    }

    static class LikeScala {
        @Inject
        @Green
        String green;

        LikeScala() {
        }

        @Inject
        @Green
        String green() {
            return this.green;
        }
    }

    static class ConstructorWithBindingAnnotation {
        @Inject
        @Green
        ConstructorWithBindingAnnotation(String greenString) {
        }
    }

    static class MethodWithBindingAnnotation {
        MethodWithBindingAnnotation() {
        }

        @Inject
        @Green
        void injectMe(String greenString) {
        }
    }

    static class E {
        E() {
        }

        @Inject
        void setObject(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    static class C {
        C() {
        }

        @Inject
        void setD(RealD d) {
        }
    }

    static class B {
        @Inject
        C c;

        B() {
        }
    }

    static class A {
        @Inject
        A(B b) {
        }
    }

    private class InnerClass {
        private InnerClass(ProvisionExceptionTest provisionExceptionTest) {
        }
    }
}

