/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class ProvisionListenerTest
extends TestCase {
    public void testExceptionInListenerBeforeProvisioning() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new FailBeforeProvision()});
            }
        }});
        try {
            injector.getInstance(Foo.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException pe) {
            ProvisionListenerTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            Asserts.assertContains(pe.getMessage(), "Error notifying ProvisionListener ProvisionListenerTest$FailBeforeProvision of ProvisionListenerTest$Foo.", "Reason: RuntimeException: boo", "while locating ProvisionListenerTest$Foo");
            ProvisionListenerTest.assertEquals((String)"boo", (String)pe.getCause().getMessage());
        }
    }

    public void testExceptionInListenerAfterProvisioning() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new FailAfterProvision()});
            }
        }});
        try {
            injector.getInstance(Foo.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException pe) {
            ProvisionListenerTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            Asserts.assertContains(pe.getMessage(), "1) Error notifying ProvisionListener ProvisionListenerTest$FailAfterProvision of ProvisionListenerTest$Foo.", "Reason: RuntimeException: boo", "while locating ProvisionListenerTest$Foo");
            ProvisionListenerTest.assertEquals((String)"boo", (String)pe.getCause().getMessage());
        }
    }

    public void testExceptionInProvisionExplicitlyCalled() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new JustProvision()});
            }
        }});
        try {
            injector.getInstance(FooBomb.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException pe) {
            ProvisionListenerTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            Asserts.assertContains(pe.getMessage(), "1) [Guice/ErrorInjectingConstructor]: RuntimeException: Retry, Abort, Fail", " at ProvisionListenerTest$FooBomb", " while locating ProvisionListenerTest$FooBom");
            ProvisionListenerTest.assertEquals((String)"Retry, Abort, Fail", (String)pe.getCause().getMessage());
        }
    }

    public void testExceptionInProvisionAutomaticallyCalled() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new NoProvision()});
            }
        }});
        try {
            injector.getInstance(FooBomb.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException pe) {
            ProvisionListenerTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            Asserts.assertContains(pe.getMessage(), "1) [Guice/ErrorInjectingConstructor]: RuntimeException: Retry, Abort, Fail", " at ProvisionListenerTest$FooBomb", " while locating ProvisionListenerTest$FooBom");
            ProvisionListenerTest.assertEquals((String)"Retry, Abort, Fail", (String)pe.getCause().getMessage());
        }
    }

    public void testExceptionInFieldProvision() throws Exception {
        final CountAndCaptureExceptionListener listener = new CountAndCaptureExceptionListener();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener((Matcher)new AbstractMatcher<Binding<?>>(this){

                    public boolean matches(Binding<?> binding) {
                        return binding.getKey().getRawType().equals(DependsOnFooBombInField.class);
                    }
                }, new ProvisionListener[]{listener});
            }
        }});
        ProvisionListenerTest.assertEquals((int)0, (int)listener.beforeProvision);
        String expectedMsg = null;
        try {
            injector.getInstance(DependsOnFooBombInField.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException expected) {
            ProvisionListenerTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            expectedMsg = ((Message)Iterables.getOnlyElement((Iterable)expected.getErrorMessages())).getMessage();
            Asserts.assertContains(expected.getMessage(), "1) [Guice/ErrorInjectingConstructor]: RuntimeException: Retry, Abort, Fail", "at ProvisionListenerTest$FooBomb", "while locating ProvisionListenerTest$DependsOnFooBombInField");
            Asserts.assertContains(listener.capture.get().getMessage(), "1) [Guice/ErrorInjectingConstructor]: RuntimeException: Retry, Abort, Fail", "at ProvisionListenerTest$FooBomb");
            Truth.assertThat((String)listener.capture.get().getMessage()).doesNotContain((CharSequence)" while locating ProvisionListenerTestDependsOnFooBombInField");
        }
        ProvisionListenerTest.assertEquals((int)1, (int)listener.beforeProvision);
        ProvisionListenerTest.assertEquals((String)expectedMsg, (String)((Message)Iterables.getOnlyElement((Iterable)((ProvisionException)((Object)listener.capture.get())).getErrorMessages())).getMessage());
        ProvisionListenerTest.assertEquals((int)0, (int)listener.afterProvision);
    }

    public void testExceptionInCxtorProvision() throws Exception {
        final CountAndCaptureExceptionListener listener = new CountAndCaptureExceptionListener();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener((Matcher)new AbstractMatcher<Binding<?>>(this){

                    public boolean matches(Binding<?> binding) {
                        return binding.getKey().getRawType().equals(DependsOnFooBombInCxtor.class);
                    }
                }, new ProvisionListener[]{listener});
            }
        }});
        ProvisionListenerTest.assertEquals((int)0, (int)listener.beforeProvision);
        String expectedMsg = null;
        try {
            injector.getInstance(DependsOnFooBombInCxtor.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException expected) {
            ProvisionListenerTest.assertEquals((int)1, (int)expected.getErrorMessages().size());
            expectedMsg = ((Message)Iterables.getOnlyElement((Iterable)expected.getErrorMessages())).getMessage();
            Asserts.assertContains(expected.getMessage(), "1) [Guice/ErrorInjectingConstructor]: RuntimeException: Retry, Abort, Fail", "at ProvisionListenerTest$FooBomb.<init>(ProvisionListenerTest.java:", "at ProvisionListenerTest$DependsOnFooBombInCxtor.<init>(ProvisionListenerTest.java", "while locating ProvisionListenerTest$DependsOnFooBombInCxtor");
            Asserts.assertContains(listener.capture.get().getMessage(), "1) [Guice/ErrorInjectingConstructor]: RuntimeException: Retry, Abort, Fail", "at ProvisionListenerTest$FooBomb.<init>(ProvisionListenerTest.java:");
            Truth.assertThat((String)listener.capture.get().getMessage()).doesNotContain((CharSequence)"while locating ProvisionListenerTest$DependsOnFooBombInField");
        }
        ProvisionListenerTest.assertEquals((int)1, (int)listener.beforeProvision);
        ProvisionListenerTest.assertEquals((String)expectedMsg, (String)((Message)Iterables.getOnlyElement((Iterable)((ProvisionException)((Object)listener.capture.get())).getErrorMessages())).getMessage());
        ProvisionListenerTest.assertEquals((int)0, (int)listener.afterProvision);
    }

    public void testListenerCallsProvisionTwice() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionTwice()});
            }
        }});
        try {
            injector.getInstance(Foo.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException pe) {
            ProvisionListenerTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            Asserts.assertContains(pe.getMessage(), "1) Error notifying ProvisionListener ProvisionListenerTest$ProvisionTwice of ProvisionListenerTest$Foo.", "Reason: IllegalStateException: Already provisioned in this listener.", "while locating ProvisionListenerTest$Foo");
            ProvisionListenerTest.assertEquals((String)"Already provisioned in this listener.", (String)pe.getCause().getMessage());
        }
    }

    public void testCachedInScopePreventsProvisionNotify() {
        final Counter count1 = new Counter();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{count1});
                this.bind(Foo.class).in(Scopes.SINGLETON);
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        ProvisionListenerTest.assertNotNull((Object)foo);
        ProvisionListenerTest.assertEquals((int)1, (int)count1.count);
        count1.count = 0;
        ProvisionListenerTest.assertSame((Object)foo, (Object)injector.getInstance(Foo.class));
        ProvisionListenerTest.assertEquals((int)0, (int)count1.count);
    }

    public void testCombineAllBindListenerCalls() {
        final Counter count1 = new Counter();
        final Counter count2 = new Counter();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{count1});
                this.bindListener(Matchers.any(), new ProvisionListener[]{count2});
            }
        }});
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(Foo.class));
        ProvisionListenerTest.assertEquals((int)1, (int)count1.count);
        ProvisionListenerTest.assertEquals((int)1, (int)count2.count);
    }

    public void testNotifyEarlyListenersIfFailBeforeProvision() {
        final Counter count1 = new Counter();
        final Counter count2 = new Counter();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{count1, new FailBeforeProvision(), count2});
            }
        }});
        try {
            injector.getInstance(Foo.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException pe) {
            ProvisionListenerTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            Asserts.assertContains(pe.getMessage(), "1) Error notifying ProvisionListener ProvisionListenerTest$FailBeforeProvision of ProvisionListenerTest$Foo.", "Reason: RuntimeException: boo", "while locating ProvisionListenerTest$Foo");
            ProvisionListenerTest.assertEquals((String)"boo", (String)pe.getCause().getMessage());
            ProvisionListenerTest.assertEquals((int)1, (int)count1.count);
            ProvisionListenerTest.assertEquals((int)0, (int)count2.count);
        }
    }

    public void testNotifyLaterListenersIfFailAfterProvision() {
        final Counter count1 = new Counter();
        final Counter count2 = new Counter();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{count1, new FailAfterProvision(), count2});
            }
        }});
        try {
            injector.getInstance(Foo.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException pe) {
            ProvisionListenerTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            Asserts.assertContains(pe.getMessage(), "1) Error notifying ProvisionListener ProvisionListenerTest$FailAfterProvision of ProvisionListenerTest$Foo.", "Reason: RuntimeException: boo", "while locating ProvisionListenerTest$Foo");
            ProvisionListenerTest.assertEquals((String)"boo", (String)pe.getCause().getMessage());
            ProvisionListenerTest.assertEquals((int)1, (int)count1.count);
            ProvisionListenerTest.assertEquals((int)1, (int)count2.count);
        }
    }

    public void testNotifiedKeysOfAllBindTypes() {
        final Capturer capturer = new Capturer();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{capturer});
                this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"pk")).toProvider(FooP.class);
                try {
                    this.bind(Foo.class).annotatedWith((Annotation)Names.named((String)"cxtr")).toConstructor(Foo.class.getDeclaredConstructor(new Class[0]));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this.bind(LinkedFoo.class).to(Foo.class);
                this.bind(Interface.class).toInstance((Object)new Implementation());
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"constant")).to("MyConstant");
            }

            @Provides
            @Named(value="pi")
            Foo provideFooBar() {
                return new Foo();
            }
        }});
        ProvisionListenerTest.assertEquals((Object)ImmutableSet.of((Object)Key.get(Interface.class), (Object)Key.get(String.class, (Annotation)Names.named((String)"constant"))), capturer.getAsSetAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(Foo.class));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(Foo.class)), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(Key.get(Foo.class, (Annotation)Names.named((String)"pk"))));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(FooP.class), (Object)Key.get(Foo.class, (Annotation)Names.named((String)"pk"))), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(Key.get(Foo.class, (Annotation)Names.named((String)"pk"))));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(FooP.class), (Object)Key.get(Foo.class, (Annotation)Names.named((String)"pk"))), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(JitFoo2.class));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(JitFoo2P.class), (Object)Key.get(JitFoo2.class)), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(JitFoo2.class));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(JitFoo2P.class), (Object)Key.get(JitFoo2.class)), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(Key.get(Foo.class, (Annotation)Names.named((String)"pi"))));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(Foo.class, (Annotation)Names.named((String)"pi"))), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(Key.get(Foo.class, (Annotation)Names.named((String)"cxtr"))));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(Foo.class, (Annotation)Names.named((String)"cxtr"))), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(LinkedFoo.class));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(Foo.class)), capturer.getAndClear());
        ProvisionListenerTest.assertNotNull((Object)injector.getInstance(JitFoo.class));
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of((Object)Key.get(Foo.class)), capturer.getAndClear());
    }

    public void testSingletonMatcher() {
        final Counter counter = new Counter();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener((Matcher)new AbstractMatcher<Binding<?>>(this){

                    public boolean matches(Binding<?> t) {
                        return Scopes.isSingleton(t);
                    }
                }, new ProvisionListener[]{counter});
            }
        }});
        ProvisionListenerTest.assertEquals((int)0, (int)counter.count);
        injector.getInstance(Many.class);
        ProvisionListenerTest.assertEquals((int)0, (int)counter.count);
        injector.getInstance(Sole.class);
        ProvisionListenerTest.assertEquals((int)1, (int)counter.count);
    }

    public void testCallingBindingDotGetProviderDotGet() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(this){

                    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                        provision.getBinding().getProvider().get();
                    }
                }});
            }
        }});
        try {
            injector.getInstance(Sole.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        try {
            injector.getInstance(Many.class);
            ProvisionListenerTest.fail();
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
    }

    private static Matcher<Binding<?>> keyMatcher(final Class<?> clazz) {
        return new AbstractMatcher<Binding<?>>(){

            public boolean matches(Binding<?> t) {
                return t.getKey().equals((Object)Key.get((Class)clazz));
            }
        };
    }

    public void testDependencyChain() {
        final ArrayList pList = Lists.newArrayList();
        final ArrayList totalList = Lists.newArrayList();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Instance.class).toInstance((Object)new Instance());
                this.bind(B.class).to(BImpl.class);
                this.bind(D.class).toProvider(DP.class);
                this.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(){

                    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                        totalList.add(provision.getBinding().getKey().getRawType());
                    }
                }});
                ImmutableList.Builder chain = ImmutableList.builder();
                chain.add(Instance.class);
                this.bindListener(ProvisionListenerTest.keyMatcher(Instance.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
                chain.add(A.class);
                this.bindListener(ProvisionListenerTest.keyMatcher(A.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
                chain.add(B.class).add(BImpl.class);
                this.bindListener(ProvisionListenerTest.keyMatcher(BImpl.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
                chain.add(C.class);
                this.bindListener(ProvisionListenerTest.keyMatcher(C.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
                chain.add(D.class).add(DP.class);
                this.bindListener(ProvisionListenerTest.keyMatcher(D.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
                this.bindListener(ProvisionListenerTest.keyMatcher(DP.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
                chain.add(E.class);
                this.bindListener(ProvisionListenerTest.keyMatcher(E.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
                chain.add(F.class);
                this.bindListener(ProvisionListenerTest.keyMatcher(F.class), new ProvisionListener[]{new ChainAsserter(pList, (Iterable<Class<?>>)chain.build())});
            }

            @Provides
            C c(D d) {
                return new C(this){};
            }
        }});
        injector.getInstance(Instance.class);
        ProvisionListenerTest.assertEquals((Object)ImmutableList.of(Instance.class, A.class, BImpl.class, C.class, DP.class, D.class, E.class, F.class), (Object)pList);
        ProvisionListenerTest.assertEquals((Object)totalList, (Object)pList);
    }

    public void testModuleRequestInjection() {
        final AtomicBoolean notified = new AtomicBoolean();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.requestInjection(new Object(this){
                    @Inject
                    Foo foo;
                });
                this.bindListener(Matchers.any(), new ProvisionListener[]{new SpecialChecker(Foo.class, String.valueOf(((Object)((Object)this)).getClass().getName()).concat(".configure("), notified)});
            }
        }});
        ProvisionListenerTest.assertTrue((boolean)notified.get());
    }

    public void testToProviderInstance() {
        final AtomicBoolean notified = new AtomicBoolean();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Object.class).toProvider((Provider)new Provider<Object>(this){
                    @Inject
                    Foo foo;

                    public Object get() {
                        return null;
                    }
                });
                this.bindListener(Matchers.any(), new ProvisionListener[]{new SpecialChecker(Foo.class, String.valueOf(((Object)((Object)this)).getClass().getName()).concat(".configure("), notified)});
            }
        }});
        ProvisionListenerTest.assertTrue((boolean)notified.get());
    }

    public void testInjectorInjectMembers() {
        final Object object = new Object(this){
            @Inject
            Foo foo;
        };
        final AtomicBoolean notified = new AtomicBoolean();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new SpecialChecker(Foo.class, object.getClass().getName(), notified)});
            }
        }}).injectMembers(object);
        ProvisionListenerTest.assertTrue((boolean)notified.get());
    }

    public void testBindToInjectorWithListeningGivesSaneException() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bindListener(Matchers.any(), new ProvisionListener[]{new Counter()});
                    this.bind(Injector.class).toProvider(Providers.of(null));
                }
            }});
            ProvisionListenerTest.fail();
        }
        catch (CreationException ce) {
            Asserts.assertContains(ce.getMessage(), "Binding to core guice framework type is not allowed: Injector.");
        }
    }

    public void testProvisionIsNotifiedAfterContextsClear() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(this){

                    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                        Object provisioned = provision.provision();
                        if (provisioned instanceof X) {
                            ((X)provisioned).init();
                        } else if (provisioned instanceof Y) {
                            X.createY = false;
                            ((Y)provisioned).init();
                        }
                    }
                }});
            }
        }});
        X.createY = true;
        X x = (X)injector.getInstance(X.class);
        ProvisionListenerTest.assertNotSame((Object)x, (Object)x.y.x);
        int n = x.id;
        int n2 = x.y.x.id;
        ProvisionListenerTest.assertFalse((String)new StringBuilder(40).append("x.id: ").append(n).append(", x.y.x.id: ").append(n2).toString(), (x.id == x.y.x.id ? 1 : 0) != 0);
    }

    public void testDeDuplicateProvisionListeners() {
        final Counter counter = new Counter();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{counter});
                this.bindListener(Matchers.any(), new ProvisionListener[]{counter});
            }
        }});
        injector.getInstance(Many.class);
        ProvisionListenerTest.assertEquals((String)"ProvisionListener not de-duplicated", (int)1, (int)counter.count);
    }

    private static class Y {
        final Provider<X> xProvider;
        X x;

        @Inject
        Y(Provider<X> xProvider) {
            this.xProvider = xProvider;
        }

        void init() {
            this.x = (X)this.xProvider.get();
        }
    }

    private static class X {
        static final AtomicInteger COUNTER = new AtomicInteger();
        static boolean createY;
        final int id = COUNTER.getAndIncrement();
        final Provider<Y> yProvider;
        Y y;

        @Inject
        X(Provider<Y> yProvider) {
            this.yProvider = yProvider;
        }

        void init() {
            if (createY) {
                this.y = (Y)this.yProvider.get();
            }
        }
    }

    private static class F {
        private F() {
        }
    }

    private static class E {
        @Inject
        F f;

        private E() {
        }
    }

    private static class DP
    implements Provider<D> {
        @Inject
        Provider<E> ep;

        private DP() {
        }

        public D get() {
            this.ep.get();
            return new D(this){};
        }
    }

    private static interface D {
    }

    private static interface C {
    }

    private static class BImpl
    implements B {
        private BImpl() {
        }

        @Inject
        void inject(C c) {
        }
    }

    private static interface B {
    }

    private static class A {
        @Inject
        A(B b) {
        }
    }

    private static class Instance {
        @Inject
        A a;

        private Instance() {
        }
    }

    private static class SpecialChecker
    implements ProvisionListener {
        private final Class<?> notifyType;
        private final String firstSource;
        private final AtomicBoolean notified;

        public SpecialChecker(Class<?> notifyType, String firstSource, AtomicBoolean notified) {
            this.notifyType = notifyType;
            this.firstSource = firstSource;
            this.notified = notified;
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            this.notified.set(true);
            TestCase.assertEquals(this.notifyType, (Object)provision.getBinding().getKey().getRawType());
        }
    }

    private static class ChainAsserter
    implements ProvisionListener {
        private final List<Class<?>> provisionList;
        private final List<Class<?>> expected;

        public ChainAsserter(List<Class<?>> provisionList, Iterable<Class<?>> expected) {
            this.provisionList = provisionList;
            this.expected = ImmutableList.copyOf(expected);
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            this.provisionList.add(provision.getBinding().getKey().getRawType());
        }
    }

    private static class ProvisionTwice
    implements ProvisionListener {
        private ProvisionTwice() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            provision.provision();
            provision.provision();
        }
    }

    private static class NoProvision
    implements ProvisionListener {
        private NoProvision() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        }
    }

    private static class JustProvision
    implements ProvisionListener {
        private JustProvision() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            provision.provision();
        }
    }

    private static class FailAfterProvision
    implements ProvisionListener {
        private FailAfterProvision() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            provision.provision();
            throw new RuntimeException("boo");
        }
    }

    private static class FailBeforeProvision
    implements ProvisionListener {
        private FailBeforeProvision() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            throw new RuntimeException("boo");
        }
    }

    private static class Capturer
    implements ProvisionListener {
        List<Key<?>> keys = Lists.newArrayList();

        private Capturer() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            this.keys.add(provision.getBinding().getKey());
            Object provisioned = provision.provision();
            if (provision.getBinding() instanceof InstanceBinding) {
                Class expected = provision.getBinding().getKey().getRawType();
                String string = String.valueOf(expected);
                String string2 = String.valueOf(provisioned);
                TestCase.assertTrue((String)new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(string2).length()).append("expected instanceof: ").append(string).append(", but was: ").append(string2).toString(), (boolean)expected.isInstance(provisioned));
            } else {
                TestCase.assertEquals((Object)provision.getBinding().getKey().getRawType(), provisioned.getClass());
            }
        }

        Set<Key<?>> getAsSetAndClear() {
            ImmutableSet copy = ImmutableSet.copyOf(this.keys);
            this.keys.clear();
            return copy;
        }

        List<Key<?>> getAndClear() {
            ImmutableList copy = ImmutableList.copyOf(this.keys);
            this.keys.clear();
            return copy;
        }
    }

    private static class CountAndCaptureExceptionListener
    implements ProvisionListener {
        int beforeProvision = 0;
        int afterProvision = 0;
        AtomicReference<RuntimeException> capture = new AtomicReference();

        private CountAndCaptureExceptionListener() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            ++this.beforeProvision;
            try {
                provision.provision();
            }
            catch (RuntimeException re) {
                this.capture.set(re);
                throw re;
            }
            ++this.afterProvision;
        }
    }

    private static class Counter
    implements ProvisionListener {
        int count = 0;

        private Counter() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            ++this.count;
        }
    }

    static class DependsOnFooBombInCxtor {
        @Inject
        DependsOnFooBombInCxtor(FooBomb fooBomb) {
        }
    }

    static class DependsOnFooBombInField {
        @Inject
        FooBomb fooBomb;

        DependsOnFooBombInField() {
        }
    }

    static class FooBomb {
        FooBomb() {
            throw new RuntimeException("Retry, Abort, Fail");
        }
    }

    static class JitFoo2P
    implements Provider<JitFoo2> {
        JitFoo2P() {
        }

        public JitFoo2 get() {
            return new JitFoo2();
        }
    }

    static class FooP
    implements Provider<Foo> {
        FooP() {
        }

        public Foo get() {
            return new Foo();
        }
    }

    static class Foo
    implements JitFoo,
    LinkedFoo {
        Foo() {
        }
    }

    static interface LinkedFoo {
    }

    @ProvidedBy(value=JitFoo2P.class)
    static class JitFoo2 {
        JitFoo2() {
        }
    }

    @ImplementedBy(value=Foo.class)
    static interface JitFoo {
    }

    static class Many {
        Many() {
        }
    }

    @Singleton
    static class Sole {
        Sole() {
        }
    }

    static class Implementation
    implements Interface {
        Implementation() {
        }
    }

    static interface Interface {
    }
}

