/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Qualifier;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class DuplicateElementErrorTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void duplicateElementError() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DuplicateElementModule()});
        ProvisionException exception = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> injector.getInstance((Key)new Key<Set<String>>(this){}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "duplicate_element_error.txt");
    }

    @Test
    public void multipleDuplicatesElementError() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new MultipleDuplicateElementsModule()});
        ProvisionException exception = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> injector.getInstance((Key)new Key<Set<IntWrapper>>(this, Foo.class){}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "multiple_duplicate_elements_error.txt");
    }

    static class MultipleDuplicateElementsModule
    extends AbstractModule {
        MultipleDuplicateElementsModule() {
        }

        @ProvidesIntoSet
        @Foo
        IntWrapper provideFirstIntWrapper0() {
            return new IntWrapper(0);
        }

        @ProvidesIntoSet
        @Foo
        IntWrapper provideSecondIntWrapper0() {
            return new IntWrapper(0);
        }

        @ProvidesIntoSet
        @Foo
        IntWrapper provideFirstIntWrapper1() {
            return new IntWrapper(1);
        }

        @ProvidesIntoSet
        @Foo
        IntWrapper provideSecondIntWrapper1() {
            return new IntWrapper(1);
        }

        protected void configure() {
            Multibinder.newSetBinder((Binder)this.binder(), (Key)Key.get(IntWrapper.class, Foo.class)).addBinding().toProvider(() -> new IntWrapper(1));
        }
    }

    static class IntWrapper {
        private static final AtomicInteger counter = new AtomicInteger(100);
        int value;
        int id;

        IntWrapper(int value) {
            this.value = value;
            this.id = counter.getAndIncrement();
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (other instanceof IntWrapper) {
                return ((IntWrapper)other).value == this.value;
            }
            return false;
        }

        public String toString() {
            return String.format("IntWrapper(%s)", this.id);
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Foo {
    }

    static class DuplicateElementModule
    extends AbstractModule {
        DuplicateElementModule() {
        }

        @ProvidesIntoSet
        String provideFirst() {
            return "element";
        }

        @ProvidesIntoSet
        String provideSecond() {
            return "element";
        }

        protected void configure() {
            Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"element");
        }
    }
}

