/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.common.io.Resources;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

final class ErrorMessageTestUtils {
    private static final String LINE_NUMBER_REGEX = ":\\d+";
    private static final String LINE_NUMBER_PLACEHOLDER = ":0";

    private ErrorMessageTestUtils() {
    }

    static void assertGuiceErrorEqualsIgnoreLineNumber(String actual, String expectedFileName) {
        String expectedError;
        try {
            expectedError = ErrorMessageTestUtils.getExpectedError(expectedFileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read expected error message.", e);
        }
        ErrorMessageTestUtils.assertErrorMessage(actual, expectedError);
    }

    private static void assertErrorMessage(String actual, String expected) {
        String actualWithoutLineNumber = actual.replaceAll(LINE_NUMBER_REGEX, LINE_NUMBER_PLACEHOLDER);
        String expectedWithoutLineNumber = expected.replaceAll(LINE_NUMBER_REGEX, LINE_NUMBER_PLACEHOLDER);
        Truth.assertWithMessage((String)"Actual: \n%s\nExpected:\n%s\n", (Object[])new Object[]{actual, expected}).that(actualWithoutLineNumber).isEqualTo((Object)expectedWithoutLineNumber);
    }

    private static String getExpectedError(String fileName) throws IOException {
        String string = String.valueOf(fileName);
        return Resources.toString((URL)ErrorMessageTestUtils.class.getResource(string.length() != 0 ? "testdata/".concat(string) : new String("testdata/")), (Charset)StandardCharsets.UTF_8);
    }
}

