/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class GenericErrorTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void customError() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new ErrorModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "custom_error.txt");
    }

    @Test
    public void errorInCustomProvider() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ProvisionErrorModule()});
        ProvisionException exception = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> injector.getInstance(String.class));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "error_in_custom_provider.txt");
    }

    @Test
    public void errorInjectingConstructor() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ProvisionErrorModule()});
        ProvisionException exception = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> injector.getInstance(Object.class));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "error_injecting_constructor.txt");
    }

    static class ProvisionErrorModule
    extends AbstractModule {
        ProvisionErrorModule() {
        }

        @Provides
        String provideString() {
            throw new RuntimeException("can't do that");
        }

        @Provides
        Object provideObject(BadConstructor bad) {
            return bad;
        }
    }

    static class BadConstructor {
        BadConstructor() {
            throw new RuntimeException("bad");
        }
    }

    static class ErrorModule
    extends AbstractModule {
        ErrorModule() {
        }

        protected void configure() {
            this.binder().addError("Custom error", new Object[0]);
        }
    }
}

