/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ScopeAnnotation;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ScopeNotFoundErrorTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void scopeNotFoundError() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new ErrorModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "scope_not_found_error.txt");
    }

    static class ErrorModule
    extends AbstractModule {
        ErrorModule() {
        }

        protected void configure() {
            this.bind(BatchHelper.class).in(BatchScoped.class);
            this.bind(RequestHelper.class);
        }

        @Provides
        @RequestScoped
        String provideString() {
            return "request scoped";
        }
    }

    static class BatchHelper {
        BatchHelper() {
        }
    }

    @RequestScoped
    static class RequestHelper {
        RequestHelper() {
        }
    }

    @ScopeAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface RequestScoped {
    }

    @ScopeAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface BatchScoped {
    }
}

