/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.example;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import junit.framework.Assert;

public class ClientServiceWithGuice {
    public void testClient() {
        MockService mock = new MockService();
        Client client = new Client(mock);
        client.go();
        Assert.assertTrue((boolean)mock.isGone());
    }

    public static void main(String[] args) throws CreationException {
        new ClientServiceWithGuice().testClient();
        Injector injector = Guice.createInjector((Module[])new Module[]{new MyModule()});
        Client client = (Client)injector.getInstance(Client.class);
    }

    public static class MockService
    implements Service {
        private boolean gone = false;

        @Override
        public void go() {
            this.gone = true;
        }

        public boolean isGone() {
            return this.gone;
        }
    }

    public static class Client {
        private final Service service;

        @Inject
        public Client(Service service) {
            this.service = service;
        }

        public void go() {
            this.service.go();
        }
    }

    public static class MyModule
    extends AbstractModule {
        protected void configure() {
            this.bind(Service.class).to(ServiceImpl.class).in(Scopes.SINGLETON);
        }
    }

    public static class ServiceImpl
    implements Service {
        @Override
        public void go() {
        }
    }

    public static interface Service {
        public void go();
    }
}

