/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.truth.Truth;
import com.google.inject.internal.PackageNameCompressor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PackageNameCompressorTest {
    @Test
    public void testEmptyInput() {
        String input = "";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)input);
    }

    @Test
    public void testSimple() {
        String input = "Something is wrong with foo.bar.baz.Foo class!";
        String expectedOutput = "Something is wrong with Foo class!\n\n======================\nFull classname legend:\n======================\nFoo: \"foo.bar.baz.Foo\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testSingleLetterClassName() {
        String input = "Something is wrong with foo.bar.baz.F class!";
        String expectedOutput = "Something is wrong with F class!\n\n======================\nFull classname legend:\n======================\nF: \"foo.bar.baz.F\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testSameSimpleNames() {
        String input = "Something is wrong with foo.bar.baz.Foo and foo.bar.qux.Foo class!";
        String expectedOutput = "Something is wrong with baz.Foo and qux.Foo class!\n\n======================\nFull classname legend:\n======================\nbaz.Foo: \"foo.bar.baz.Foo\"\nqux.Foo: \"foo.bar.qux.Foo\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testMethodNames() {
        String input = "Something is wrong with foo.bar.baz.Foo.provideFoo()!";
        String expectedOutput = "Something is wrong with Foo.provideFoo()!\n\n======================\nFull classname legend:\n======================\nFoo: \"foo.bar.baz.Foo\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testMultipleLevelsOfConflicts() {
        String input = "Something is wrong with z.a.b.c.Foo, z.b.b.c.Foo, z.a.b.d.Foo class!";
        String expectedOutput = "Something is wrong with a.b.c.Foo, b.b.c.Foo, d.Foo class!\n\n======================\nFull classname legend:\n======================\na.b.c.Foo: \"z.a.b.c.Foo\"\nb.b.c.Foo: \"z.b.b.c.Foo\"\nd.Foo:     \"z.a.b.d.Foo\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testInnerClassesKeepOuterClassNameToo() {
        String input = "Something is wrong with foo.bar.baz.Foo.Bar.Baz class!";
        String expectedOutput = "Something is wrong with Foo.Bar.Baz class!\n\n======================\nFull classname legend:\n======================\nFoo: \"foo.bar.baz.Foo\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testThreeMultiLevelConflicts() {
        String input = "Something is wrong with z.a.c.Foo, z.b.c.Foo, and z.c.c.Foo class!";
        String expectedOutput = "Something is wrong with a.c.Foo, b.c.Foo, and c.c.Foo class!\n\n======================\nFull classname legend:\n======================\na.c.Foo: \"z.a.c.Foo\"\nb.c.Foo: \"z.b.c.Foo\"\nc.c.Foo: \"z.c.c.Foo\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testSingleGeneric() {
        String input = "No implementation found for java.util.Set<java.lang.String>.";
        String expectedOutput = "No implementation found for Set<String>.";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testMultipleGeneric() {
        String input = "No implementation found for java.util.Map<java.lang.String, java.lang.String>.";
        String expectedOutput = "No implementation found for Map<String, String>.";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testNestedGeneric() {
        String input = "No implementation found for java.util.Map<java.lang.String, java.util.Set<java.lang.String>>.";
        String expectedOutput = "No implementation found for Map<String, Set<String>>.";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testQuotedStringShouldNotBeCompressed() {
        String input = "Duplicate key \"com.google.Foo\" found in java.util.Map<java.lang.String, java.lang.Object>.";
        String expectedOutput = "Duplicate key \"com.google.Foo\" found in Map<String, Object>.";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testEmptyQuotedString() {
        String input = "Duplicate key \"\" found in java.util.Map<java.lang.String, java.lang.Object>.";
        String expectedOutput = "Duplicate key \"\" found in Map<String, Object>.";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testUnbalancedQuotedString() {
        String input = "Duplicate key \"java.util.List found in java.util.Map<java.lang.String, java.lang.Object>.";
        String expectedOutput = "Duplicate key \"List found in Map<String, Object>.";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testQuotedStringSpanMultipleLines() {
        String input = "Some strange string with \"java.util.List, \n and java.lang.Integer\".";
        String expectedOutput = "Some strange string with \"List, \n and Integer\".";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testDoesNotCompressSubstringsOfClasses() {
        String input = "Something is wrong with Bar.Foo class!";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)input);
    }

    @Test
    public void testDoesNotCompressShortPackageNames() {
        String input = "Something is wrong with foo.Foo should not be empty!";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)input);
    }

    @Test
    public void testNoClassNamesDoNotPutInLegend() {
        String input = "Something is wrong with something!";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)input);
    }

    @Test
    public void testFullConflictsDoNotPutInLegend() {
        String input = "Something is wrong with foo.Foo and bar.Foo class!";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)input);
    }

    @Test
    public void testLegendDoesNotIncludeJavaLang() {
        String input = "Something is wrong with java.lang.Set, java.lang.a.Foo, and java.lang.b.Foo class!";
        String expectedOutput = "Something is wrong with Set, a.Foo, and b.Foo class!\n\n======================\nFull classname legend:\n======================\na.Foo: \"java.lang.a.Foo\"\nb.Foo: \"java.lang.b.Foo\"\n========================\nEnd of classname legend:\n========================\n";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testOnlyExcludedPrefixesDoesNotPutInLegend() {
        String input = "Something is wrong with java.lang.Set class!";
        String expectedOutput = "Something is wrong with Set class!";
        Truth.assertThat((String)PackageNameCompressor.compressPackagesInMessage((String)input)).isEqualTo((Object)expectedOutput);
    }

    @Test
    public void testWrappedErrorMessageRemovesEmbeddedLegend() {
        String error = "No implement bound for com.google.foo.bar.Baz. Required by com.google.foo.BarImpl.";
        String compressedError = PackageNameCompressor.compressPackagesInMessage((String)error);
        String string = String.valueOf(compressedError);
        String input = string.length() != 0 ? "Something's gone wrong while locating com.google.foo.baz.BazImpl. See error:\n".concat(string) : new String("Something's gone wrong while locating com.google.foo.baz.BazImpl. See error:\n");
        String expected = new StringBuilder(242 + String.valueOf(compressedError).length()).append("Something's gone wrong while locating BazImpl. See error:\n").append(compressedError).append("\n\n======================\nFull classname legend:\n======================\n").append("BazImpl: \"com.google.foo.baz.BazImpl\"\n").append("========================\nEnd of classname legend:\n========================\n").toString();
        String actual = PackageNameCompressor.compressPackagesInMessage((String)input);
        Truth.assertThat((String)actual).isEqualTo((Object)expected);
    }

    @Test
    public void wrappedErrorMessageRemovesEmbeddedLegend_differentCompressionNames() {
        String error = "No implement bound for com.google.foo.bar.Baz. Required by com.google.foo.BazImpl.";
        String compressedError = PackageNameCompressor.compressPackagesInMessage((String)error);
        String string = String.valueOf(compressedError);
        String input = string.length() != 0 ? "Something's gone wrong while locating com.google.foo.baz.BazImpl. See error:\n".concat(string) : new String("Something's gone wrong while locating com.google.foo.baz.BazImpl. See error:\n");
        String expected = new StringBuilder(250 + String.valueOf(compressedError).length()).append("Something's gone wrong while locating baz.BazImpl. See error:\n").append(compressedError).append("\n\n======================\nFull classname legend:\n======================\n").append("baz.BazImpl: \"com.google.foo.baz.BazImpl\"\n").append("========================\nEnd of classname legend:\n========================\n").toString();
        String actual = PackageNameCompressor.compressPackagesInMessage((String)input);
        Truth.assertThat((String)actual).isEqualTo((Object)expected);
    }
}

