/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.WeakKeySet;
import java.util.Set;
import junit.framework.Assert;

public final class WeakKeySetUtils {
    private WeakKeySetUtils() {
    }

    public static void assertBanned(Injector injector, Key<?> key) {
        WeakKeySetUtils.assertBannedState(injector, key, true);
    }

    public static void assertNotBanned(Injector injector, Key<?> key) {
        WeakKeySetUtils.assertBannedState(injector, key, false);
    }

    public static void assertNotInSet(WeakKeySet set, Key<?> key) {
        for (int i = 0; i < 10 && set.contains(key); ++i) {
            WeakKeySetUtils.sleep();
        }
        Assert.assertFalse((boolean)set.contains(key));
        Assert.assertNull((Object)set.getSources(Key.get(Integer.class)));
    }

    public static void assertInSet(WeakKeySet set, Key<?> key, int expectedSources, Object ... sources) {
        Assert.assertTrue((boolean)set.contains(key));
        Assert.assertEquals((int)expectedSources, (int)set.getSources(key).size());
        for (Object source : sources) {
            String string = String.valueOf(source);
            Assert.assertTrue((String)new StringBuilder(23 + String.valueOf(string).length()).append("didn't contain source: ").append(string).toString(), (boolean)set.getSources(key).contains(source));
        }
    }

    public static void assertSourceNotInSet(WeakKeySet set, Key<?> key, Object source) {
        for (int i = 0; i < 10; ++i) {
            Set sources = set.getSources(key);
            Assert.assertNotNull((String)"expected at least one source", (Object)source);
            if (!sources.contains(source)) break;
            WeakKeySetUtils.sleep();
        }
        Set sources = set.getSources(key);
        Assert.assertNotNull((String)"expected at least one source", (Object)source);
        Assert.assertFalse((boolean)sources.contains(source));
    }

    private static void assertBannedState(Injector injector, Key<?> key, boolean isBanned) {
        if (!isBanned) {
            for (int i = 0; i < 10 && ((InjectorImpl)injector).getJitBindingData().isBannedKey(key); ++i) {
                WeakKeySetUtils.sleep();
            }
        }
        Assert.assertEquals((boolean)isBanned, (boolean)((InjectorImpl)injector).getJitBindingData().isBannedKey(key));
    }

    private static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Thread.yield();
    }
}

