/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.testing.FakeTicker;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.Truth;
import com.google.inject.internal.util.ContinuousStopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ContinuousStopwatchTest {
    private static final Logger logger = Logger.getLogger(ContinuousStopwatch.class.getName());
    private TestLogHandler testLogHandler;
    private Level savedLogLevel;

    @Before
    public void addLogHandler() {
        this.savedLogLevel = logger.getLevel();
        logger.setLevel(Level.FINE);
        this.testLogHandler = new TestLogHandler();
        logger.addHandler((Handler)this.testLogHandler);
    }

    @After
    public void removeLogHandler() {
        Logger.getLogger(ContinuousStopwatch.class.getName()).removeHandler((Handler)this.testLogHandler);
        logger.setLevel(this.savedLogLevel);
    }

    @Test
    public void multipleReset() throws Exception {
        FakeTicker fakeTicker = new FakeTicker();
        ContinuousStopwatch continuousStopwatch = new ContinuousStopwatch(Stopwatch.createUnstarted((Ticker)fakeTicker));
        fakeTicker.advance(1L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Long)continuousStopwatch.reset()).isEqualTo((Object)1);
        fakeTicker.advance(2L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Long)continuousStopwatch.reset()).isEqualTo((Object)2);
    }

    @Test
    public void multipleResetAndLog() throws Exception {
        FakeTicker fakeTicker = new FakeTicker();
        ContinuousStopwatch continuousStopwatch = new ContinuousStopwatch(Stopwatch.createUnstarted((Ticker)fakeTicker));
        fakeTicker.advance(1L, TimeUnit.MILLISECONDS);
        continuousStopwatch.resetAndLog("label one");
        fakeTicker.advance(2L, TimeUnit.MILLISECONDS);
        continuousStopwatch.resetAndLog("label two");
        List logs = this.testLogHandler.getStoredLogRecords();
        Truth.assertThat((Iterable)logs).hasSize(2);
        Truth.assertThat((String)((LogRecord)logs.get(0)).getMessage()).isEqualTo((Object)"label one: 1ms");
        Truth.assertThat((String)((LogRecord)logs.get(1)).getMessage()).isEqualTo((Object)"label two: 2ms");
    }
}

