/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matchers;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@RunWith(value=JUnit4.class)
public class LineNumbersTest {
    @Test
    public void testLineNumbers() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(A.class);
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "No implementation for LineNumbersTest$B was bound.", "for 1st parameter b", "at LineNumbersTest$1.configure");
        }
    }

    @Test
    public void testCanHandleLineNumbersForGuiceGeneratedClasses() {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bindInterceptor(Matchers.only(A.class), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(this){

                        public Object invoke(MethodInvocation methodInvocation) {
                            return null;
                        }
                    }});
                    this.bind(A.class);
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "No implementation for LineNumbersTest$B was bound.", "for 1st parameter b", "at LineNumbersTest$2.configure");
        }
    }

    @Test
    public void testUnavailableByteCodeShowsUnknownSource() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(new GeneratingClassLoader().generate());
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "No implementation for LineNumbersTest$B was bound.", "for 1st parameter", "at LineNumbersTest$3.configure");
        }
    }

    @Test
    public void testGeneratedClassesCanSucceed() {
        final Class<?> generated = new GeneratingClassLoader().generate();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(generated);
                this.bind(B.class).toInstance((Object)new B(this){});
            }
        }});
        Object instance = injector.getInstance(generated);
        Assert.assertEquals(instance.getClass(), generated);
    }

    static class GeneratingClassLoader
    extends ClassLoader {
        static String name = "__generated";

        GeneratingClassLoader() {
            super(B.class.getClassLoader());
        }

        Class<?> generate() {
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 1, name, null, Type.getInternalName(Object.class), null);
            String string = Type.getDescriptor(B.class);
            String sig = new StringBuilder(3 + String.valueOf(string).length()).append("(").append(string).append(")V").toString();
            MethodVisitor mv = cw.visitMethod(1, "<init>", sig, null, null);
            mv.visitAnnotation(Type.getDescriptor(Inject.class), true);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V");
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            byte[] buf = cw.toByteArray();
            return this.defineClass(name.replace('/', '.'), buf, 0, buf.length);
        }
    }

    public static interface B {
    }

    static class A {
        @Inject
        A(B b) {
        }
    }
}

