/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.name;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.internal.Annotations;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Properties;
import junit.framework.TestCase;

public class NamedEquivalanceTest
extends TestCase {
    private static final Module GUICE_BINDING_MODULE = NamedEquivalanceTest.moduleWithAnnotation((Annotation)Names.named((String)"foo"));
    private static final Module JSR330_BINDING_MODULE = NamedEquivalanceTest.moduleWithAnnotation((Annotation)((Object)new JsrNamed("foo")));
    private static final Module GUICE_PROVIDER_METHOD_MODULE = NamedEquivalanceTest.getGuiceBindingProviderMethodModule();
    private static final Module JSR330_PROVIDER_METHOD_MODULE = NamedEquivalanceTest.getJsr330BindingProviderMethodModule();

    public void testKeysCreatedWithDifferentTypesAreEqual() {
        NamedEquivalanceTest.assertEquals(NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new GuiceNamed("foo"))), NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new JsrNamed("foo"))));
        NamedEquivalanceTest.assertEquals(NamedEquivalanceTest.keyForAnnotation((Annotation)Names.named((String)"foo")), NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new GuiceNamed("foo"))));
        NamedEquivalanceTest.assertEquals(NamedEquivalanceTest.keyForAnnotation((Annotation)Names.named((String)"foo")), NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new JsrNamed("foo"))));
        NamedEquivalanceTest.assertEquals(NamedEquivalanceTest.keyForAnnotationType(Named.class), NamedEquivalanceTest.keyForAnnotationType(javax.inject.Named.class));
    }

    private static Key<String> keyForAnnotation(Annotation annotation) {
        return Key.get(String.class, (Annotation)annotation);
    }

    private static Key<String> keyForAnnotationType(Class<? extends Annotation> annotationType) {
        return Key.get(String.class, annotationType);
    }

    public void testBindingWithNamesCanInjectBothTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(GUICE_BINDING_MODULE);
    }

    public void testBindingWithJsr330AnnotationCanInjectBothTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(JSR330_BINDING_MODULE);
    }

    public void testBindingWithGuiceNamedAnnotatedProviderMethodCanInjectBothTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(GUICE_PROVIDER_METHOD_MODULE);
    }

    public void testBindingWithJsr330NamedAnnotatedProviderMethodCanInjectBothTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(JSR330_PROVIDER_METHOD_MODULE);
    }

    public void testBindingDifferentTypesWithSameValueIsIgnored() {
        NamedEquivalanceTest.assertDuplicateBinding(GUICE_BINDING_MODULE, JSR330_BINDING_MODULE, false);
        NamedEquivalanceTest.assertDuplicateBinding(JSR330_BINDING_MODULE, GUICE_BINDING_MODULE, false);
    }

    public void testBindingDifferentTypesWithSameValueIsAnErrorWithProviderMethods() {
        NamedEquivalanceTest.assertDuplicateBinding(GUICE_PROVIDER_METHOD_MODULE, JSR330_PROVIDER_METHOD_MODULE, true);
        NamedEquivalanceTest.assertDuplicateBinding(JSR330_PROVIDER_METHOD_MODULE, GUICE_PROVIDER_METHOD_MODULE, true);
    }

    public void testBindingDifferentTypesWithSameValueIsAnErrorMixed() {
        NamedEquivalanceTest.assertDuplicateBinding(GUICE_BINDING_MODULE, JSR330_PROVIDER_METHOD_MODULE, true);
        NamedEquivalanceTest.assertDuplicateBinding(JSR330_BINDING_MODULE, GUICE_PROVIDER_METHOD_MODULE, true);
    }

    public void testMissingBindingForGuiceNamedUsesSameTypeInErrorMessage() {
        NamedEquivalanceTest.assertMissingBindingErrorMessageUsesType(GuiceNamedClient.class);
    }

    public void testMissingBindingForJsr330NamedUsesSameTypeInErrorMessage() {
        NamedEquivalanceTest.assertMissingBindingErrorMessageUsesType(Jsr330NamedClient.class);
    }

    public void testBindPropertiesWorksWithJsr330() {
        NamedEquivalanceTest.assertInjectionsSucceed((Module)new AbstractModule(this){

            protected void configure() {
                Properties properties = new Properties();
                properties.put("foo", "bar");
                Names.bindProperties((Binder)this.binder(), (Properties)properties);
            }
        });
    }

    private static void assertMissingBindingErrorMessageUsesType(Class<?> clientType) {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(clientType);
            NamedEquivalanceTest.fail((String)"should have thrown ConfigurationException");
        }
        catch (ConfigurationException e) {
            String[] stringArray = new String[1];
            String string = Annotations.memberValueString((String)"value", (Object)"foo");
            stringArray[0] = new StringBuilder(63 + String.valueOf(string).length()).append("No implementation for String annotated with @Named(").append(string).append(") was bound.").toString();
            Asserts.assertContains(e.getMessage(), stringArray);
        }
    }

    private static void assertDuplicateBinding(Module a, Module b, boolean fails) {
        try {
            Guice.createInjector((Module[])new Module[]{a, b});
            if (fails) {
                NamedEquivalanceTest.fail((String)"should have thrown CreationException");
            }
        }
        catch (CreationException e) {
            if (fails) {
                String[] stringArray = new String[1];
                String string = Annotations.memberValueString((String)"value", (Object)"foo");
                stringArray[0] = new StringBuilder(56 + String.valueOf(string).length()).append("String annotated with @Named(").append(string).append(") was bound multiple times.").toString();
                Asserts.assertContains(e.getMessage(), stringArray);
            }
            throw e;
        }
    }

    private static Module moduleWithAnnotation(final Annotation annotation) {
        return new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(annotation).to("bar");
            }
        };
    }

    private static void assertInjectionsSucceed(Module module) {
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        NamedEquivalanceTest.assertInjected((GuiceNamedClient)injector.getInstance(GuiceNamedClient.class), (Jsr330NamedClient)injector.getInstance(Jsr330NamedClient.class));
    }

    private static void assertInjected(GuiceNamedClient guiceClient, Jsr330NamedClient jsr330Client) {
        NamedEquivalanceTest.assertEquals((String)"bar", (String)guiceClient.foo);
        NamedEquivalanceTest.assertEquals((String)"bar", (String)jsr330Client.foo);
    }

    private static Module getJsr330BindingProviderMethodModule() {
        return new AbstractModule(){

            @Provides
            @javax.inject.Named(value="foo")
            String provideFoo() {
                return "bar";
            }
        };
    }

    private static Module getGuiceBindingProviderMethodModule() {
        return new AbstractModule(){

            @Provides
            @Named(value="foo")
            String provideFoo() {
                return "bar";
            }
        };
    }

    private static class GuiceNamed
    implements Named,
    Serializable {
        private final String value;
        private static final long serialVersionUID = 0L;

        public GuiceNamed(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Named)) {
                return false;
            }
            Named other = (Named)o;
            return this.value.equals(other.value());
        }

        public String toString() {
            String string = Named.class.getName();
            String string2 = Annotations.memberValueString((String)"value", (Object)this.value);
            return new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length()).append("@").append(string).append("(value=").append(string2).append(")").toString();
        }

        public Class<? extends Annotation> annotationType() {
            return Named.class;
        }
    }

    private static class JsrNamed
    implements javax.inject.Named,
    Serializable {
        private final String value;
        private static final long serialVersionUID = 0L;

        public JsrNamed(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof javax.inject.Named)) {
                return false;
            }
            javax.inject.Named other = (javax.inject.Named)o;
            return this.value.equals(other.value());
        }

        public String toString() {
            String string = javax.inject.Named.class.getName();
            String string2 = Annotations.memberValueString((String)"value", (Object)this.value);
            return new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length()).append("@").append(string).append("(value=").append(string2).append(")").toString();
        }

        public Class<? extends Annotation> annotationType() {
            return javax.inject.Named.class;
        }
    }

    private static class Jsr330NamedClient {
        @Inject
        @javax.inject.Named(value="foo")
        String foo;

        private Jsr330NamedClient() {
        }
    }

    private static class GuiceNamedClient {
        @Inject
        @Named(value="foo")
        String foo;

        private GuiceNamedClient() {
        }
    }
}

