/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.internal.InternalFlags;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.ProviderMethodsModule;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProvidesMethodBinding;
import com.google.inject.spi.ProvidesMethodTargetVisitor;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProviderMethodsTest
implements Module {
    @Test
    public void testProviderMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{this});
        Bob bob = (Bob)injector.getInstance(Bob.class);
        Assert.assertEquals((Object)"A Bob", (Object)bob.getName());
        Bob clone = (Bob)injector.getInstance(Bob.class);
        Assert.assertEquals((Object)"A Bob", (Object)clone.getName());
        Assert.assertNotSame((Object)bob, (Object)clone);
        Assert.assertSame((Object)bob.getDaughter(), (Object)clone.getDaughter());
        Key soleBobKey = Key.get(Bob.class, Sole.class);
        Assert.assertSame((Object)injector.getInstance(soleBobKey), (Object)injector.getInstance(soleBobKey));
    }

    public void configure(Binder binder) {
    }

    @Provides
    Bob provideBob(final Dagny dagny) {
        return new Bob(this){

            @Override
            public String getName() {
                return "A Bob";
            }

            @Override
            public Dagny getDaughter() {
                return dagny;
            }
        };
    }

    @Provides
    @Singleton
    @Sole
    Bob provideSoleBob(final Dagny dagny) {
        return new Bob(this){

            @Override
            public String getName() {
                return "Only Bob";
            }

            @Override
            public Dagny getDaughter() {
                return dagny;
            }
        };
    }

    @Provides
    @Singleton
    Dagny provideDagny() {
        return new Dagny(this){

            @Override
            public int getAge() {
                return 1;
            }
        };
    }

    @Test
    public void testCircularDependency() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            @Provides
            Foo newFoo(final Bar bar) {
                return new Foo(this){

                    @Override
                    public Bar getBar() {
                        return bar;
                    }

                    @Override
                    public int getI() {
                        return 5;
                    }
                };
            }

            @Provides
            Bar newBar(final Foo foo) {
                return new Bar(this){

                    @Override
                    public Foo getFoo() {
                        return foo;
                    }

                    @Override
                    public int getI() {
                        return 10;
                    }
                };
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        Assert.assertEquals((long)5L, (long)foo.getI());
        Assert.assertEquals((long)10L, (long)foo.getBar().getI());
        Assert.assertEquals((long)5L, (long)foo.getBar().getFoo().getI());
    }

    @Test
    public void testMultipleBindingAnnotations() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                @Provides
                @Named(value="A")
                @Blue
                public String provideString() {
                    return "a";
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "more than one annotation annotated with @BindingAnnotation:", "Named", "Blue", "at ProviderMethodsTest$5.provideString(ProviderMethodsTest.java:");
        }
    }

    @Test
    public void testGenericProviderMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ProvideTs<String>(this, "A", "B"){}, new ProvideTs<Integer>(this, Integer.valueOf(1), Integer.valueOf(2)){}});
        Assert.assertEquals((Object)"A", (Object)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"First"))));
        Assert.assertEquals((Object)"B", (Object)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Second"))));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)injector.getInstance(Key.get((Type)Types.setOf(String.class))));
        Assert.assertEquals((long)1L, (long)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"First")))).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"Second")))).intValue());
        Assert.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2), (Object)injector.getInstance(Key.get((Type)Types.setOf(Integer.class))));
    }

    @Test
    public void testAutomaticProviderMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){
            private int next = 1;

            @Provides
            @Named(value="count")
            public Integer provideCount() {
                return this.next++;
            }
        }});
        Assert.assertEquals((long)1L, (long)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"count")))).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"count")))).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"count")))).intValue());
    }

    @Test
    public void testAutomaticProviderMethodsDoNotCauseDoubleBinding() {
        AbstractModule installsSelf = new AbstractModule(this){

            protected void configure() {
                this.install((Module)this);
                this.bind(Integer.class).toInstance((Object)5);
            }

            @Provides
            public String provideString(Integer count) {
                String string = String.valueOf(count);
                return new StringBuilder(1 + String.valueOf(string).length()).append("A").append(string).toString();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{installsSelf});
        Assert.assertEquals((Object)"A5", (Object)injector.getInstance(String.class));
    }

    @Test
    public void testWildcardProviderMethods() {
        ImmutableList strings = ImmutableList.of((Object)"A", (Object)"B", (Object)"C");
        ImmutableList numbers = ImmutableList.of((Object)1, (Object)2, (Object)3);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this, (List)numbers, (List)strings){
            final /* synthetic */ List val$numbers;
            final /* synthetic */ List val$strings;
            {
                this.val$numbers = list;
                this.val$strings = list2;
            }

            protected void configure() {
                Key listOfSupertypesOfInteger = Key.get((Type)Types.listOf((Type)Types.supertypeOf(Integer.class)));
                this.bind(listOfSupertypesOfInteger).toInstance((Object)this.val$numbers);
            }

            @Provides
            public List<? extends CharSequence> provideCharSequences() {
                return this.val$strings;
            }

            @Provides
            public Class<?> provideType() {
                return Float.class;
            }
        }});
        Assert.assertSame((Object)strings, ((HasWildcardInjection)injector.getInstance(HasWildcardInjection.class)).charSequences);
        Assert.assertSame((Object)numbers, ((HasWildcardInjection)injector.getInstance(HasWildcardInjection.class)).numbers);
        Assert.assertSame(Float.class, ((HasWildcardInjection)injector.getInstance(HasWildcardInjection.class)).type);
    }

    @Test
    public void testProviderMethodDependenciesAreExposed() throws Exception {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)50);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"units")).to("Kg");
            }

            @Provides
            @Named(value="weight")
            String provideWeight(Integer count, @Named(value="units") String units) {
                String string = String.valueOf(count);
                return new StringBuilder(String.valueOf(string).length() + String.valueOf(units).length()).append(string).append(units).toString();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        ProviderInstanceBinding binding = (ProviderInstanceBinding)injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"weight")));
        Method method = module.getClass().getDeclaredMethod("provideWeight", Integer.class, String.class);
        InjectionPoint point = new InjectionPoint(TypeLiteral.get(module.getClass()), method, false);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new Dependency(point, Key.get(Integer.class), false, 0), (Object)new Dependency(point, Key.get(String.class, (Annotation)Names.named((String)"units")), false, 1)), (Object)binding.getDependencies());
    }

    @Test
    public void testNonModuleProviderMethods() {
        final Object methodsObject = new Object(this){

            @Provides
            @Named(value="foo")
            String provideFoo() {
                return "foo-value";
            }
        };
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                this.install(ProviderMethodsModule.forObject((Object)methodsObject));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key key = Key.get(String.class, (Annotation)Names.named((String)"foo"));
        Assert.assertEquals((Object)"foo-value", (Object)injector.getInstance(key));
        List elements = Elements.getElements((Module[])new Module[]{module});
        Assert.assertEquals((long)1L, (long)elements.size());
        Element element = (Element)elements.get(0);
        String string = String.valueOf(element);
        Assert.assertTrue((String)new StringBuilder(35 + String.valueOf(string).length()).append(string).append(" instanceof ProviderInstanceBinding").toString(), (boolean)(element instanceof ProviderInstanceBinding));
        ProviderInstanceBinding binding = (ProviderInstanceBinding)element;
        javax.inject.Provider provider = binding.getUserSuppliedProvider();
        Assert.assertTrue((boolean)(provider instanceof ProviderMethod));
        Assert.assertEquals((Object)methodsObject, (Object)((ProviderMethod)provider).getInstance());
        Assert.assertSame((Object)provider, (Object)binding.getProviderInstance());
    }

    @Test
    public void testVoidProviderMethods() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                @Provides
                void provideFoo() {
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Provider methods must return a value. Do not return void.", "at ProviderMethodsTest$14.provideFoo(ProviderMethodsTest.java:");
        }
    }

    @Test
    public void testInjectsJustOneLogger() {
        AtomicReference<Logger> loggerRef = new AtomicReference<Logger>();
        Injector injector = Guice.createInjector((Module[])new Module[]{new FooModule(loggerRef)});
        Assert.assertNull((Object)loggerRef.get());
        injector.getInstance(Integer.class);
        Logger lastLogger = loggerRef.getAndSet(null);
        Assert.assertNotNull((Object)lastLogger);
        injector.getInstance(Integer.class);
        Assert.assertSame((Object)lastLogger, (Object)loggerRef.get());
        Assert.assertEquals((Object)FooModule.class.getName(), (Object)lastLogger.getName());
    }

    @Test
    public void testSpi() throws Exception {
        AbstractModule m1 = new AbstractModule(this){

            @Provides
            @Named(value="foo")
            String provideFoo(Integer dep) {
                return "foo";
            }
        };
        AbstractModule m2 = new AbstractModule(this){

            @Provides
            Integer provideInt(@Named(value="foo") String dep) {
                return 42;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{m1, m2});
        Binding stringBinding = injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"foo")));
        ProvidesMethodBinding stringMethod = (ProvidesMethodBinding)stringBinding.acceptTargetVisitor(new BindingCapturer());
        Assert.assertEquals((Object)m1, (Object)stringMethod.getEnclosingInstance());
        Assert.assertEquals((Object)m1.getClass().getDeclaredMethod("provideFoo", Integer.class), (Object)stringMethod.getMethod());
        Assert.assertEquals((Object)((HasDependencies)stringBinding).getDependencies(), (Object)stringMethod.getDependencies());
        Assert.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"foo")), (Object)stringMethod.getKey());
        Binding intBinding = injector.getBinding(Integer.class);
        ProvidesMethodBinding intMethod = (ProvidesMethodBinding)intBinding.acceptTargetVisitor(new BindingCapturer());
        Assert.assertEquals((Object)m2, (Object)intMethod.getEnclosingInstance());
        Assert.assertEquals((Object)m2.getClass().getDeclaredMethod("provideInt", String.class), (Object)intMethod.getMethod());
        Assert.assertEquals((Object)((HasDependencies)intBinding).getDependencies(), (Object)intMethod.getDependencies());
        Assert.assertEquals((Object)Key.get(Integer.class), (Object)intMethod.getKey());
    }

    @Test
    public void testProvidesMethodVisibility() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new VisibilityModule()});
        Assert.assertEquals((long)42L, (long)((Integer)injector.getInstance(Integer.class)).intValue());
        Assert.assertEquals((long)42L, (long)((Long)injector.getInstance(Long.class)));
        Assert.assertEquals((double)42.0, (double)((Double)injector.getInstance(Double.class)), (double)0.0);
        Assert.assertEquals((float)42.0f, (float)((Float)injector.getInstance(Float.class)).floatValue(), (float)0.0f);
    }

    @Test
    public void testProvidesMethodInheritenceHierarchy() {
        try {
            Guice.createInjector((Module[])new Module[]{new Sub1Module(), new Sub2Module()});
            Assert.fail((String)"Expected injector creation failure");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Long was bound multiple times.", "Integer was bound multiple times.");
        }
    }

    @Test
    public void testProvidesMethodsDefinedInSuperClass() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Sub1Module()});
        Assert.assertEquals((long)42L, (long)((Integer)injector.getInstance(Integer.class)).intValue());
        Assert.assertEquals((long)42L, (long)((Long)injector.getInstance(Long.class)));
        Assert.assertEquals((double)42.0, (double)((Double)injector.getInstance(Double.class)), (double)0.0);
    }

    @Test
    public void testShareFastClass() {
        Assume.assumeTrue((InternalFlags.isBytecodeGenEnabled() && InternalFlags.getCustomClassLoadingOption() != InternalFlags.CustomClassLoadingOption.CHILD ? 1 : 0) != 0);
        CallerInspecterModule module = new CallerInspecterModule();
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{module});
        Assert.assertEquals((Object)module.fooCallerClass, (Object)module.barCallerClass);
        Assert.assertTrue((boolean)module.fooCallerClass.contains("$$FastClassByGuice$$"));
    }

    @Test
    public void testShareFastClassWithSuperClass() {
        Assume.assumeTrue((InternalFlags.isBytecodeGenEnabled() && InternalFlags.getCustomClassLoadingOption() != InternalFlags.CustomClassLoadingOption.CHILD ? 1 : 0) != 0);
        CallerInspecterSubClassModule module = new CallerInspecterSubClassModule();
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{module});
        Assert.assertEquals((String)"Expected provider methods in the same class to share fastclass classes", (Object)module.fooCallerClass, (Object)module.barCallerClass);
        Assert.assertFalse((String)"Did not expect provider methods in the subclasses to share fastclass classes with their parent classes", (boolean)module.bazCallerClass.equals(module.barCallerClass));
    }

    @Test
    public void testOverrideProviderMethod_overrideHasProvides() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                @Provides
                Number providerMethod() {
                    return 2.0;
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.providerMethod()", "overridden by: ProviderMethodsTest$1SubClassModule.providerMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_overrideHasProvides_withNewAnnotation() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                @Provides
                @Named(value="foo")
                Number providerMethod() {
                    return 2.0;
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.providerMethod()", "overridden by: ProviderMethodsTest$2SubClassModule.providerMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_overrideDoesntHaveProvides() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                Number providerMethod() {
                    return 2.0;
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.providerMethod()", "overridden by: ProviderMethodsTest$3SubClassModule.providerMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_overrideDoesntHaveProvides_withNewAnnotation() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                @Named(value="foo")
                Number providerMethod() {
                    return 2.0;
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.providerMethod()", "overridden by: ProviderMethodsTest$4SubClassModule.providerMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_covariantOverrideDoesntHaveProvides() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                Double providerMethod() {
                    return 2.0;
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.providerMethod()", "overridden by: ProviderMethodsTest$5SubClassModule.providerMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_covariantOverrideHasProvides() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                @Provides
                Double providerMethod() {
                    return 2.0;
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.providerMethod()", "overridden by: ProviderMethodsTest$6SubClassModule.providerMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_fakeOverridePrivateMethod() {
        class SubClassModule
        extends SuperClassModule {
            SubClassModule(ProviderMethodsTest this$0) {
            }

            String privateProviderMethod() {
                return "sub";
            }
        }
        Assert.assertEquals((Object)"hello", (Object)Guice.createInjector((Module[])new Module[]{new SubClassModule(this)}).getInstance(String.class));
    }

    @Test
    public void testOverrideProviderMethod_subclassRawTypes_returnType() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                List annotatedGenericProviderMethod() {
                    return super.annotatedGenericProviderMethod();
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.annotatedGenericProviderMethod()", "overridden by: ProviderMethodsTest$8SubClassModule.annotatedGenericProviderMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_subclassRawTypes_parameterType() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                Collection<String> annotatedGenericParameterProviderMethod(List foo) {
                    return super.annotatedGenericParameterProviderMethod(foo);
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.annotatedGenericParameterProviderMethod()", "overridden by: ProviderMethodsTest$9SubClassModule.annotatedGenericParameterProviderMethod()");
        }
    }

    @Test
    public void testOverrideProviderMethod_superclassRawTypes_returnType() {
        try {
            class SubClassModule
            extends SuperClassModule {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                List<String> rawProvider(List<String> f) {
                    return f;
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$SuperClassModule.rawProvider()", "overridden by: ProviderMethodsTest$10SubClassModule.rawProvider()");
        }
    }

    @Test
    public void testOverrideProviderMethod_erasureBasedOverrides() {
        try {
            class SubClassModule
            extends GenericSuperModule<Integer> {
                SubClassModule(ProviderMethodsTest this$0) {
                }

                @Override
                String provide(Integer thing) {
                    return thing.toString();
                }

                protected void configure() {
                    this.bind(Integer.class).toInstance((Object)3);
                }
            }
            Guice.createInjector((Module[])new Module[]{new SubClassModule(this)});
            Assert.fail();
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "Overriding @Provides methods is not allowed.", "@Provides method: ProviderMethodsTest$GenericSuperModule.provide()", "overridden by: ProviderMethodsTest$11SubClassModule.provide()");
        }
    }

    @Test
    public void testOverrideProviderMethod_increasedVisibility() {
        Assert.assertEquals((Object)"foo", (Object)Guice.createInjector((Module[])new Module[]{new ExposedSub()}).getInstance(String.class));
    }

    @Test
    public void testIgnoreSyntheticBridgeMethods() {
        Guice.createInjector((Module[])new Module[]{new ModuleImpl()});
    }

    @Test
    public void testScopedProviderMethodThrowsException() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            @Provides
            @Singleton
            int provideInt() {
                throw new RuntimeException("boom");
            }
        }});
        Provider intProvider = injector.getProvider(Integer.class);
        try {
            intProvider.get();
            Assert.fail();
        }
        catch (ProvisionException pe) {
            Asserts.assertContains(pe.getMessage(), "RuntimeException: boom", "provideInt");
        }
    }

    @Test
    public void testNullability() throws Exception {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toProvider(Providers.of(null));
            }

            @Provides
            Integer fail(String foo) {
                return 1;
            }

            @Provides
            Long succeed(@Nullable String foo) {
                return 2L;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        InjectionPoint fooPoint = InjectionPoint.forMethod((Method)module.getClass().getDeclaredMethod("fail", String.class), (TypeLiteral)TypeLiteral.get(module.getClass()));
        Dependency fooDependency = (Dependency)Iterables.getOnlyElement((Iterable)fooPoint.getDependencies());
        this.runNullableTest(injector, fooDependency, (Module)module);
        injector.getInstance(Long.class);
    }

    @Test
    public void testModuleBindings() throws Exception {
        AbstractModule module = new AbstractModule(this){

            @Provides
            Integer fail() {
                return 1;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Assert.assertEquals((long)1L, (long)((Integer)injector.getInstance(Integer.class)).intValue());
        ProviderInstanceBinding injectorBinding = (ProviderInstanceBinding)injector.getBinding(Integer.class);
        Assert.assertEquals((long)1L, (long)((Integer)injectorBinding.getUserSuppliedProvider().get()).intValue());
        ProviderInstanceBinding moduleBinding = (ProviderInstanceBinding)Iterables.getOnlyElement((Iterable)Elements.getElements((Module[])new Module[]{module}));
        try {
            moduleBinding.getUserSuppliedProvider().get();
            Assert.fail();
        }
        catch (IllegalStateException ise) {
            Assert.assertEquals((Object)"This Provider cannot be used until the Injector has been created.", (Object)ise.getMessage());
        }
    }

    @Test
    public void testDeduplicateProviderMethodsBindings_sameInstance() {
        DeduplicateModule module = new DeduplicateModule();
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{module, module});
    }

    @Test
    public void testDeduplicateProviderMethodsBindings_differentInstances() {
        try {
            Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new DeduplicateModule(), new DeduplicateModule()});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "String was bound multiple times.");
        }
    }

    @Test
    public void testDeduplicateProviderMethodsBindings_sameInstance_staticMethod() {
        DeduplicateStaticModule module = new DeduplicateStaticModule();
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{module, module});
    }

    @Test
    public void testDeduplicateProviderMethodsBindings_differentInstances_staticMethod() {
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new DeduplicateStaticModule(), new DeduplicateStaticModule()});
    }

    private void runNullableTest(Injector injector, Dependency<?> dependency, Module module) {
        switch (InternalFlags.getNullableProvidesOption()) {
            case ERROR: {
                this.validateNullableFails(injector, module);
                break;
            }
            case IGNORE: {
                this.validateNullableIgnored(injector);
                break;
            }
            case WARN: {
                this.validateNullableWarns(injector, dependency);
            }
        }
    }

    private void validateNullableFails(Injector injector, Module module) {
        try {
            injector.getInstance(Integer.class);
            Assert.fail();
        }
        catch (ProvisionException expected) {
            String moduleName = module.getClass().getName().replace("com.google.inject.spi.", "");
            Asserts.assertContains(expected.getMessage(), new StringBuilder(39 + String.valueOf(moduleName).length()).append("null returned by binding at ").append(moduleName).append(".configure(").toString(), new StringBuilder(35 + String.valueOf(moduleName).length()).append("but the 1st parameter foo of ").append(moduleName).append(".fail(").toString(), "is not @Nullable", "for 1st parameter", "while locating Integer");
            Assert.assertEquals((long)1L, (long)expected.getErrorMessages().size());
        }
    }

    private void validateNullableIgnored(Injector injector) {
        injector.getInstance(Integer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateNullableWarns(Injector injector, Dependency<?> dependency) {
        final ArrayList logRecords = Lists.newArrayList();
        Handler fakeHandler = new Handler(this){

            @Override
            public void publish(LogRecord logRecord) {
                logRecords.add(logRecord);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        Logger.getLogger(Guice.class.getName()).addHandler(fakeHandler);
        try {
            injector.getInstance(Integer.class);
            LogRecord record = (LogRecord)Iterables.getOnlyElement((Iterable)logRecords);
            Assert.assertEquals((Object)"Guice injected null into {0} (a {1}), please mark it @Nullable. Use -Dguice_check_nullable_provides_params=ERROR to turn this into an error.", (Object)record.getMessage());
            Assert.assertEquals((Object)Errors.convert((Object)dependency.getKey()), (Object)record.getParameters()[1]);
        }
        finally {
            Logger.getLogger(Guice.class.getName()).removeHandler(fakeHandler);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Nullable {
    }

    static final class DeduplicateStaticModule
    extends AbstractModule {
        DeduplicateStaticModule() {
        }

        @Provides
        static String provideString() {
            return "";
        }
    }

    static final class DeduplicateModule
    extends AbstractModule {
        DeduplicateModule() {
        }

        @Provides
        String provideString() {
            return "";
        }
    }

    static class ModuleImpl
    extends AbstractModule
    implements ProviderInterface<String> {
        ModuleImpl() {
        }

        @Override
        @Provides
        public String getT() {
            return "string";
        }

        @Provides
        public Object getObject() {
            return new Object();
        }
    }

    static interface ProviderInterface<T> {
        public T getT();
    }

    public static class ExposedSub
    extends RestrictedSuper {
    }

    static class RestrictedSuper
    extends AbstractModule {
        RestrictedSuper() {
        }

        @Provides
        public String provideFoo() {
            return "foo";
        }
    }

    static abstract class GenericSuperModule<T>
    extends AbstractModule {
        GenericSuperModule() {
        }

        @Provides
        String provide(T thing) {
            return thing.toString();
        }
    }

    static class SuperClassModule
    extends AbstractModule {
        SuperClassModule() {
        }

        @Provides
        Number providerMethod() {
            return 1.0;
        }

        @Provides
        @Named(value="rawlist")
        List rawProvider(@Named(value="list") List<String> f) {
            return f;
        }

        @Provides
        @Named(value="unrawlist")
        List<String> rawParameterProvider(@Named(value="rawlist") List f) {
            return f;
        }

        @Provides
        @Named(value="list")
        List<String> annotatedGenericProviderMethod() {
            return new ArrayList<String>();
        }

        @Provides
        @Named(value="collection")
        Collection<String> annotatedGenericParameterProviderMethod(@Named(value="list") List<String> foo) {
            return foo;
        }

        @Provides
        private String privateProviderMethod() {
            return "hello";
        }
    }

    private static class CallerInspecterSubClassModule
    extends CallerInspecterModule {
        String bazCallerClass;

        private CallerInspecterSubClassModule() {
        }

        protected void configure() {
        }

        @Provides
        @Singleton
        Double baz() {
            this.bazCallerClass = new Exception().getStackTrace()[1].getClassName();
            return 42.0;
        }
    }

    private static class CallerInspecterModule
    extends AbstractModule {
        String barCallerClass = "not_set_bar";
        String fooCallerClass = "not_set_foo";

        private CallerInspecterModule() {
        }

        @Provides
        @Singleton
        Integer foo() {
            this.fooCallerClass = new Exception().getStackTrace()[1].getClassName();
            return 42;
        }

        @Provides
        @Singleton
        Long bar() {
            this.barCallerClass = new Exception().getStackTrace()[1].getClassName();
            return 42L;
        }
    }

    private static class Sub2Module
    extends BaseModule {
        private Sub2Module() {
        }

        @Provides
        Float quux() {
            return Float.valueOf(42.0f);
        }
    }

    private static class Sub1Module
    extends BaseModule {
        private Sub1Module() {
        }

        @Provides
        Double baz() {
            return 42.0;
        }
    }

    private static class BaseModule
    extends AbstractModule {
        private BaseModule() {
        }

        @Provides
        Integer foo() {
            return 42;
        }

        @Provides
        Long bar() {
            return 42L;
        }
    }

    private static class VisibilityModule
    extends AbstractModule {
        private VisibilityModule() {
        }

        @Provides
        Integer foo() {
            return 42;
        }

        @Provides
        private Long bar() {
            return 42L;
        }

        @Provides
        protected Double baz() {
            return 42.0;
        }

        @Provides
        public Float quux() {
            return Float.valueOf(42.0f);
        }
    }

    private static class BindingCapturer<T>
    extends DefaultBindingTargetVisitor<T, ProvidesMethodBinding<T>>
    implements ProvidesMethodTargetVisitor<T, ProvidesMethodBinding<T>> {
        private BindingCapturer() {
        }

        public ProvidesMethodBinding<T> visit(ProvidesMethodBinding<? extends T> providesMethodBinding) {
            return providesMethodBinding;
        }

        protected ProvidesMethodBinding<T> visitOther(Binding<? extends T> binding) {
            String string = String.valueOf(binding);
            throw new IllegalStateException(new StringBuilder(21 + String.valueOf(string).length()).append("unexpected visit of: ").append(string).toString());
        }
    }

    private static class FooModule
    extends AbstractModule {
        private final AtomicReference<Logger> loggerRef;

        public FooModule(AtomicReference<Logger> loggerRef) {
            this.loggerRef = loggerRef;
        }

        @Provides
        Integer foo(Logger logger) {
            this.loggerRef.set(logger);
            return 42;
        }
    }

    static class HasWildcardInjection {
        @Inject
        List<? extends CharSequence> charSequences;
        @Inject
        List<? super Integer> numbers;
        @Inject
        Class<?> type;

        HasWildcardInjection() {
        }
    }

    abstract class ProvideTs<T>
    extends AbstractModule {
        final T first;
        final T second;

        protected ProvideTs(ProviderMethodsTest this$0, T first, T second) {
            this.first = first;
            this.second = second;
        }

        @Named(value="First")
        @Provides
        T provideFirst() {
            return this.first;
        }

        @Named(value="Second")
        @Provides
        T provideSecond() {
            return this.second;
        }

        @Provides
        Set<T> provideBoth(@Named(value="First") T first, @Named(value="Second") T second) {
            return ImmutableSet.of(first, second);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Blue {
    }

    public static interface Bar {
        public Foo getFoo();

        public int getI();
    }

    public static interface Foo {
        public Bar getBar();

        public int getI();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface Sole {
    }

    static interface Dagny {
        public int getAge();
    }

    static interface Bob {
        public String getName();

        public Dagny getDaughter();
    }
}

