/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.common.base.Objects;
import com.google.common.testing.EqualsTester;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import javax.inject.Inject;
import junit.framework.TestCase;

public class ProvidersTest
extends TestCase {
    public void testOfInstance() {
        String foo = "foo";
        Provider p = Providers.of((Object)foo);
        ProvidersTest.assertSame((Object)foo, (Object)p.get());
        ProvidersTest.assertSame((Object)foo, (Object)p.get());
    }

    public void testOfNull() {
        Provider p = Providers.of(null);
        ProvidersTest.assertNull((Object)p.get());
    }

    public void testOfEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{Providers.of(null), Providers.of(null)}).addEqualityGroup(new Object[]{Providers.of((Object)"Hello"), Providers.of((Object)"Hello")}).testEquals();
    }

    public void testGuicifyEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{Providers.guicify((javax.inject.Provider)new JavaxProvider(10)), Providers.guicify((javax.inject.Provider)new JavaxProvider(10))}).addEqualityGroup(new Object[]{Providers.guicify((javax.inject.Provider)new JavaxProvider(11)), Providers.guicify((javax.inject.Provider)new JavaxProvider(11))}).addEqualityGroup(new Object[]{Providers.guicify((javax.inject.Provider)new JavaxProviderWithDependencies()), Providers.guicify((javax.inject.Provider)new JavaxProviderWithDependencies())}).testEquals();
    }

    private static class JavaxProviderWithDependencies
    implements javax.inject.Provider<Integer> {
        private int value;

        private JavaxProviderWithDependencies() {
        }

        @Inject
        void setValue(int value) {
            this.value = value;
        }

        public Integer get() {
            return this.value;
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof JavaxProviderWithDependencies;
        }
    }

    private static class JavaxProvider
    implements javax.inject.Provider<Integer> {
        private final int value;

        public JavaxProvider(int value) {
            this.value = value;
        }

        public Integer get() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        public boolean equals(Object obj) {
            return obj instanceof JavaxProvider && this.value == ((JavaxProvider)obj).value;
        }
    }
}

