/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.guice;

import aQute.bnd.main.bnd;
import com.googlecode.guice.bundle.OSGiTestActivator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

@RunWith(value=JUnit4.class)
public class OSGiContainerTest {
    static final String VERSION = System.getProperty("version", "snapshot");
    static final String BUILD_DIR = System.getProperty("build.dir", "build");
    static final String BUILD_DIST_DIR = String.valueOf(BUILD_DIR).concat("/dist");
    static final String BUILD_TEST_DIR = String.valueOf(BUILD_DIR).concat("/test");
    static final String GUICE_JAR;
    static final String AOPALLIANCE_JAR;
    static final String JAVAX_INJECT_JAR;
    static final String GUAVA_JAR;

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((String)this.failMsg(), (boolean)new File(BUILD_DIR).isDirectory());
        Assume.assumeTrue((String)this.failMsg(), (boolean)new File(GUICE_JAR).isFile());
        Assume.assumeTrue((String)this.failMsg(), (boolean)new File(AOPALLIANCE_JAR).isFile());
        Assume.assumeTrue((String)this.failMsg(), (boolean)new File(JAVAX_INJECT_JAR).isFile());
        Assume.assumeTrue((String)this.failMsg(), (boolean)new File(GUAVA_JAR).isFile());
        Properties instructions = new Properties();
        instructions.setProperty("Export-Package", "org.aopalliance.*");
        OSGiContainerTest.buildBundle("aopalliance", instructions, AOPALLIANCE_JAR);
        instructions.clear();
        instructions.setProperty("Export-Package", "javax.inject.*");
        OSGiContainerTest.buildBundle("javax.inject", instructions, JAVAX_INJECT_JAR);
        instructions.clear();
        instructions.setProperty("Export-Package", "com.google.common.*");
        instructions.setProperty("Import-Package", "*;resolution:=optional");
        OSGiContainerTest.buildBundle("guava", instructions, GUAVA_JAR);
        instructions.clear();
        instructions.setProperty("Import-Package", "org.osgi.framework,org.aopalliance.intercept,com.google.inject(|.binder|.matcher|.name)");
        instructions.setProperty("Bundle-Activator", OSGiTestActivator.class.getName());
        instructions.setProperty("Private-Package", OSGiTestActivator.class.getPackage().getName());
        OSGiContainerTest.buildBundle("osgitests", instructions, BUILD_TEST_DIR);
        instructions.clear();
    }

    private static void buildBundle(String name, Properties instructions, String classpath) throws IOException {
        String string = BUILD_TEST_DIR;
        String bndFileName = new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(name).length()).append(string).append('/').append(name).append(".bnd").toString();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(bndFileName));
        instructions.store(os, "BND instructions");
        ((OutputStream)os).close();
        bnd.main((String[])new String[]{"-failok", "build", "-classpath", classpath, bndFileName});
    }

    private String failMsg() {
        return "This test may fail if it is not run from ant, or if it is not run after ant has compiled & built jars. This is because the test is validating that the Guice jar is properly setup to load in an OSGi container";
    }

    @Test
    public void testGuiceWorksInOSGiContainer() throws Throwable {
        Properties properties = new Properties();
        properties.setProperty("org.osgi.framework.storage", String.valueOf(BUILD_TEST_DIR).concat("/bundle.cache"));
        properties.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
        for (FrameworkFactory frameworkFactory : ServiceLoader.load(FrameworkFactory.class)) {
            Framework framework = frameworkFactory.newFramework((Map)properties);
            framework.start();
            BundleContext systemContext = framework.getBundleContext();
            String string = BUILD_TEST_DIR;
            systemContext.installBundle(new StringBuilder(31 + String.valueOf(string).length()).append("reference:file:").append(string).append("/aopalliance.jar").toString());
            string = BUILD_TEST_DIR;
            systemContext.installBundle(new StringBuilder(32 + String.valueOf(string).length()).append("reference:file:").append(string).append("/javax.inject.jar").toString());
            string = BUILD_TEST_DIR;
            systemContext.installBundle(new StringBuilder(25 + String.valueOf(string).length()).append("reference:file:").append(string).append("/guava.jar").toString());
            String string2 = String.valueOf(GUICE_JAR);
            systemContext.installBundle(string2.length() != 0 ? "reference:file:".concat(string2) : new String("reference:file:"));
            string = BUILD_TEST_DIR;
            systemContext.installBundle(new StringBuilder(29 + String.valueOf(string).length()).append("reference:file:").append(string).append("/osgitests.jar").toString()).start();
            framework.stop();
        }
    }

    static {
        String string = BUILD_DIST_DIR;
        String string2 = VERSION;
        GUICE_JAR = new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/guice-").append(string2).append(".jar").toString();
        AOPALLIANCE_JAR = System.getProperty("aopalliance.jar", "lib/aopalliance.jar");
        JAVAX_INJECT_JAR = System.getProperty("javax.inject.jar", "lib/javax.inject.jar");
        GUAVA_JAR = System.getProperty("guava.jar", "lib/guava-25.1-android.jar");
    }
}

