/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.internal.Annotations;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.List;
import junit.framework.TestCase;

public class ImplicitBindingTest
extends TestCase {
    public void testCircularDependency() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        Foo foo = (Foo)injector.getInstance(Foo.class);
        ImplicitBindingTest.assertSame((Object)foo, (Object)foo.bar.foo);
    }

    public void testDefaultImplementation() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        I i = (I)injector.getInstance(I.class);
        i.go();
    }

    public void testDefaultProvider() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        Provided provided = (Provided)injector.getInstance(Provided.class);
        provided.go();
    }

    public void testBindingOverridesImplementedBy() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(I.class).to(AlternateImpl.class);
            }
        }});
        ImplicitBindingTest.assertEquals(AlternateImpl.class, ((I)injector.getInstance(I.class)).getClass());
    }

    public void testNoImplicitBindingIsCreatedForAnnotatedKeys() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(Key.get(I.class, (Annotation)Names.named((String)"i")));
            ImplicitBindingTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), String.format("No implementation for ImplicitBindingTest$I annotated with @Named(%s) was bound.", Annotations.memberValueString((String)"value", (Object)"i")));
        }
    }

    public void testCircularJitBindingsLeaveNoResidue() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Valid.class);
                this.bind(Valid2.class);
            }
        }});
        Binding v1 = injector.getBinding(Valid.class);
        Binding v2 = injector.getBinding(Valid2.class);
        Binding jv1 = injector.getBinding(JitValid.class);
        Binding jv2 = injector.getBinding(JitValid2.class);
        ImplicitBindingTest.assertFailure(injector, Invalid.class);
        ImplicitBindingTest.assertFailure(injector, InvalidLinked.class);
        ImplicitBindingTest.assertFailure(injector, InvalidLinkedImpl.class);
        ImplicitBindingTest.assertFailure(injector, InvalidLinked2.class);
        ImplicitBindingTest.assertFailure(injector, InvalidLinked2Impl.class);
        ImplicitBindingTest.assertFailure(injector, InvalidProvidedBy.class);
        ImplicitBindingTest.assertFailure(injector, InvalidProvidedByProvider.class);
        ImplicitBindingTest.assertFailure(injector, InvalidProvidedBy2.class);
        ImplicitBindingTest.assertFailure(injector, InvalidProvidedBy2Provider.class);
        ImplicitBindingTest.assertFailure(injector, Invalid2.class);
        ImplicitBindingTest.assertSame((Object)v1, (Object)injector.getBinding(Valid.class));
        ImplicitBindingTest.assertSame((Object)v2, (Object)injector.getBinding(Valid2.class));
        ImplicitBindingTest.assertSame((Object)jv1, (Object)injector.getBinding(JitValid.class));
        ImplicitBindingTest.assertSame((Object)jv2, (Object)injector.getBinding(JitValid2.class));
    }

    private static void assertFailure(Injector injector, Class<?> clazz) {
        try {
            injector.getBinding(clazz);
            ImplicitBindingTest.fail((String)("Shouldn't have been able to get binding of: " + clazz));
        }
        catch (ConfigurationException expected) {
            Message msg = (Message)Iterables.getOnlyElement((Iterable)expected.getErrorMessages());
            Asserts.assertContains(msg.getMessage(), "No implementation for " + InvalidInterface.class.getName() + " was bound.");
            List sources = msg.getSources();
            ImplicitBindingTest.assertEquals((String)Key.get(clazz).toString(), (String)sources.get(0).toString());
            Asserts.assertContains(sources.get(sources.size() - 1).toString(), Key.get(InvalidInterface.class).toString());
        }
    }

    public void testInstancesRequestingProvidersForThemselvesWithChildInjectors() {
        AbstractModule testModule = new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider(TestStringProvider.class);
            }
        };
        Injector parentSetupRootInjector = Guice.createInjector((Module[])new Module[]{testModule});
        Injector parentSetupChildInjector = parentSetupRootInjector.createChildInjector(new Module[0]);
        ImplicitBindingTest.assertEquals((String)"This is to verify it all works", (String)((RequiresProviderForSelfWithOtherType)parentSetupChildInjector.getInstance(RequiresProviderForSelfWithOtherType.class)).getValue());
        Injector childSetupRootInjector = Guice.createInjector((Module[])new Module[0]);
        Injector childSetupChildInjector = childSetupRootInjector.createChildInjector(new Module[]{testModule});
        ImplicitBindingTest.assertEquals((String)"This is to verify it all works", (String)((RequiresProviderForSelfWithOtherType)childSetupChildInjector.getInstance(RequiresProviderForSelfWithOtherType.class)).getValue());
    }

    public void testRecursiveJitBindingsCleanupCorrectly() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            injector.getInstance(A.class);
            ImplicitBindingTest.fail((String)"Expected failure");
        }
        catch (ConfigurationException expected) {
            Truth.assertThat((Iterable)expected.getErrorMessages()).hasSize(1);
            Asserts.assertContains(expected.getMessage(), "No injectable constructor for type ImplicitBindingTest$D.");
        }
        ImplicitBindingTest.assertNull((Object)injector.getExistingBinding(Key.get(A.class)));
        ImplicitBindingTest.assertNull((Object)injector.getExistingBinding(Key.get(B.class)));
        ImplicitBindingTest.assertNull((Object)injector.getExistingBinding(Key.get(C.class)));
        ImplicitBindingTest.assertNull((Object)injector.getExistingBinding(Key.get(D.class)));
        ImplicitBindingTest.assertNotNull((Object)injector.getBinding(Key.get(E.class)));
    }

    public void testProvidedByNonEmptyEnum() {
        NonEmptyEnum cardSuit = (NonEmptyEnum)((Object)Guice.createInjector((Module[])new Module[0]).getInstance(NonEmptyEnum.class));
        ImplicitBindingTest.assertEquals((Object)((Object)NonEmptyEnum.HEARTS), (Object)((Object)cardSuit));
    }

    public void testProvidedByEmptyEnum() {
        EmptyEnum emptyEnumValue = (EmptyEnum)((Object)Guice.createInjector((Module[])new Module[0]).getInstance(EmptyEnum.class));
        ImplicitBindingTest.assertNull((Object)((Object)emptyEnumValue));
    }

    public void testImplementedByEnum() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        try {
            injector.getInstance(EnumWithImplementedBy.class);
            ImplicitBindingTest.fail((String)"Expected failure");
        }
        catch (ConfigurationException expected) {
            Message msg = (Message)Iterables.getOnlyElement((Iterable)expected.getErrorMessages());
            Asserts.assertContains(msg.getMessage(), "No implementation for " + EnumWithImplementedBy.class.getName() + " was bound.");
        }
    }

    public void testImplicitJdkBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ImplicitBindingTest.assertEquals((String)"", (String)((String)injector.getInstance(String.class)));
        if (Double.parseDouble(StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()) < 17.0) {
            ImplicitBindingTest.assertNotNull((Object)injector.getInstance(InetAddress.class));
        }
    }

    private static class EnumWithImplementedByEnum {
        private EnumWithImplementedByEnum() {
        }
    }

    @ImplementedBy(value=EnumWithImplementedByEnum.class)
    static enum EnumWithImplementedBy {

    }

    static final class EmptyEnumProvider
    implements Provider<EmptyEnum> {
        EmptyEnumProvider() {
        }

        public EmptyEnum get() {
            return null;
        }
    }

    @ProvidedBy(value=EmptyEnumProvider.class)
    static enum EmptyEnum {

    }

    static final class NonEmptyEnumProvider
    implements Provider<NonEmptyEnum> {
        NonEmptyEnumProvider() {
        }

        public NonEmptyEnum get() {
            return NonEmptyEnum.HEARTS;
        }
    }

    @ProvidedBy(value=NonEmptyEnumProvider.class)
    static enum NonEmptyEnum {
        HEARTS,
        DIAMONDS,
        CLUBS,
        SPADES;

    }

    static class E {
        E() {
        }
    }

    static class D {
        public D(int i) {
        }
    }

    static class C {
        @Inject
        public C(A a, D d, E e) {
        }
    }

    static class B {
        @Inject
        public B(C c, A a) {
        }
    }

    static class A {
        @Inject
        public A(B b) {
        }
    }

    static class RequiresProviderForSelfWithOtherType {
        private final Provider<RequiresProviderForSelfWithOtherType> selfProvider;
        private final String providedStringValue;

        @Inject
        RequiresProviderForSelfWithOtherType(String providedStringValue, Provider<RequiresProviderForSelfWithOtherType> selfProvider) {
            this.providedStringValue = providedStringValue;
            this.selfProvider = selfProvider;
        }

        public String getValue() {
            this.selfProvider.get();
            return this.providedStringValue;
        }
    }

    static class TestStringProvider
    implements Provider<String> {
        static final String TEST_VALUE = "This is to verify it all works";

        TestStringProvider() {
        }

        public String get() {
            return TEST_VALUE;
        }
    }

    static class JitValid2 {
        JitValid2() {
        }
    }

    static class JitValid {
        @Inject
        JitValid2 a;

        JitValid() {
        }
    }

    static class Valid2 {
        Valid2() {
        }
    }

    static class Valid {
        @Inject
        Valid2 a;

        Valid() {
        }
    }

    static interface InvalidInterface {
    }

    static class Invalid2 {
        @Inject
        Invalid a;

        Invalid2() {
        }
    }

    static class InvalidProvidedBy2Provider
    implements Provider<InvalidProvidedBy2> {
        @Inject
        Invalid2 a;

        InvalidProvidedBy2Provider() {
        }

        public InvalidProvidedBy2 get() {
            return null;
        }
    }

    @ProvidedBy(value=InvalidProvidedBy2Provider.class)
    static interface InvalidProvidedBy2 {
    }

    static class InvalidProvidedByProvider
    implements Provider<InvalidProvidedBy> {
        @Inject
        InvalidProvidedBy2 a;

        InvalidProvidedByProvider() {
        }

        public InvalidProvidedBy get() {
            return null;
        }
    }

    @ProvidedBy(value=InvalidProvidedByProvider.class)
    static interface InvalidProvidedBy {
    }

    static class InvalidLinked2Impl
    implements InvalidLinked2 {
        @Inject
        InvalidLinked2Impl(Invalid2 a) {
        }
    }

    @ImplementedBy(value=InvalidLinked2Impl.class)
    static interface InvalidLinked2 {
    }

    static class InvalidLinkedImpl
    implements InvalidLinked {
        @Inject
        InvalidLinked2 a;

        InvalidLinkedImpl() {
        }
    }

    @ImplementedBy(value=InvalidLinkedImpl.class)
    static interface InvalidLinked {
    }

    static class Invalid {
        @Inject
        Valid a;
        @Inject
        JitValid b;
        @Inject
        InvalidProvidedBy c;

        @Inject
        Invalid(InvalidLinked a) {
        }

        @Inject
        void foo(InvalidInterface a) {
        }
    }

    static class ProvidedProvider
    implements Provider<Provided> {
        ProvidedProvider() {
        }

        public Provided get() {
            return new Provided(){

                @Override
                public void go() {
                }
            };
        }
    }

    @ProvidedBy(value=ProvidedProvider.class)
    static interface Provided {
        public void go();
    }

    static class AlternateImpl
    implements I {
        AlternateImpl() {
        }

        @Override
        public void go() {
        }
    }

    static class IImpl
    implements I {
        IImpl() {
        }

        @Override
        public void go() {
        }
    }

    @ImplementedBy(value=IImpl.class)
    static interface I {
        public void go();
    }

    static class Bar {
        final Foo foo;

        @Inject
        public Bar(Foo foo) {
            this.foo = foo;
        }
    }

    static class Foo {
        @Inject
        Bar bar;

        Foo() {
        }
    }
}

