/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class InjectorTest
extends TestCase {
    public void testToStringDoesNotInfinitelyRecurse() {
        Injector injector = Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[0]);
        injector.toString();
        injector.getBinding(Injector.class).toString();
    }

    public void testProviderMethods() throws CreationException {
        final SampleSingleton singleton = new SampleSingleton();
        final SampleSingleton other = new SampleSingleton();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(SampleSingleton.class).toInstance((Object)singleton);
                this.bind(SampleSingleton.class).annotatedWith(Other.class).toInstance((Object)other);
            }
        }});
        InjectorTest.assertSame((Object)singleton, (Object)injector.getInstance(Key.get(SampleSingleton.class)));
        InjectorTest.assertSame((Object)singleton, (Object)injector.getInstance(SampleSingleton.class));
        InjectorTest.assertSame((Object)other, (Object)injector.getInstance(Key.get(SampleSingleton.class, Other.class)));
    }

    public void testInjection() throws CreationException {
        Injector injector = this.createFooInjector();
        Foo foo = (Foo)injector.getInstance(Foo.class);
        InjectorTest.assertEquals((String)"test", (String)foo.s);
        InjectorTest.assertEquals((String)"test", (String)foo.bar.getTee().getS());
        InjectorTest.assertSame((Object)foo.bar, (Object)foo.copy);
        InjectorTest.assertEquals((int)5, (int)foo.i);
        InjectorTest.assertEquals((int)5, (int)foo.bar.getI());
        InjectorTest.assertSame((Object)foo.bar, (Object)foo.bar.getTee().getBar());
    }

    private Injector createFooInjector() throws CreationException {
        return Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Bar.class).to(BarImpl.class);
                this.bind(Tee.class).to(TeeImpl.class);
                this.bindConstant().annotatedWith(S.class).to("test");
                this.bindConstant().annotatedWith(I.class).to(5);
            }
        }});
    }

    public void testGetInstance() throws CreationException {
        Injector injector = this.createFooInjector();
        Bar bar = (Bar)injector.getInstance(Key.get(Bar.class));
        InjectorTest.assertEquals((String)"test", (String)bar.getTee().getS());
        InjectorTest.assertEquals((int)5, (int)bar.getI());
    }

    public void testIntAndIntegerAreInterchangeable() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(I.class).to(5);
            }
        }});
        IntegerWrapper iw = (IntegerWrapper)injector.getInstance(IntegerWrapper.class);
        InjectorTest.assertEquals((int)5, (int)iw.i);
    }

    public void testInjectorApiIsNotSerializable() throws IOException {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        Asserts.assertNotSerializable(injector);
        Asserts.assertNotSerializable(injector.getProvider(String.class));
        Asserts.assertNotSerializable(injector.getBinding(String.class));
        for (Binding binding : injector.getBindings().values()) {
            Asserts.assertNotSerializable(binding);
        }
    }

    public void testInjectStatics() throws CreationException {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(S.class).to("test");
                this.bindConstant().annotatedWith(I.class).to(5);
                this.requestStaticInjection(new Class[]{Static.class});
            }
        }});
        InjectorTest.assertEquals((String)"test", (String)Static.s);
        InjectorTest.assertEquals((int)5, (int)Static.i);
    }

    public void testInjectStaticInterface() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.requestStaticInjection(new Class[]{Interface.class});
                }
            }});
            InjectorTest.fail();
        }
        catch (CreationException ce) {
            InjectorTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "InjectorTest$Interface is an interface, but interfaces have no static injection points.", "at InjectorTest$5.configure");
        }
    }

    public void testPrivateInjection() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"foo");
                this.bind(Integer.TYPE).toInstance((Object)5);
            }
        }});
        Private p = (Private)injector.getInstance(Private.class);
        InjectorTest.assertEquals((String)"foo", (String)p.fromConstructor);
        InjectorTest.assertEquals((int)5, (int)p.fromMethod);
    }

    public void testProtectedInjection() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"foo");
                this.bind(Integer.TYPE).toInstance((Object)5);
            }
        }});
        Protected p = (Protected)injector.getInstance(Protected.class);
        InjectorTest.assertEquals((String)"foo", (String)p.fromConstructor);
        InjectorTest.assertEquals((int)5, (int)p.fromMethod);
    }

    public void testInstanceInjectionHappensAfterFactoriesAreSetUp() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Object.class).toInstance(new Object(){
                    @Inject
                    Runnable r;
                });
                this.bind(Runnable.class).to(MyRunnable.class);
            }
        }});
    }

    public void testSubtypeNotProvided() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(Money.class);
            InjectorTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "InjectorTest$Tree doesn't provide instances of InjectorTest$Money.", "while locating InjectorTest$Tree", "while locating InjectorTest$Money");
        }
    }

    public void testNotASubtype() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(PineTree.class);
            InjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "InjectorTest$Tree doesn't extend InjectorTest$PineTree.", "while locating InjectorTest$PineTree");
        }
    }

    public void testRecursiveImplementationType() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(SeaHorse.class);
            InjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "@ImplementedBy points to the same class it annotates.", "while locating ", SeaHorse.class.getName());
        }
    }

    public void testRecursiveProviderType() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(Chicken.class);
            InjectorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "@ProvidedBy points to the same class it annotates", "while locating ", Chicken.class.getName());
        }
    }

    public void testJitBindingFromAnotherThreadDuringInjection() {
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        final AtomicReference got = new AtomicReference();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.requestInjection(new Object(){

                    @Inject
                    void initialize(Injector injector) throws ExecutionException, InterruptedException {
                        Future<JustInTime> future = executorService.submit(() -> (JustInTime)injector.getInstance(JustInTime.class));
                        got.set(future.get());
                    }
                });
            }
        }});
        InjectorTest.assertNotNull(got.get());
    }

    static class JustInTime {
        JustInTime() {
        }
    }

    @ProvidedBy(value=Chicken.class)
    static class Chicken
    implements Provider<Chicken> {
        Chicken() {
        }

        public Chicken get() {
            return this;
        }
    }

    @ImplementedBy(value=SeaHorse.class)
    static class SeaHorse {
        SeaHorse() {
        }
    }

    @ImplementedBy(value=Tree.class)
    static class PineTree
    extends Tree {
        PineTree() {
        }
    }

    static class Tree
    implements Provider<Object> {
        Tree() {
        }

        public Object get() {
            return "Money doesn't grow on trees";
        }
    }

    @ProvidedBy(value=Tree.class)
    static class Money {
        Money() {
        }
    }

    static class MyRunnable
    implements Runnable {
        MyRunnable() {
        }

        @Override
        public void run() {
        }
    }

    static class Protected {
        String fromConstructor;
        int fromMethod;

        @Inject
        protected Protected(String fromConstructor) {
            this.fromConstructor = fromConstructor;
        }

        @Inject
        protected void setInt(int i) {
            this.fromMethod = i;
        }
    }

    static class Private {
        String fromConstructor;
        int fromMethod;

        @Inject
        private Private(String fromConstructor) {
            this.fromConstructor = fromConstructor;
        }

        @Inject
        private void setInt(int i) {
            this.fromMethod = i;
        }
    }

    static class Static {
        @Inject
        @I
        static int i;
        static String s;

        Static() {
        }

        @Inject
        static void setS(@S String s) {
            Static.s = s;
        }
    }

    private static interface Interface {
    }

    static class TeeImpl
    implements Tee {
        final String s;
        @Inject
        Bar bar;

        @Inject
        TeeImpl(@S String s) {
            this.s = s;
        }

        @Override
        public String getS() {
            return this.s;
        }

        @Override
        public Bar getBar() {
            return this.bar;
        }
    }

    static interface Tee {
        public String getS();

        public Bar getBar();
    }

    @Singleton
    static class BarImpl
    implements Bar {
        @Inject
        @I
        int i;
        Tee tee;

        BarImpl() {
        }

        @Inject
        void initialize(Tee tee) {
            this.tee = tee;
        }

        @Override
        public Tee getTee() {
            return this.tee;
        }

        @Override
        public int getI() {
            return this.i;
        }
    }

    static interface Bar {
        public Tee getTee();

        public int getI();
    }

    static class Foo {
        @Inject
        Bar bar;
        @Inject
        Bar copy;
        @Inject
        @S
        String s;
        int i;

        Foo() {
        }

        @Inject
        void setI(@I int i) {
            this.i = i;
        }
    }

    static class IntegerWrapper {
        @Inject
        @I
        Integer i;

        IntegerWrapper() {
        }
    }

    static class SampleSingleton {
        SampleSingleton() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface I {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface S {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Other {
    }
}

