/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.junit.Assert;

public class Java8LanguageFeatureBindingTest
extends TestCase {
    public void testBinding_lambdaToInterface() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Predicate<Object>>(){}).toInstance(o -> o != null);
            }
        }});
        Predicate predicate = (Predicate)injector.getInstance((Key)new Key<Predicate<Object>>(){});
        Java8LanguageFeatureBindingTest.assertTrue((boolean)predicate.test(new Object()));
        Java8LanguageFeatureBindingTest.assertFalse((boolean)predicate.test(null));
    }

    public void testProviderMethod_returningLambda() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @Provides
            public Callable<String> provideCallable() {
                return () -> "foo";
            }
        }});
        Callable callable = (Callable)injector.getInstance((Key)new Key<Callable<String>>(){});
        Java8LanguageFeatureBindingTest.assertEquals((String)"foo", (String)((String)callable.call()));
    }

    public void testProviderMethod_containingLambda_throwingException() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @Provides
            public Callable<String> provideCallable() {
                if (Boolean.parseBoolean("false")) {
                    return () -> "foo";
                }
                throw new RuntimeException("foo");
            }
        }});
        ProvisionException expected = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> injector.getInstance((Key)new Key<Callable<String>>(){}));
        Java8LanguageFeatureBindingTest.assertTrue((boolean)(expected.getCause() instanceof RuntimeException));
        Java8LanguageFeatureBindingTest.assertEquals((String)"foo", (String)expected.getCause().getMessage());
    }

    public void testProvider_usingJdk8Features() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(String.class).toProvider(StringProvider.class);
                }
            }});
            Java8LanguageFeatureBindingTest.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
        final UUID uuid = UUID.randomUUID();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(UUID.class).toInstance((Object)uuid);
                this.bind(String.class).toProvider(StringProvider.class);
            }
        }});
        Java8LanguageFeatureBindingTest.assertEquals((String)uuid.toString(), (String)((String)injector.getInstance(String.class)));
    }

    public void testBinding_toProvider_lambda() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                AtomicInteger i = new AtomicInteger();
                this.bind(String.class).toProvider(() -> "Hello" + i.incrementAndGet());
            }
        }});
        Java8LanguageFeatureBindingTest.assertEquals((String)"Hello1", (String)((String)injector.getInstance(String.class)));
        Java8LanguageFeatureBindingTest.assertEquals((String)"Hello2", (String)((String)injector.getInstance(String.class)));
    }

    public void testBinding_toProvider_methodReference() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toProvider(() -> Java8LanguageFeatureBindingTest.this.provideString());
            }
        }});
        Provider provider = injector.getProvider(String.class);
        Java8LanguageFeatureBindingTest.assertEquals((String)"Hello", (String)((String)provider.get()));
    }

    private String provideString() {
        return "Hello";
    }

    private static final class StringProvider
    implements Provider<String> {
        private final UUID uuid;

        @Inject
        StringProvider(UUID uuid) {
            this.uuid = uuid;
        }

        public String get() {
            return Collections.singleton(this.uuid).stream().map(UUID::toString).findFirst().get();
        }
    }
}

