/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.Dependency;
import com.google.inject.util.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class KeyTest
extends TestCase {
    @Foo
    String baz;
    List<? extends CharSequence> wildcardExtends;

    public void foo(List<String> a, List<String> b) {
    }

    public void bar(Provider<List<String>> a) {
    }

    public void testOfType() {
        Key k = Key.get(Object.class, Foo.class);
        Key ki = k.ofType(Integer.class);
        KeyTest.assertEquals(Integer.class, (Object)ki.getRawType());
        KeyTest.assertEquals(Foo.class, (Object)ki.getAnnotationType());
    }

    public void testWithAnnotation() {
        Key k = Key.get(Object.class);
        Key kf = k.withAnnotation(Foo.class);
        KeyTest.assertNull((Object)k.getAnnotationType());
        KeyTest.assertEquals(Foo.class, (Object)kf.getAnnotationType());
    }

    public void testWithAnnotationInstance() throws NoSuchFieldException {
        Foo annotation = ((Object)((Object)this)).getClass().getDeclaredField("baz").getAnnotation(Foo.class);
        Key k = Key.get(Object.class);
        Key kf = k.withAnnotation((Annotation)annotation);
        KeyTest.assertNull((Object)k.getAnnotationType());
        KeyTest.assertNull((Object)k.getAnnotation());
        KeyTest.assertEquals(Foo.class, (Object)kf.getAnnotationType());
        KeyTest.assertEquals((Object)annotation, (Object)kf.getAnnotation());
    }

    public void testKeyEquality() {
        Key<List<String>> a = new Key<List<String>>(Foo.class){};
        Key b = Key.get((TypeLiteral)new TypeLiteral<List<String>>(){}, Foo.class);
        Asserts.assertEqualsBothWays(a, b);
    }

    public void testProviderKey() throws NoSuchMethodException {
        Key actual = Key.get((Type)((Object)((Object)this)).getClass().getMethod("foo", List.class, List.class).getGenericParameterTypes()[0]).providerKey();
        Key expected = Key.get((Type)((Object)((Object)this)).getClass().getMethod("bar", Provider.class).getGenericParameterTypes()[0]);
        Asserts.assertEqualsBothWays(expected, actual);
        KeyTest.assertEquals((String)expected.toString(), (String)actual.toString());
    }

    public void testTypeEquality() throws Exception {
        Method m = ((Object)((Object)this)).getClass().getMethod("foo", List.class, List.class);
        Type[] types = m.getGenericParameterTypes();
        KeyTest.assertEquals((Object)types[0], (Object)types[1]);
        Key<List<String>> k = new Key<List<String>>(){};
        KeyTest.assertEquals((Object)types[0], (Object)k.getTypeLiteral().getType());
        KeyTest.assertFalse((boolean)types[0].equals(new Key<List<Integer>>(){}.getTypeLiteral().getType()));
    }

    public void testPrimitivesAndWrappersAreEqual() {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Void.TYPE};
        Class[] wrappers = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Void.class};
        for (int t = 0; t < primitives.length; ++t) {
            Key primitiveKey = Key.get((Class)primitives[t]);
            Key wrapperKey = Key.get((Class)wrappers[t]);
            KeyTest.assertEquals((Object)primitiveKey, (Object)wrapperKey);
            KeyTest.assertEquals((Object)wrappers[t], (Object)primitiveKey.getRawType());
            KeyTest.assertEquals((Object)wrappers[t], (Object)wrapperKey.getRawType());
            KeyTest.assertEquals((Object)wrappers[t], (Object)primitiveKey.getTypeLiteral().getType());
            KeyTest.assertEquals((Object)wrappers[t], (Object)wrapperKey.getTypeLiteral().getType());
        }
        Key integerKey = Key.get(Integer.class);
        Key integerKey2 = Key.get(Integer.class, Named.class);
        Key integerKey3 = Key.get(Integer.class, (Annotation)Names.named((String)"int"));
        Class<Integer> intClassLiteral = Integer.TYPE;
        KeyTest.assertEquals((Object)integerKey, (Object)Key.get(intClassLiteral));
        KeyTest.assertEquals((Object)integerKey2, (Object)Key.get(intClassLiteral, Named.class));
        KeyTest.assertEquals((Object)integerKey3, (Object)Key.get(intClassLiteral, (Annotation)Names.named((String)"int")));
        Class<Integer> intType = Integer.TYPE;
        KeyTest.assertEquals((Object)integerKey, (Object)Key.get(intType));
        KeyTest.assertEquals((Object)integerKey2, (Object)Key.get(intType, Named.class));
        KeyTest.assertEquals((Object)integerKey3, (Object)Key.get(intType, (Annotation)Names.named((String)"int")));
        TypeLiteral intTypeLiteral = TypeLiteral.get(Integer.TYPE);
        KeyTest.assertEquals((Object)integerKey, (Object)Key.get((TypeLiteral)intTypeLiteral));
        KeyTest.assertEquals((Object)integerKey2, (Object)Key.get((TypeLiteral)intTypeLiteral, Named.class));
        KeyTest.assertEquals((Object)integerKey3, (Object)Key.get((TypeLiteral)intTypeLiteral, (Annotation)Names.named((String)"int")));
    }

    public void testSerialization() throws IOException, NoSuchFieldException {
        Asserts.assertNotSerializable(Key.get(B.class));
        Asserts.assertNotSerializable(Key.get(B.class, (Annotation)Names.named((String)"bee")));
        Asserts.assertNotSerializable(Key.get(B.class, Named.class));
        Asserts.assertNotSerializable(Key.get(B[].class));
        Asserts.assertNotSerializable(Key.get((TypeLiteral)new TypeLiteral<Map<List<B>, B>>(){}));
        Asserts.assertNotSerializable(Key.get((TypeLiteral)new TypeLiteral<List<B[]>>(){}));
        Asserts.assertNotSerializable(Key.get((Type)Types.listOf((Type)Types.subtypeOf(CharSequence.class))));
    }

    public void testEqualityOfAnnotationTypesAndInstances() throws NoSuchFieldException {
        Foo instance = ((Object)((Object)this)).getClass().getDeclaredField("baz").getAnnotation(Foo.class);
        Key keyWithInstance = Key.get(String.class, (Annotation)instance);
        Key keyWithLiteral = Key.get(String.class, Foo.class);
        Asserts.assertEqualsBothWays(keyWithInstance, keyWithLiteral);
    }

    public void testNonBindingAnnotationOnKey() {
        try {
            Key.get(String.class, Deprecated.class);
            KeyTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "java.lang.Deprecated is not a binding annotation. ", "Please annotate it with @BindingAnnotation.");
        }
    }

    public void testBindingAnnotationWithoutRuntimeRetention() {
        try {
            Key.get(String.class, Bar.class);
            KeyTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), Bar.class.getName() + " is not retained at runtime.", "Please annotate it with @Retention(RUNTIME).");
        }
    }

    <T> void parameterizedWithVariable(List<T> typeWithVariables) {
    }

    public void testCannotCreateKeysWithTypeVariables() throws NoSuchMethodException {
        ParameterizedType listOfTType = (ParameterizedType)((Object)((Object)this)).getClass().getDeclaredMethod("parameterizedWithVariable", List.class).getGenericParameterTypes()[0];
        TypeLiteral listOfT = TypeLiteral.get((Type)listOfTType);
        try {
            Key.get((TypeLiteral)listOfT);
            KeyTest.fail((String)"Guice should not allow keys for java.util.List<T>");
        }
        catch (ConfigurationException e) {
            Asserts.assertContains(e.getMessage(), "List<T> cannot be used as a key; It is not fully specified.");
        }
        TypeVariable tType = (TypeVariable)listOfTType.getActualTypeArguments()[0];
        TypeLiteral t = TypeLiteral.get((Type)tType);
        try {
            Key.get((TypeLiteral)t);
            KeyTest.fail((String)"Guice should not allow keys for T");
        }
        catch (ConfigurationException e) {
            Asserts.assertContains(e.getMessage(), "T cannot be used as a key; It is not fully specified.");
        }
    }

    public void testCannotGetKeyWithUnspecifiedTypeVariables() {
        TypeLiteral typeLiteral = KeyTest.createTypeLiteral();
        try {
            Key.get(typeLiteral);
            KeyTest.fail((String)"Guice should not allow keys for T");
        }
        catch (ConfigurationException e) {
            Asserts.assertContains(e.getMessage(), "T cannot be used as a key; It is not fully specified.");
        }
    }

    private static <T> TypeLiteral<T> createTypeLiteral() {
        return new TypeLiteral<T>(){};
    }

    public void testCannotCreateKeySubclassesWithUnspecifiedTypeVariables() {
        try {
            KeyTest.createKey();
            KeyTest.fail((String)"Guice should not allow keys for T");
        }
        catch (ConfigurationException e) {
            Asserts.assertContains(e.getMessage(), "T cannot be used as a key; It is not fully specified.");
        }
    }

    private static <T> Key<T> createKey() {
        return new Key<T>(){};
    }

    public void testKeysWithDefaultAnnotations() {
        AllDefaults allDefaults = HasAnnotations.class.getAnnotation(AllDefaults.class);
        KeyTest.assertEquals((Object)Key.get(Foo.class, (Annotation)allDefaults), (Object)Key.get(Foo.class, AllDefaults.class));
        Marker marker = HasAnnotations.class.getAnnotation(Marker.class);
        KeyTest.assertEquals((Object)Key.get(Foo.class, (Annotation)marker), (Object)Key.get(Foo.class, Marker.class));
        Key noDefaults = Key.get(Foo.class, NoDefaults.class);
        KeyTest.assertNull((Object)noDefaults.getAnnotation());
        KeyTest.assertEquals(NoDefaults.class, (Object)noDefaults.getAnnotationType());
        Key someDefaults = Key.get(Foo.class, SomeDefaults.class);
        KeyTest.assertNull((Object)someDefaults.getAnnotation());
        KeyTest.assertEquals(SomeDefaults.class, (Object)someDefaults.getAnnotationType());
    }

    public void testAnonymousClassesDontHoldRefs() {
        final AtomicReference stringProvider = new AtomicReference();
        final AtomicReference intProvider = new AtomicReference();
        final Object foo = new Object(){
            @Inject
            List<String> list;
        };
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind((Key)new Key<List<String>>(){}).toInstance(new ArrayList());
                this.bind((TypeLiteral)new TypeLiteral<List<Integer>>(){}).toInstance(new ArrayList());
                stringProvider.set(this.getProvider((Key)new Key<List<String>>(){}));
                intProvider.set(this.binder().getProvider(Dependency.get((Key)new Key<List<Integer>>(){})));
                this.binder().requestInjection((TypeLiteral)new TypeLiteral<Object>(){}, foo);
            }
        };
        WeakReference<10> moduleRef = new WeakReference<10>(module);
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        module = null;
        Asserts.awaitClear(moduleRef);
        Runnable runner = () -> {
            injector.getInstance((Key)new Key<Typed<String>>(){});
            injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Typed<Integer>>(){}));
        };
        WeakReference<Runnable> runnerRef = new WeakReference<Runnable>(runner);
        runner.run();
        runner = null;
        Asserts.awaitClear(runnerRef);
    }

    static class Typed<T> {
        Typed() {
        }
    }

    @AllDefaults
    @Marker
    static class HasAnnotations {
        HasAnnotations() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Marker {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface NoDefaults {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface SomeDefaults {
        public int v1() default 1;

        public String v2() default "foo";

        public Class<?> clazz();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface AllDefaults {
        public int v1() default 1;

        public String v2() default "foo";
    }

    static class HasTypeParameters<A, B extends List<A> & Runnable, C extends Runnable> {
        A a;
        B b;
        C c;

        HasTypeParameters() {
        }
    }

    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface Bar {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface Foo {
    }

    static interface B {
    }
}

