/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class ProviderInjectionTest
extends TestCase {
    public void testProviderInjection() throws CreationException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Bar.class);
                this.bind(SampleSingleton.class).in(Scopes.SINGLETON);
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        Bar bar = (Bar)foo.barProvider.get();
        ProviderInjectionTest.assertNotNull((Object)bar);
        ProviderInjectionTest.assertNotSame((Object)bar, (Object)foo.barProvider.get());
        SampleSingleton singleton = (SampleSingleton)foo.singletonProvider.get();
        ProviderInjectionTest.assertNotNull((Object)singleton);
        ProviderInjectionTest.assertSame((Object)singleton, (Object)foo.singletonProvider.get());
    }

    public void testProvidersAreInjectedWhenBound() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                this.bind(Bar.class).toProvider((Provider)new Provider<Bar>(){

                    @Inject
                    void cantBeCalled(Baz baz) {
                        TestCase.fail((String)"Can't have called this method since Baz is not bound.");
                    }

                    public Bar get() {
                        return new Bar(){};
                    }
                });
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{m});
            ProviderInjectionTest.fail((String)"Should have thrown a CreationException");
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    public void testProvidersAreInjectedBeforeTheyAreUsed() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            public void configure() {
                this.bind(String.class).toProvider((Provider)new Provider<String>(){
                    private String value;

                    @Inject
                    void initialize(List<Boolean> list) {
                        this.value = list.toString();
                    }

                    public String get() {
                        return this.value;
                    }
                });
                this.bind((Key)new Key<List<Boolean>>(){}).toProvider((Provider)new Provider<List<Boolean>>(){
                    @Inject
                    Boolean injectedYet = Boolean.FALSE;

                    public List<Boolean> get() {
                        return Arrays.asList(this.injectedYet);
                    }
                });
                this.bind(Boolean.class).toInstance((Object)Boolean.TRUE);
            }
        }});
        ProviderInjectionTest.assertEquals((String)"Providers not injected before use", (String)"[true]", (String)((String)injector.getInstance(String.class)));
    }

    public void testCreationTimeInjectionOrdering() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Count.class).annotatedWith((Annotation)Names.named((String)"a")).toInstance((Object)new Count(0){

                    @Inject
                    void initialize(@Named(value="b") Count bCount) {
                        this.value = bCount.value + 1;
                    }
                });
                this.bind(Count.class).annotatedWith((Annotation)Names.named((String)"b")).toProvider((Provider)new Provider<Count>(){
                    Count count;

                    @Inject
                    void initialize(@Named(value="c") Count cCount) {
                        this.count = new Count(cCount.value + 2);
                    }

                    public Count get() {
                        return this.count;
                    }
                });
                this.bind(Count.class).annotatedWith((Annotation)Names.named((String)"c")).toInstance((Object)new Count(0){
                    @Inject
                    @Named(value="d")
                    Count dCount;

                    @Inject
                    void initialize(@Named(value="e") Count eCount) {
                        this.value = this.dCount.value + eCount.value + 4;
                    }
                });
                this.requestStaticInjection(new Class[]{StaticallyInjectable.class});
                this.bind(Count.class).annotatedWith((Annotation)Names.named((String)"d")).toInstance((Object)new Count(8));
                this.bind(Count.class).annotatedWith((Annotation)Names.named((String)"e")).toInstance((Object)new Count(16));
            }
        }});
        ProviderInjectionTest.assertEquals((int)28, (int)((Count)injector.getInstance((Key)Key.get(Count.class, (Annotation)Names.named((String)"c")))).value);
        ProviderInjectionTest.assertEquals((int)30, (int)((Count)injector.getInstance((Key)Key.get(Count.class, (Annotation)Names.named((String)"b")))).value);
        ProviderInjectionTest.assertEquals((int)31, (int)((Count)injector.getInstance((Key)Key.get(Count.class, (Annotation)Names.named((String)"a")))).value);
        ProviderInjectionTest.assertEquals((int)28, (int)StaticallyInjectable.cCountAtInjectionTime);
    }

    static interface Baz {
    }

    static class SampleSingleton {
        SampleSingleton() {
        }
    }

    static class Bar {
        Bar() {
        }
    }

    static class Foo {
        @Inject
        Provider<Bar> barProvider;
        @Inject
        Provider<SampleSingleton> singletonProvider;

        Foo() {
        }
    }

    static class StaticallyInjectable {
        static int cCountAtInjectionTime;

        StaticallyInjectable() {
        }

        @Inject
        static void initialize(@Named(value="c") Count cCount) {
            cCountAtInjectionTime = cCount.value;
        }
    }

    static class Count {
        int value;

        Count(int value) {
            this.value = value;
        }
    }
}

