/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import junit.framework.TestCase;

public class RequireAtInjectOnConstructorsTest
extends TestCase {
    public void testNoCxtors_explicitBinding() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(NoCxtors.class);
                    this.binder().requireAtInjectOnConstructors();
                }
            }});
            RequireAtInjectOnConstructorsTest.fail();
        }
        catch (CreationException ce) {
            RequireAtInjectOnConstructorsTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "No injectable constructor for type RequireAtInjectOnConstructorsTest$NoCxtors.", "at RequireAtInjectOnConstructorsTest$1.configure");
        }
    }

    public void testNoCxtors_jitBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().requireAtInjectOnConstructors();
            }
        }});
        try {
            injector.getInstance(NoCxtors.class);
            RequireAtInjectOnConstructorsTest.fail();
        }
        catch (ConfigurationException ce) {
            Asserts.assertContains(ce.getMessage(), "No injectable constructor for type RequireAtInjectOnConstructorsTest$NoCxtors.", "while locating RequireAtInjectOnConstructorsTest$NoCxtors");
        }
    }

    public void testNoCxtors_implicitBinding() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(Interface.class).to(NoCxtors.class);
                    this.binder().requireAtInjectOnConstructors();
                }
            }});
            RequireAtInjectOnConstructorsTest.fail();
        }
        catch (CreationException ce) {
            RequireAtInjectOnConstructorsTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "No injectable constructor for type RequireAtInjectOnConstructorsTest$NoCxtors", "at RequireAtInjectOnConstructorsTest$3.configure");
        }
    }

    public void testNoCxtors_inheritedByPrivateModules() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.binder().requireAtInjectOnConstructors();
                    this.install((Module)new PrivateModule(){

                        protected void configure() {
                            this.bind(NoCxtors.class);
                        }
                    });
                }
            }});
            RequireAtInjectOnConstructorsTest.fail();
        }
        catch (CreationException ce) {
            RequireAtInjectOnConstructorsTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "No injectable constructor for type RequireAtInjectOnConstructorsTest$NoCxtors.", "at RequireAtInjectOnConstructorsTest$4$1.configure");
        }
    }

    public void testNoCxtors_accumulatesAllErrors() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(NoCxtors.class);
                    this.bind(AnotherNoCxtors.class);
                    this.binder().requireAtInjectOnConstructors();
                }
            }});
            RequireAtInjectOnConstructorsTest.fail();
        }
        catch (CreationException ce) {
            RequireAtInjectOnConstructorsTest.assertEquals((int)2, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "No injectable constructor for type RequireAtInjectOnConstructorsTest$AnotherNoCxtors.", "at RequireAtInjectOnConstructorsTest$5.configure", "No injectable constructor for type RequireAtInjectOnConstructorsTest$NoCxtors.", "at RequireAtInjectOnConstructorsTest$5.configure");
        }
    }

    public void testNoCxtors_separateOptionsForPrivateModules() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(AnotherNoCxtors.class);
                    this.install((Module)new PrivateModule(){

                        protected void configure() {
                            this.binder().requireAtInjectOnConstructors();
                            this.bind(NoCxtors.class);
                        }
                    });
                }
            }});
            RequireAtInjectOnConstructorsTest.fail();
        }
        catch (CreationException ce) {
            RequireAtInjectOnConstructorsTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "No injectable constructor for type RequireAtInjectOnConstructorsTest$NoCxtors.", "Injector is configured to require @Inject constructors", "at RequireAtInjectOnConstructorsTest$6$1.configure");
        }
    }

    public void testManyConstructorsButNoneWithAtInject() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(ManyConstructors.class);
                    this.binder().requireAtInjectOnConstructors();
                }
            }});
            RequireAtInjectOnConstructorsTest.fail();
        }
        catch (CreationException ce) {
            RequireAtInjectOnConstructorsTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "No injectable constructor for type RequireAtInjectOnConstructorsTest$ManyConstructors.", "at RequireAtInjectOnConstructorsTest$7.configure");
        }
    }

    public void testRequireAtInjectStillAllowsToConstructorBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                try {
                    this.bind(ManyConstructors.class).toConstructor(ManyConstructors.class.getDeclaredConstructor(new Class[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.binder().requireAtInjectOnConstructors();
            }
        }});
        injector.getInstance(ManyConstructors.class);
    }

    private static class ManyConstructors {
        ManyConstructors() {
        }

        ManyConstructors(String a) {
        }

        ManyConstructors(int a) {
        }
    }

    private static class AnotherNoCxtors {
        private AnotherNoCxtors() {
        }
    }

    private static class NoCxtors
    implements Interface {
        private NoCxtors() {
        }
    }

    private static interface Interface {
    }
}

