/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class BindingAlreadySetErrorTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void singleBindingAlreadySetError() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new BindWithProviderMethodModule(), new BindWithDslModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "single_binding_already_set_error.txt");
    }

    @Test
    public void multipleBindingAlreadySetErrors() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new BindWithCustomScannerModule(), new BindWithProviderMethodModule(), new BindWithDslModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "multiple_binding_already_set_errors.txt");
    }

    @Test
    public void bindingAlreadySetErrorsWithModuleStack() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new TestModule1(), new TestModule2()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "binding_already_set_errors_with_module_stack.txt");
    }

    static class TestModule2
    extends AbstractModule {
        TestModule2() {
        }

        protected void configure() {
            this.install((Module)new AbstractModule(){

                protected void configure() {
                    this.install((Module)new BindWithProviderMethodModule());
                }
            });
        }
    }

    static class TestModule1
    extends AbstractModule {
        TestModule1() {
        }

        protected void configure() {
            this.install((Module)new BindWithProviderMethodModule());
        }
    }

    static class TestProvidesScanner
    extends ModuleAnnotatedMethodScanner {
        TestProvidesScanner() {
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(TestProvides.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            return key;
        }
    }

    static class BindWithCustomScannerModule
    extends AbstractModule {
        BindWithCustomScannerModule() {
        }

        protected void configure() {
            this.binder().scanModulesForAnnotatedMethods((ModuleAnnotatedMethodScanner)new TestProvidesScanner());
        }

        @TestProvides
        Second second() {
            return new Second();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestProvides {
    }

    static class BindWithDslModule
    extends AbstractModule {
        BindWithDslModule() {
        }

        protected void configure() {
            this.bind(First.class);
            this.bind(Second.class);
        }
    }

    static class BindWithProviderMethodModule
    extends AbstractModule {
        BindWithProviderMethodModule() {
        }

        @Provides
        First provideFirstClass() {
            return new First();
        }
    }

    static class Second {
        Second() {
        }
    }

    static class First {
        First() {
        }
    }
}

