/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.example;

import junit.framework.Assert;

public class ClientServiceWithDependencyInjection {
    public void testClient() {
        MockService mock = new MockService();
        Client client = new Client(mock);
        client.go();
        Assert.assertTrue((boolean)mock.isGone());
    }

    public static void main(String[] args) {
        new ClientServiceWithDependencyInjection().testClient();
    }

    public static class MockService
    implements Service {
        private boolean gone = false;

        @Override
        public void go() {
            this.gone = true;
        }

        public boolean isGone() {
            return this.gone;
        }
    }

    public static class ClientFactory {
        private ClientFactory() {
        }

        public static Client getInstance() {
            Service service = ServiceFactory.getInstance();
            return new Client(service);
        }
    }

    public static class Client {
        private final Service service;

        public Client(Service service) {
            this.service = service;
        }

        public void go() {
            this.service.go();
        }
    }

    public static class ServiceFactory {
        private static final Service service = new ServiceImpl();

        private ServiceFactory() {
        }

        public static Service getInstance() {
            return service;
        }
    }

    public static class ServiceImpl
    implements Service {
        @Override
        public void go() {
        }
    }

    public static interface Service {
        public void go();
    }
}

