/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.InjectorBindingData;
import com.google.inject.internal.WeakKeySet;
import com.google.inject.internal.WeakKeySetUtils;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InterceptorBinding;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProvisionListenerBinding;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListenerBinding;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import junit.framework.TestCase;

public class WeakKeySetTest
extends TestCase {
    private WeakKeySet set;

    protected void setUp() throws Exception {
        this.set = new WeakKeySet(new Object());
    }

    public void testEviction() {
        TestInjectorBindingData bindingData = new TestInjectorBindingData();
        Key key = Key.get(Integer.class);
        Object source = new Object();
        WeakReference<Key> weakKeyRef = new WeakReference<Key>(key);
        this.set.add(key, (InjectorBindingData)bindingData, source);
        WeakKeySetUtils.assertInSet(this.set, key, 1, source);
        bindingData = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertNotInSet(this.set, Key.get(Integer.class));
        key = null;
        Asserts.awaitClear(weakKeyRef);
    }

    public void testEviction_nullSource() {
        TestInjectorBindingData bindingData = new TestInjectorBindingData();
        Key key = Key.get(Integer.class);
        Object source = null;
        WeakReference<Key> weakKeyRef = new WeakReference<Key>(key);
        this.set.add(key, (InjectorBindingData)bindingData, source);
        WeakKeySetUtils.assertInSet(this.set, key, 1, source);
        bindingData = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertNotInSet(this.set, Key.get(Integer.class));
        key = null;
        Asserts.awaitClear(weakKeyRef);
    }

    public void testEviction_keyOverlap_2x() {
        TestInjectorBindingData bindingData1 = new TestInjectorBindingData();
        TestInjectorBindingData bindingData2 = new TestInjectorBindingData();
        Key key1 = Key.get(Integer.class);
        Key key2 = Key.get(Integer.class);
        Object source1 = new Object();
        Object source2 = new Object();
        this.set.add(key1, (InjectorBindingData)bindingData1, source1);
        WeakKeySetUtils.assertInSet(this.set, key1, 1, source1);
        this.set.add(key2, (InjectorBindingData)bindingData2, source2);
        WeakKeySetUtils.assertInSet(this.set, key2, 2, source1, source2);
        WeakReference<Key> weakKey1Ref = new WeakReference<Key>(key1);
        WeakReference<Key> weakKey2Ref = new WeakReference<Key>(key2);
        WeakReference<Object> weakSource1Ref = new WeakReference<Object>(source1);
        WeakReference<Object> weakSource2Ref = new WeakReference<Object>(source2);
        key1 = key2 = Key.get(Integer.class);
        Key key = key2;
        bindingData1 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertSourceNotInSet(this.set, key, source1);
        WeakKeySetUtils.assertInSet(this.set, key, 1, source2);
        source2 = null;
        source1 = null;
        Object unused = null;
        Asserts.awaitClear(weakSource1Ref);
        WeakKeySetTest.assertNotNull(weakSource2Ref.get());
        bindingData2 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertNotInSet(this.set, key);
        Asserts.awaitClear(weakKey2Ref);
        Asserts.awaitClear(weakSource2Ref);
        Asserts.awaitClear(weakKey1Ref);
    }

    public void testNoEviction_keyOverlap_2x() {
        TestInjectorBindingData bindingData1 = new TestInjectorBindingData();
        TestInjectorBindingData bindingData2 = new TestInjectorBindingData();
        Key key1 = Key.get(Integer.class);
        Key key2 = Key.get(Integer.class);
        Object source1 = new Object();
        Object source2 = new Object();
        this.set.add(key1, (InjectorBindingData)bindingData1, source1);
        WeakKeySetUtils.assertInSet(this.set, key1, 1, source1);
        this.set.add(key2, (InjectorBindingData)bindingData2, source2);
        WeakKeySetUtils.assertInSet(this.set, key2, 2, source1, source2);
        WeakReference<Key> weakKey1Ref = new WeakReference<Key>(key1);
        WeakReference<Key> weakKey2Ref = new WeakReference<Key>(key2);
        key1 = key2 = Key.get(Integer.class);
        Key key = key2;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertInSet(this.set, key, 2, source1, source2);
        WeakKeySetTest.assertNotNull(weakKey1Ref.get());
        WeakKeySetTest.assertNotNull(weakKey2Ref.get());
    }

    public void testEviction_keyAndSourceOverlap_null() {
        TestInjectorBindingData bindingData1 = new TestInjectorBindingData();
        TestInjectorBindingData bindingData2 = new TestInjectorBindingData();
        Key key1 = Key.get(Integer.class);
        Key key2 = Key.get(Integer.class);
        Object source = null;
        this.set.add(key1, (InjectorBindingData)bindingData1, source);
        WeakKeySetUtils.assertInSet(this.set, key1, 1, source);
        this.set.add(key2, (InjectorBindingData)bindingData2, source);
        WeakKeySetUtils.assertInSet(this.set, key2, 1, source);
        WeakKeySetUtils.assertInSet(this.set, key1, 1, source);
        WeakReference<Key> weakKey1Ref = new WeakReference<Key>(key1);
        WeakReference<Key> weakKey2Ref = new WeakReference<Key>(key2);
        WeakReference<Object> weakSourceRef = new WeakReference<Object>(source);
        key1 = key2 = Key.get(Integer.class);
        Key key = key2;
        bindingData1 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertInSet(this.set, key, 1, source);
        source = null;
        Asserts.awaitClear(weakSourceRef);
        bindingData2 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertNotInSet(this.set, key);
        Asserts.awaitClear(weakKey2Ref);
        Asserts.awaitClear(weakSourceRef);
        Asserts.awaitClear(weakKey1Ref);
    }

    public void testEviction_keyAndSourceOverlap_nonNull() {
        TestInjectorBindingData bindingData1 = new TestInjectorBindingData();
        TestInjectorBindingData bindingData2 = new TestInjectorBindingData();
        Key key1 = Key.get(Integer.class);
        Key key2 = Key.get(Integer.class);
        Object source = new Object();
        this.set.add(key1, (InjectorBindingData)bindingData1, source);
        WeakKeySetUtils.assertInSet(this.set, key1, 1, source);
        this.set.add(key2, (InjectorBindingData)bindingData2, source);
        WeakKeySetUtils.assertInSet(this.set, key2, 1, source);
        WeakReference<Key> weakKey1Ref = new WeakReference<Key>(key1);
        WeakReference<Key> weakKey2Ref = new WeakReference<Key>(key2);
        WeakReference<Object> weakSourceRef = new WeakReference<Object>(source);
        key1 = key2 = Key.get(Integer.class);
        Key key = key2;
        bindingData1 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertInSet(this.set, key, 1, source);
        WeakKeySetUtils.assertInSet(this.set, key1, 1, source);
        source = null;
        Asserts.awaitFullGc();
        WeakKeySetTest.assertNotNull(weakSourceRef.get());
        bindingData2 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertNotInSet(this.set, key);
        Asserts.awaitClear(weakKey2Ref);
        Asserts.awaitClear(weakSourceRef);
        Asserts.awaitClear(weakKey1Ref);
    }

    public void testEviction_keyOverlap_3x() {
        TestInjectorBindingData bindingData1 = new TestInjectorBindingData();
        TestInjectorBindingData bindingData2 = new TestInjectorBindingData();
        TestInjectorBindingData bindingData3 = new TestInjectorBindingData();
        Key key1 = Key.get(Integer.class);
        Key key2 = Key.get(Integer.class);
        Key key3 = Key.get(Integer.class);
        Object source1 = new Object();
        Object source2 = new Object();
        Object source3 = new Object();
        this.set.add(key1, (InjectorBindingData)bindingData1, source1);
        WeakKeySetUtils.assertInSet(this.set, key1, 1, source1);
        this.set.add(key2, (InjectorBindingData)bindingData2, source2);
        WeakKeySetUtils.assertInSet(this.set, key1, 2, source1, source2);
        this.set.add(key3, (InjectorBindingData)bindingData3, source3);
        WeakKeySetUtils.assertInSet(this.set, key1, 3, source1, source2, source3);
        WeakReference<Key> weakKey1Ref = new WeakReference<Key>(key1);
        WeakReference<Key> weakKey2Ref = new WeakReference<Key>(key2);
        WeakReference<Key> weakKey3Ref = new WeakReference<Key>(key3);
        WeakReference<Object> weakSource1Ref = new WeakReference<Object>(source1);
        WeakReference<Object> weakSource2Ref = new WeakReference<Object>(source2);
        WeakReference<Object> weakSource3Ref = new WeakReference<Object>(source3);
        key2 = key3 = Key.get(Integer.class);
        key1 = key3;
        Key key = key3;
        bindingData1 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertSourceNotInSet(this.set, key, source1);
        WeakKeySetUtils.assertInSet(this.set, key, 2, source2, source3);
        source1 = null;
        Asserts.awaitClear(weakSource1Ref);
        bindingData2 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertSourceNotInSet(this.set, key, source2);
        WeakKeySetUtils.assertInSet(this.set, key, 1, source3);
        Asserts.awaitClear(weakKey2Ref);
        source2 = null;
        Asserts.awaitClear(weakSource2Ref);
        bindingData3 = null;
        Asserts.awaitFullGc();
        WeakKeySetUtils.assertNotInSet(this.set, key);
        Asserts.awaitClear(weakKey3Ref);
        source3 = null;
        Asserts.awaitClear(weakSource3Ref);
        Asserts.awaitClear(weakKey1Ref);
    }

    public void testWeakKeySet_integration() {
        Injector parentInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)4);
            }
        }});
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(String.class));
        Injector childInjector = parentInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"bar");
            }
        }});
        WeakReference<Injector> weakRef = new WeakReference<Injector>(childInjector);
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(String.class));
        childInjector = null;
        Asserts.awaitClear(weakRef);
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(String.class));
    }

    public void testWeakKeySet_integration_multipleChildren() {
        Injector parentInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)4);
            }
        }});
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(String.class));
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(Long.class));
        Injector childInjector1 = parentInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"foo");
            }
        }});
        WeakReference<Injector> weakRef1 = new WeakReference<Injector>(childInjector1);
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(String.class));
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(Long.class));
        Injector childInjector2 = parentInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Long.class).toInstance((Object)6L);
            }
        }});
        WeakReference<Injector> weakRef2 = new WeakReference<Injector>(childInjector2);
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(String.class));
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(Long.class));
        childInjector1 = null;
        Asserts.awaitClear(weakRef1);
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(String.class));
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(Long.class));
        childInjector2 = null;
        Asserts.awaitClear(weakRef2);
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(String.class));
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(Long.class));
    }

    public void testWeakKeySet_integration_multipleChildren_overlappingKeys() {
        Injector parentInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)4);
            }
        }});
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(String.class));
        Injector childInjector1 = parentInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"foo");
            }
        }});
        WeakReference<Injector> weakRef1 = new WeakReference<Injector>(childInjector1);
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(String.class));
        Injector childInjector2 = parentInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"bar");
            }
        }});
        WeakReference<Injector> weakRef2 = new WeakReference<Injector>(childInjector2);
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(String.class));
        childInjector1 = null;
        Asserts.awaitClear(weakRef1);
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(String.class));
        childInjector2 = null;
        Asserts.awaitClear(weakRef2);
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(String.class));
    }

    private static class TestInjectorBindingData
    extends InjectorBindingData {
        TestInjectorBindingData() {
            super(Optional.empty());
        }

        public Optional<InjectorBindingData> parent() {
            return Optional.of(new TestInjectorBindingData());
        }

        public <T> BindingImpl<T> getExplicitBinding(Key<T> key) {
            return null;
        }

        public Map<Key<?>, Binding<?>> getExplicitBindingsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public void putBinding(Key<?> key, BindingImpl<?> binding) {
            throw new UnsupportedOperationException();
        }

        public void putProviderLookup(ProviderLookup<?> lookup) {
            throw new UnsupportedOperationException();
        }

        public Set<ProviderLookup<?>> getProviderLookupsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public void putStaticInjectionRequest(StaticInjectionRequest staticInjectionRequest) {
            throw new UnsupportedOperationException();
        }

        public Set<StaticInjectionRequest> getStaticInjectionRequestsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public Set<InjectionRequest<?>> getInjectionRequestsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public Set<MembersInjectorLookup<?>> getMembersInjectorLookupsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public void putInjectionRequest(InjectionRequest<?> injectionRequest) {
            throw new UnsupportedOperationException();
        }

        public void putMembersInjectorLookup(MembersInjectorLookup<?> membersInjectorLookup) {
            throw new UnsupportedOperationException();
        }

        public ScopeBinding getScopeBinding(Class<? extends Annotation> scopingAnnotation) {
            return null;
        }

        public void putScopeBinding(Class<? extends Annotation> annotationType, ScopeBinding scope) {
            throw new UnsupportedOperationException();
        }

        public void addConverter(TypeConverterBinding typeConverterBinding) {
            throw new UnsupportedOperationException();
        }

        public TypeConverterBinding getConverter(String stringValue, TypeLiteral<?> type, Errors errors, Object source) {
            throw new UnsupportedOperationException();
        }

        public Iterable<TypeConverterBinding> getConvertersThisLevel() {
            return ImmutableSet.of();
        }

        public void addInterceptorBinding(InterceptorBinding interceptorBinding) {
            throw new UnsupportedOperationException();
        }

        public ImmutableList<InterceptorBinding> getInterceptorBindings() {
            return ImmutableList.of();
        }

        public void addTypeListener(TypeListenerBinding typeListenerBinding) {
            throw new UnsupportedOperationException();
        }

        public ImmutableList<TypeListenerBinding> getTypeListenerBindings() {
            return ImmutableList.of();
        }

        public void addProvisionListener(ProvisionListenerBinding provisionListenerBinding) {
            throw new UnsupportedOperationException();
        }

        public ImmutableList<ProvisionListenerBinding> getProvisionListenerBindings() {
            return ImmutableList.of();
        }

        public void addScanner(ModuleAnnotatedMethodScannerBinding scanner) {
            throw new UnsupportedOperationException();
        }

        public ImmutableList<ModuleAnnotatedMethodScannerBinding> getScannerBindings() {
            return ImmutableList.of();
        }

        public Map<Class<? extends Annotation>, Scope> getScopes() {
            return ImmutableMap.of();
        }

        public List<ScopeBinding> getScopeBindingsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public ImmutableList<TypeListenerBinding> getTypeListenerBindingsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public ImmutableList<ProvisionListenerBinding> getProvisionListenerBindingsThisLevel() {
            throw new UnsupportedOperationException();
        }

        public ImmutableList<ModuleAnnotatedMethodScannerBinding> getScannerBindingsThisLevel() {
            throw new UnsupportedOperationException();
        }
    }
}

