/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.ModuleSource;
import junit.framework.TestCase;

public class ModuleSourceTest
extends TestCase {
    private static final StackTraceElement BINDER_INSTALL = new StackTraceElement("com.google.inject.spi.Elements$RecordingBinder", "install", "Unknown Source", 235);

    public void testOneModule() {
        ModuleSource moduleSource = this.createWithSizeOne();
        this.checkSizeOne(moduleSource);
    }

    public void testTwoModules() {
        ModuleSource moduleSource = this.createWithSizeTwo();
        this.checkSizeTwo(moduleSource);
        moduleSource = moduleSource.getParent();
        this.checkSizeOne(moduleSource);
    }

    public void testThreeModules() {
        ModuleSource moduleSource = this.createWithSizeThree();
        this.checkSizeThree(moduleSource);
        moduleSource = moduleSource.getParent();
        this.checkSizeTwo(moduleSource);
        moduleSource = moduleSource.getParent();
        this.checkSizeOne(moduleSource);
    }

    private void checkSizeOne(ModuleSource moduleSource) {
        ModuleSourceTest.assertEquals((int)1, (int)moduleSource.size());
    }

    private void checkSizeTwo(ModuleSource moduleSource) {
        ModuleSourceTest.assertEquals((int)2, (int)moduleSource.size());
    }

    private void checkSizeThree(ModuleSource moduleSource) {
        ModuleSourceTest.assertEquals((int)3, (int)moduleSource.size());
    }

    private ModuleSource createWithSizeOne() {
        return new ModuleSource(A.class, null);
    }

    private ModuleSource createWithSizeTwo() {
        ModuleSource moduleSource = this.createWithSizeOne();
        return moduleSource.createChild(B.class);
    }

    private ModuleSource createWithSizeThree() {
        ModuleSource moduleSource = this.createWithSizeTwo();
        return moduleSource.createChild(C.class);
    }

    private static class C
    extends AbstractModule {
        private C() {
        }
    }

    private static class B
    implements Module {
        private B() {
        }

        public void configure(Binder binder) {
            binder.install((Module)new C());
        }
    }

    private static class A
    extends AbstractModule {
        private A() {
        }

        public void configure() {
            this.install(new B());
        }
    }
}

